/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.cfg;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.WbBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.interceptor.AroundInvoke;
import javax.webbeans.Interceptor;
import javax.webbeans.InterceptorBindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WbInterceptor {
    private static final L10N L = new L10N(WbInterceptor.class);
    private Class _cl;
    private ArrayList<WbBinding> _bindingList = new ArrayList();
    private Method _invokeMethod;

    WbInterceptor(Class cl) {
        if (!cl.isAnnotationPresent(Interceptor.class)) {
            throw new ConfigException(L.l("'{0}' must have an @Interceptor annotation to be declared as an interceptor.", (Object)cl.getName()));
        }
        this._cl = cl;
        for (Annotation ann : cl.getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(InterceptorBindingType.class)) continue;
            this._bindingList.add(new WbBinding(ann));
        }
        if (this._bindingList.size() == 0) {
            throw new ConfigException(L.l("'{0}' must have at least one @InterceptorBindingType annotation to be declared as an interceptor.", (Object)cl.getName()));
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(AroundInvoke.class)) continue;
            if (this._invokeMethod != null) {
                throw new ConfigException(L.l("'{0}' has two @AroundInvoke methods: '{1}' and '{2}'.", (Object)cl.getName(), (Object)this._invokeMethod, (Object)method));
            }
            this._invokeMethod = method;
        }
        if (this._invokeMethod == null) {
            throw new ConfigException(L.l("'{0}' must have at least one @AroundInvoke method", (Object)cl.getName()));
        }
    }

    public Class getInterceptorClass() {
        return this._cl;
    }

    public Method getMethod() {
        return this._invokeMethod;
    }

    public Object getObject() {
        try {
            return this._cl.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public boolean isMatch(ArrayList<Annotation> bindList) {
        for (int i = 0; i < this._bindingList.size(); ++i) {
            if (this.isMatch(this._bindingList.get(i), bindList)) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(WbBinding binding, ArrayList<Annotation> bindList) {
        for (int i = 0; i < bindList.size(); ++i) {
            if (!binding.isMatch(bindList.get(i))) continue;
            return true;
        }
        return false;
    }
}

