/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.webbeans.Singleton;
import com.caucho.webbeans.cfg.WbComponentConfig;
import com.caucho.webbeans.cfg.WbComponentType;
import com.caucho.webbeans.cfg.WbInterceptor;
import com.caucho.webbeans.component.ClassComponent;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.SingletonClassComponent;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.webbeans.Component;
import javax.webbeans.ComponentType;
import javax.webbeans.Standard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WbWebBeans {
    private static final L10N L = new L10N(WbWebBeans.class);
    private static final Logger log = Logger.getLogger(WbWebBeans.class.getName());
    private WebBeansContainer _webBeansContainer;
    private Path _root;
    private Path _webBeansFile;
    private HashMap<String, WbComponentType> _componentTypeMap = new HashMap();
    private ArrayList<WbComponentType> _componentTypeList;
    private ArrayList<ComponentImpl> _pendingComponentList = new ArrayList();
    private ArrayList<ComponentImpl> _pendingBindList = new ArrayList();
    private ArrayList<WbInterceptor> _enabledInterceptors;
    private ArrayList<Class> _pendingClasses = new ArrayList();
    private boolean _isConfigured;

    public WbWebBeans(WebBeansContainer webBeansContainer, Path root) {
        this._webBeansContainer = webBeansContainer;
        this._root = root;
        this._webBeansFile = root.lookup("META-INF/web-beans.xml");
        this._webBeansFile.setUserPath(this._webBeansFile.getURL());
    }

    public WebBeansContainer getContainer() {
        return this._webBeansContainer;
    }

    public ClassLoader getClassLoader() {
        return this.getContainer().getClassLoader();
    }

    public Path getRoot() {
        return this._root;
    }

    public void addScannedClass(Class cl) {
        this._pendingClasses.add(cl);
    }

    public boolean isConfigured() {
        return this._isConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this._isConfigured = isConfigured;
    }

    public WbComponentConfig createComponent() {
        return new WbComponentConfig(this);
    }

    public void addWbComponent(ComponentImpl component) {
        this._pendingComponentList.remove(component);
        this._pendingComponentList.add(component);
    }

    public WbComponentTypes createComponentTypes() {
        return new WbComponentTypes();
    }

    public Interceptors createInterceptors() {
        return new Interceptors();
    }

    public ArrayList<WbInterceptor> getEnabledInterceptors() {
        return this._enabledInterceptors;
    }

    public ArrayList<WbInterceptor> findInterceptors(ArrayList<Annotation> bindingList) {
        ArrayList<WbInterceptor> list = null;
        if (this._enabledInterceptors != null) {
            for (WbInterceptor interceptor : this._enabledInterceptors) {
                if (!interceptor.isMatch(bindingList)) continue;
                if (list == null) {
                    list = new ArrayList<WbInterceptor>();
                }
                list.add(interceptor);
            }
        }
        return list;
    }

    @PostConstruct
    public void init() {
        if (this._componentTypeList == null) {
            this._componentTypeList = new ArrayList();
            WbComponentType type = this.createComponentType(Standard.class);
            type.setPriority(0);
            this._componentTypeList.add(type);
            type = this.createComponentType(Component.class);
            type.setPriority(1);
            this._componentTypeList.add(type);
        }
        this.update();
    }

    public void update() {
        WebBeansContainer webBeans = this._webBeansContainer;
        try {
            if (this._pendingClasses.size() > 0) {
                ArrayList<Class> pendingClasses = new ArrayList<Class>(this._pendingClasses);
                this._pendingClasses.clear();
                for (Class cl : pendingClasses) {
                    ClassComponent component = cl.isAnnotationPresent(Singleton.class) ? new SingletonClassComponent(this) : new ClassComponent(this);
                    component.setInstanceClass(cl);
                    component.setTargetType(cl);
                    component.setFromClass(true);
                    component.introspect();
                    component.init();
                    this._pendingComponentList.add(component);
                }
            }
            if (this._pendingComponentList.size() > 0) {
                ArrayList<ComponentImpl> componentList = new ArrayList<ComponentImpl>(this._pendingComponentList);
                this._pendingComponentList.clear();
                for (ComponentImpl comp : componentList) {
                    if (!comp.getType().isEnabled()) continue;
                    webBeans.addComponent(comp);
                }
            }
        }
        catch (Exception e) {
            throw LineConfigException.create((String)this._webBeansFile.getURL(), (int)1, (Throwable)e);
        }
    }

    public WbComponentType createComponentType(Class cl) {
        WbComponentType type = this._componentTypeMap.get(cl.getName());
        if (type == null) {
            type = new WbComponentType(cl);
            this._componentTypeMap.put(cl.getName(), type);
        }
        return type;
    }

    public ScopeContext getScopeContext(Class cl) {
        return this._webBeansContainer.getScopeContext(cl);
    }

    public ComponentImpl bindParameter(String loc, Type type, Annotation[] annotations) {
        return this._webBeansContainer.bind(loc, type, annotations);
    }

    public String toString() {
        if (this._root != null) {
            return "WbWebBeans[" + this._root.getURL() + "]";
        }
        return "WbWebBeans[]";
    }

    public void addEnabledInterceptor(Class cl) {
        if (this._enabledInterceptors == null) {
            this._enabledInterceptors = new ArrayList();
        }
        this._enabledInterceptors.add(new WbInterceptor(cl));
    }

    public class Interceptors {
        public void addInterceptor(Class cl) {
            if (WbWebBeans.this._enabledInterceptors == null) {
                WbWebBeans.this._enabledInterceptors = new ArrayList();
            }
            WbWebBeans.this._enabledInterceptors.add(new WbInterceptor(cl));
        }
    }

    public class WbComponentTypes {
        public void addComponentType(Class cl) {
            if (!cl.isAnnotationPresent(ComponentType.class)) {
                throw new ConfigException(L.l("'{0}' is missing a @ComponentType annotation.  Component annotations must be annotated with @ComponentType.", (Object)cl.getName()));
            }
            if (WbWebBeans.this._componentTypeList == null) {
                WbWebBeans.this._componentTypeList = new ArrayList();
            }
            int priority = WbWebBeans.this._componentTypeList.size();
            WbComponentType type = WbWebBeans.this.createComponentType(cl);
            type.setPriority(priority);
            WbWebBeans.this._componentTypeList.add(type);
        }
    }
}

