/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.component;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.ejb3.gen.PojoBean;
import com.caucho.util.L10N;
import com.caucho.webbeans.bytecode.ScopeAdapter;
import com.caucho.webbeans.bytecode.SerializationAdapter;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.cfg.WbInterceptor;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.ProducesComponent;
import com.caucho.webbeans.component.SingletonComponent;
import com.caucho.webbeans.event.ObserverImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.webbeans.BindingType;
import javax.webbeans.Component;
import javax.webbeans.ComponentType;
import javax.webbeans.EventBindingType;
import javax.webbeans.In;
import javax.webbeans.InterceptorBindingType;
import javax.webbeans.Named;
import javax.webbeans.Observes;
import javax.webbeans.Produces;
import javax.webbeans.ScopeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassComponent
extends ComponentImpl {
    private static final L10N L = new L10N(ClassComponent.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private Class _cl;
    private boolean _isBound;
    private Constructor _ctor;
    private ConfigProgram[] _newArgs;
    private ComponentImpl[] _ctorArgs;
    private Object _scopeAdapter;
    private HashMap<Method, ArrayList<WbInterceptor>> _interceptorMap;
    private Class _proxyClass;
    private String _mbeanName;
    private Class _mbeanInterface;

    public ClassComponent(WbWebBeans webbeans) {
        super(webbeans);
    }

    public void setInstanceClass(Class cl) {
        this._cl = cl;
        if (this.getTargetType() == null) {
            this.setTargetType(cl);
        }
    }

    public Class getInstanceClass() {
        return this._cl;
    }

    public void setConstructor(Constructor ctor) {
        this._ctor = ctor;
    }

    public void setMBeanName(String name) {
        this._mbeanName = name;
    }

    public Class getMBeanInterface() {
        return this._mbeanInterface;
    }

    public void setNewArgs(ArrayList<ConfigProgram> args) {
        if (args != null) {
            this._newArgs = new ConfigProgram[args.size()];
            args.toArray(this._newArgs);
        }
    }

    @Override
    public void init() {
        this.introspect();
        super.init();
    }

    @Override
    public void introspect() {
        Class cl = this.getInstanceClass();
        Class<? extends Annotation> scopeClass = null;
        if (this.getType() == null) {
            for (Annotation ann : cl.getDeclaredAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(ComponentType.class)) continue;
                if (this.getType() != null) {
                    throw new ConfigException(L.l("{0}: component type annotation @{1} conflicts with @{2}.  WebBeans components may only have a single @ComponentType.", (Object)cl.getName(), (Object)this.getType().getType().getName(), (Object)ann.annotationType().getName()));
                }
                this.setType(this._webbeans.createComponentType(ann.annotationType()));
            }
        }
        if (this.getType() == null) {
            this.setType(this._webbeans.createComponentType(Component.class));
        }
        if (this.getScope() == null) {
            for (Annotation ann : cl.getDeclaredAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(ScopeType.class)) continue;
                if (scopeClass != null) {
                    throw new ConfigException(L.l("{0}: @ScopeType annotation @{1} conflicts with @{2}.  WebBeans components may only have a single @ScopeType.", (Object)cl.getName(), (Object)scopeClass.getName(), (Object)ann.annotationType().getName()));
                }
                scopeClass = ann.annotationType();
                this.setScope(this._webbeans.getScopeContext(scopeClass));
            }
        }
        if (this.getName() == null) {
            String name = cl.getSimpleName();
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            this.setName(name);
        }
        this.introspectProduces();
        this.introspectConstructor();
        if (this.getBindingList().size() == 0) {
            this.introspectBindings();
        }
        this.introspectMBean();
    }

    private void introspectProduces() {
        if (this._cl == null) {
            return;
        }
        for (Method method : this._cl.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(Produces.class)) continue;
            if (method.isAnnotationPresent(In.class)) {
                throw this.error(method, L.l("@Produces method may not have an @In annotation."));
            }
            ProducesComponent comp = new ProducesComponent(this._webbeans, this, method);
            this._webbeans.addWbComponent(comp);
            comp.init();
        }
    }

    protected void introspectConstructor() {
        if (this._ctor != null) {
            return;
        }
        try {
            Constructor<?> best = null;
            Constructor<?> second = null;
            for (Constructor<?> ctor : this._cl.getDeclaredConstructors()) {
                if (this._newArgs != null && ctor.getParameterTypes().length != this._newArgs.length) continue;
                if (best == null) {
                    best = ctor;
                    continue;
                }
                if (this.hasBindingAnnotation(ctor)) {
                    if (best != null && this.hasBindingAnnotation(best)) {
                        throw new ConfigException(L.l("WebBean {0} has two constructors with binding annotations.", (Object)ctor.getDeclaringClass().getName()));
                    }
                    best = ctor;
                    second = null;
                    continue;
                }
                if (ctor.getParameterTypes().length == 0) {
                    best = ctor;
                    continue;
                }
                if (best.getParameterTypes().length == 0) continue;
                second = ctor;
            }
            if (second != null) {
                throw new ConfigException(L.l("{0}: WebBean does not have a unique constructor.  One constructor must be marked with @In or have a binding annotation.", (Object)this._cl.getName()));
            }
            if (best == null) {
                throw new ConfigException(L.l("{0}: no constructor found", (Object)this._cl.getName()));
            }
            this._ctor = best;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private void introspectMBean() {
        if (this._cl == null) {
            return;
        }
        if (this._mbeanInterface != null) {
            return;
        }
        for (Class<?> iface : this._cl.getInterfaces()) {
            if (!iface.getName().endsWith("MBean") && !iface.getName().endsWith("MXBean")) continue;
            this._mbeanInterface = iface;
            return;
        }
    }

    protected String getMBeanName() {
        if (this._mbeanName != null) {
            return this._mbeanName;
        }
        if (this._mbeanInterface == null) {
            return null;
        }
        String typeName = this._mbeanInterface.getSimpleName();
        if (typeName.endsWith("MXBean")) {
            typeName = typeName.substring(0, typeName.length() - "MXBean".length());
        } else if (typeName.endsWith("MBean")) {
            typeName = typeName.substring(0, typeName.length() - "MBean".length());
        }
        String name = this.getName();
        if (name == null) {
            return "type=" + typeName;
        }
        if (name.equals("")) {
            return "type=" + typeName + ",name=default";
        }
        return "type=" + typeName + ",name=" + name;
    }

    @Override
    public Object get(ConfigContext env) {
        try {
            Object value;
            boolean isNew = false;
            if (env.canInject(this._scope)) {
                if (this._scope != null ? (value = this._scope.get(this, false)) != null : (value = env.get(this)) != null) {
                    return value;
                }
                value = this.createNew(env);
                if (this._scope != null) {
                    this._scope.put(this, value);
                    env = new ConfigContext(this, value, this._scope);
                } else {
                    env.put(this, value);
                }
                this.init(value, env);
            } else {
                if (env != null && (value = env.get(this)) != null) {
                    return value;
                }
                value = this._scopeAdapter;
                if (value == null) {
                    ScopeAdapter scopeAdapter = ScopeAdapter.create(this.getInstanceClass());
                    value = this._scopeAdapter = scopeAdapter.wrap(this);
                }
                env.put(this, value);
            }
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object createNew(ConfigContext env) {
        try {
            Object[] args;
            if (!this._isBound) {
                this.bind();
            }
            if (this._ctorArgs != null && this._ctorArgs.length > 0) {
                args = new Object[this._ctorArgs.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this._ctorArgs[i].create();
                }
            } else {
                args = NULL_ARGS;
            }
            Object value = this._ctor.newInstance(args);
            if (this.isSingleton()) {
                SerializationAdapter.setHandle(value, this.getHandle());
            }
            if (env != null) {
                env.put(this, value);
            }
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind() {
        ClassComponent classComponent = this;
        synchronized (classComponent) {
            if (this._isBound) {
                return;
            }
            this._isBound = true;
            ArrayList<ConfigProgram> injectList = new ArrayList<ConfigProgram>();
            InjectIntrospector.introspectInject(injectList, this._cl);
            this._injectProgram = new ConfigProgram[injectList.size()];
            injectList.toArray(this._injectProgram);
            ArrayList<ConfigProgram> initList = new ArrayList<ConfigProgram>();
            InjectIntrospector.introspectInit(initList, this._cl);
            this._initProgram = new ConfigProgram[initList.size()];
            initList.toArray(this._initProgram);
            ArrayList<ConfigProgram> destroyList = new ArrayList<ConfigProgram>();
            InjectIntrospector.introspectDestroy(destroyList, this._cl);
            this._destroyProgram = new ConfigProgram[destroyList.size()];
            destroyList.toArray(this._destroyProgram);
            if (this._ctor == null) {
                this.introspectConstructor();
            }
            if (this._ctor != null) {
                String loc = this._ctor.getDeclaringClass().getName() + "(): ";
                Type[] param = this._ctor.getGenericParameterTypes();
                Annotation[][] paramAnn = this._ctor.getParameterAnnotations();
                ComponentImpl[] ctorArgs = new ComponentImpl[param.length];
                for (int i = 0; i < param.length; ++i) {
                    if (this._newArgs != null && i < this._newArgs.length) {
                        ConfigProgram argProgram = this._newArgs[i];
                        ConfigType type = TypeFactory.getType(param[i]);
                        ctorArgs[i] = this.createArg(type, argProgram);
                    }
                    if (ctorArgs[i] == null) {
                        ctorArgs[i] = this._webbeans.bindParameter(loc, param[i], paramAnn[i]);
                    }
                    if (ctorArgs[i] != null) continue;
                    throw new ConfigException(L.l("{0} does not have valid arguments", (Object)this._ctor));
                }
                this._ctorArgs = ctorArgs;
            }
            this.introspectObservers();
            PojoBean bean = new PojoBean(this._cl);
            bean.setSingleton(this.isSingleton());
            bean.introspect();
            Class instanceClass = bean.generateClass();
            if (instanceClass == this._cl && this.isSingleton()) {
                instanceClass = SerializationAdapter.gen(this._cl);
            }
            if (instanceClass != null && instanceClass != this._cl) {
                try {
                    if (this._ctor != null) {
                        this._ctor = instanceClass.getConstructor(this._ctor.getParameterTypes());
                    }
                    this.setInstanceClass(instanceClass);
                }
                catch (Exception e) {
                    throw ConfigException.create((Throwable)e);
                }
            }
        }
    }

    protected ComponentImpl createArg(ConfigType type, ConfigProgram program) {
        Object value = program.configure(type);
        if (value != null) {
            return new SingletonComponent(this.getWebBeans(), value);
        }
        return null;
    }

    @Override
    protected void introspectBindings() {
        ArrayList<WbBinding> bindings = new ArrayList<WbBinding>();
        for (Annotation ann : this.getInstanceClass().getAnnotations()) {
            if (ann.annotationType().isAnnotationPresent(BindingType.class)) {
                bindings.add(new WbBinding(ann));
            }
            if (!(ann instanceof Named)) continue;
            this.setName(((Named)ann).value());
        }
        if (bindings.size() > 0) {
            this.setBindingList(bindings);
        }
    }

    protected void introspectObservers() {
        for (Method method : this.getInstanceClass().getDeclaredMethods()) {
            int param = this.findObserverAnnotation(method);
            if (param < 0) continue;
            if (method.isAnnotationPresent(In.class)) {
                throw this.error(method, "@Observer may not have an @In attribute");
            }
            ArrayList<WbBinding> bindingList = new ArrayList<WbBinding>();
            Annotation[][] annList = method.getParameterAnnotations();
            if (annList != null && annList[param] != null) {
                for (Annotation ann : annList[param]) {
                    if (!ann.annotationType().isAnnotationPresent(EventBindingType.class)) continue;
                    bindingList.add(new WbBinding(ann));
                }
            }
            ObserverImpl observer = new ObserverImpl(this, method, param);
            observer.setBindingList(bindingList);
            this._webbeans.getContainer().addObserver(observer);
        }
    }

    protected void introspectInterceptors() {
        for (Method method : this.getInstanceClass().getMethods()) {
            ArrayList<WbInterceptor> interceptors;
            ArrayList<Annotation> interceptorTypes;
            if (method.getDeclaringClass().equals(Object.class) || (interceptorTypes = this.findInterceptorTypes(method)) == null || (interceptors = this._webbeans.findInterceptors(interceptorTypes)) == null) continue;
            if (this._interceptorMap == null) {
                this._interceptorMap = new HashMap();
            }
            this._interceptorMap.put(method, interceptors);
        }
    }

    private ArrayList<Annotation> findInterceptorTypes(Method method) {
        ArrayList<Annotation> types = null;
        for (Annotation ann : method.getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(InterceptorBindingType.class)) continue;
            if (types == null) {
                types = new ArrayList<Annotation>();
            }
            types.add(ann);
        }
        return types;
    }

    private boolean hasBindingAnnotation(Constructor ctor) {
        Annotation[][] paramAnn;
        if (ctor.isAnnotationPresent(In.class)) {
            return true;
        }
        Annotation[][] arr$ = paramAnn = ctor.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation ann : annotations = arr$[i$]) {
                if (!ann.annotationType().isAnnotationPresent(BindingType.class)) continue;
                return true;
            }
        }
        return false;
    }

    private int findObserverAnnotation(Method method) {
        Annotation[][] paramAnn = method.getParameterAnnotations();
        int observer = -1;
        for (int i = 0; i < paramAnn.length; ++i) {
            for (Annotation ann : paramAnn[i]) {
                if (!(ann instanceof Observes)) continue;
                if (observer >= 0) {
                    throw WebBeansContainer.error(method, L.l("Only one param may have an @Observer"));
                }
                observer = i;
            }
        }
        return observer;
    }
}

