/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.component;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.FieldComponentProgram;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.Base64;
import com.caucho.util.Crc64;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.Binding;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.cfg.WbComponentType;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.WebBeansHandle;
import com.caucho.webbeans.context.ApplicationScope;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.SingletonScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.webbeans.Component;
import javax.webbeans.ComponentFactory;
import javax.webbeans.Named;
import javax.webbeans.ScopeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentImpl
implements ComponentFactory,
ObjectProxy {
    private static final L10N L = new L10N(ComponentImpl.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private static final ConfigProgram[] NULL_INJECT = new ConfigProgram[0];
    protected WbWebBeans _webbeans;
    private WbComponentType _type;
    private Type _targetType;
    private boolean _isFromClass;
    private String _name;
    private boolean _hasBinding;
    private ArrayList<WbBinding> _bindingList = new ArrayList();
    private WebBeansHandle _handle;
    protected ScopeContext _scope;
    private String _scopeId;
    protected ConfigProgram[] _injectProgram = NULL_INJECT;
    protected ConfigProgram[] _initProgram = NULL_INJECT;
    protected ConfigProgram[] _destroyProgram = NULL_INJECT;
    private ContainerProgram _init;

    public ComponentImpl(WbWebBeans webbeans) {
        this._webbeans = webbeans;
    }

    public WbWebBeans getWebBeans() {
        return this._webbeans;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void addNameBinding(String name) {
        WbBinding binding = new WbBinding();
        binding.setClass(Named.class);
        binding.addValue("value", (Object)name);
        this._bindingList.add(binding);
    }

    public WbComponentType getType() {
        return this._type;
    }

    public void setType(WbComponentType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this._type = type;
    }

    public void setTargetType(Type type) {
        this._targetType = type;
    }

    public Type getTargetType() {
        return this._targetType;
    }

    public String getTargetSimpleName() {
        if (this._targetType instanceof Class) {
            return ((Class)this._targetType).getSimpleName();
        }
        return String.valueOf(this._targetType);
    }

    public Class getTargetClass() {
        if (this._targetType instanceof Class) {
            return (Class)this._targetType;
        }
        if (this._targetType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this._targetType).getRawType();
        }
        return (Class)this._targetType;
    }

    public String getClassName() {
        if (this._targetType instanceof Class) {
            return ((Class)this._targetType).getName();
        }
        return String.valueOf(this._targetType);
    }

    public void setBindingList(ArrayList<WbBinding> bindingList) {
        this._bindingList = bindingList;
    }

    public ArrayList<WbBinding> getBindingList() {
        return this._bindingList;
    }

    public void setScope(ScopeContext scope) {
        this._scope = scope;
    }

    public ScopeContext getScope() {
        return this._scope;
    }

    public boolean isSingleton() {
        return this._scope instanceof SingletonScope || this._scope instanceof ApplicationScope;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public void addProgram(ConfigProgram program) {
        if (this._init == null) {
            this._init = new ContainerProgram();
        }
        this._init.addProgram(program);
    }

    public void setFromClass(boolean isFromClass) {
        this._isFromClass = isFromClass;
    }

    public boolean isFromClass() {
        return this._isFromClass;
    }

    public WebBeansHandle getHandle() {
        return this._handle;
    }

    public void init() {
        this.introspect();
        if (this._type == null) {
            this._type = this._webbeans.createComponentType(Component.class);
        }
        this.generateScopeId();
        this._handle = new WebBeansHandle(this._targetType, this._bindingList);
    }

    protected void introspect() {
    }

    private void generateScopeId() {
        long crc64 = 17L;
        crc64 = Crc64.generate((long)crc64, (String)String.valueOf(this._targetType));
        if (this._name != null) {
            crc64 = Crc64.generate((long)crc64, (String)this._name);
        }
        for (WbBinding binding : this._bindingList) {
            crc64 = binding.generateCrc64(crc64);
        }
        StringBuilder sb = new StringBuilder();
        Base64.encode((StringBuilder)sb, (long)crc64);
        this._scopeId = sb.toString();
    }

    protected void introspectScope(Class type) {
        Class<? extends Annotation> scopeClass = null;
        if (this.getScope() == null) {
            for (Annotation ann : type.getDeclaredAnnotations()) {
                if (!ann.annotationType().isAnnotationPresent(ScopeType.class)) continue;
                if (scopeClass != null) {
                    throw new ConfigException(L.l("{0}: @ScopeType annotation @{1} conflicts with @{2}.  WebBeans components may only have a single @ScopeType.", (Object)type.getName(), (Object)scopeClass.getName(), (Object)ann.annotationType().getName()));
                }
                scopeClass = ann.annotationType();
                this.setScope(this._webbeans.getScopeContext(scopeClass));
            }
        }
    }

    protected void introspectBindings() {
    }

    public boolean isMatch(ArrayList<Annotation> bindList) {
        for (int i = 0; i < bindList.size(); ++i) {
            if (this.isMatch(bindList.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(Annotation bindAnn) {
        for (int i = 0; i < this._bindingList.size(); ++i) {
            if (!this._bindingList.get(i).isMatch(bindAnn)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatchByBinding(ArrayList<Binding> bindList) {
        for (int i = 0; i < bindList.size(); ++i) {
            if (this.isMatchByBinding(bindList.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isMatchByBinding(Binding binding) {
        for (int i = 0; i < this._bindingList.size(); ++i) {
            if (!this._bindingList.get(i).isMatch(binding)) continue;
            return true;
        }
        return false;
    }

    public Object getIfExists() {
        if (this._scope != null) {
            return this._scope.get(this, false);
        }
        return this.get();
    }

    public Object get() {
        Object value;
        if (this._scope != null && (value = this._scope.get(this, false)) != null) {
            return value;
        }
        return this.create();
    }

    public Object get(ConfigContext env) {
        Object value;
        if (this._scope != null ? (value = this._scope.get(this, false)) != null : (value = env.get(this)) != null) {
            return value;
        }
        if (this._scope != null) {
            value = this.createNew(null);
            this._scope.put(this, value);
            env = new ConfigContext(this, value, this._scope);
        } else {
            value = this.createNew(env);
        }
        this.init(value, env);
        return value;
    }

    public Object create() {
        try {
            ConfigContext env = new ConfigContext(this._scope);
            Object value = this.createNew(env);
            env.put(this, value);
            if (this._scope != null) {
                this._scope.put(this, value);
            }
            this.init(value, env);
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object createNoInit() {
        try {
            Object value = this.createNew(null);
            if (this._injectProgram.length > 0) {
                ConfigContext env = new ConfigContext(this, value, null);
                for (ConfigProgram program : this._injectProgram) {
                    program.inject(value, env);
                }
            }
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object createNew(ConfigContext env) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected Object init(Object value, ConfigContext env) {
        if (this._init != null) {
            this._init.inject(value, env);
        }
        for (ConfigProgram inject : this._injectProgram) {
            inject.inject(value, env);
        }
        for (ConfigProgram inject : this._initProgram) {
            inject.inject(value, env);
        }
        if (this._destroyProgram.length > 0) {
            env.addDestructor(this, value);
        }
        return value;
    }

    public boolean isDestroyPresent() {
        return this._destroyProgram.length > 0;
    }

    public void destroy(Object value, ConfigContext env) {
        for (ConfigProgram inject : this._destroyProgram) {
            inject.inject(value, env);
        }
    }

    public void destroy(Object value) {
        this.destroy(value, null);
    }

    public void bind() {
    }

    public void createProgram(ArrayList<ConfigProgram> initList, Field field) throws ConfigException {
        initList.add(new FieldComponentProgram(this, field));
    }

    public String getScopeId() {
        return this._scopeId;
    }

    @Override
    public Object createObject(Hashtable env) {
        return this.get();
    }

    protected ConfigException error(Method method, String msg) {
        return new ConfigException(LineConfigException.loc((Method)method) + msg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentImpl)) {
            return false;
        }
        ComponentImpl comp = (ComponentImpl)obj;
        if (!this._targetType.equals(comp._targetType)) {
            return false;
        }
        int size = this._bindingList.size();
        if (size != comp._bindingList.size()) {
            return false;
        }
        for (int i = size - 1; i >= 0; --i) {
            if (comp._bindingList.contains(this._bindingList.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        if (this._targetType instanceof Class) {
            sb.append(((Class)this._targetType).getSimpleName());
        } else {
            sb.append(String.valueOf(this._targetType));
        }
        sb.append("[");
        for (WbBinding binding : this._bindingList) {
            sb.append(binding.toDebugString());
            sb.append(",");
        }
        if (this._type != null) {
            sb.append("@");
            sb.append(this._type.getType().getSimpleName());
        } else {
            sb.append("@null");
        }
        if (this._scope != null) {
            sb.append(", @");
            sb.append(this._scope.getClass().getSimpleName());
        }
        if (this._name != null) {
            sb.append(", name=");
            sb.append(this._name);
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this._targetType instanceof Class) {
            sb.append(((Class)this._targetType).getSimpleName());
        } else {
            sb.append(String.valueOf(this._targetType));
        }
        sb.append(", ");
        if (this._type != null) {
            sb.append("@");
            sb.append(this._type.getType().getSimpleName());
        } else {
            sb.append("@null");
        }
        if (this._name != null) {
            sb.append(", ");
            sb.append("name=");
            sb.append(this._name);
        }
        if (this._scope != null) {
            sb.append(", @");
            sb.append(this._scope.getClass().getSimpleName());
        }
        sb.append("]");
        return sb.toString();
    }

    protected static String getSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return String.valueOf(type);
    }
}

