/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.component;

import com.caucho.config.ConfigContext;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.webbeans.BindingType;
import javax.webbeans.ComponentType;
import javax.webbeans.Named;
import javax.webbeans.ScopeType;

public class ProducesComponent
extends ComponentImpl {
    private static final L10N L = new L10N(ProducesComponent.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private final ComponentImpl _producer;
    private final Method _method;
    private ComponentImpl[] _args;
    private boolean _isBound;

    public ProducesComponent(WbWebBeans webbeans, ComponentImpl producer, Method method) {
        super(webbeans);
        this._producer = producer;
        this._method = method;
        this.setTargetType(method.getGenericReturnType());
    }

    public void init() {
        super.init();
    }

    public void introspect() {
        ArrayList<WbBinding> bindingList = new ArrayList<WbBinding>();
        for (Annotation ann : this._method.getAnnotations()) {
            if (ann instanceof Named) {
                this.setName(((Named)ann).value());
            }
            if (ann.annotationType().isAnnotationPresent(ComponentType.class) && this.getType() == null) {
                this.setType(this._webbeans.createComponentType(ann.annotationType()));
            }
            if (ann.annotationType().isAnnotationPresent(ScopeType.class) && this.getScope() == null) {
                this.setScope(this._webbeans.getScopeContext(ann.annotationType()));
            }
            if (!ann.annotationType().isAnnotationPresent(BindingType.class)) continue;
            bindingList.add(new WbBinding(ann));
        }
        if (this.getName() == null) {
            String methodName = this._method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3) {
                this.setName(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4));
            } else {
                this.setName(methodName);
            }
        }
        if (bindingList.size() > 0) {
            this.setBindingList(bindingList);
        }
        if (this.getType() == null) {
            this.setType(this._producer.getType());
        }
    }

    public Object createNew(ConfigContext env) {
        try {
            Object[] args;
            Object factory = this._producer.get();
            if (this._args == null) {
                this.bind();
            }
            if (this._args.length > 0) {
                args = new Object[this._args.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this._args[i].get();
                }
            } else {
                args = NULL_ARGS;
            }
            Object value = this._method.invoke(factory, args);
            if (env != null) {
                env.put(this, value);
            }
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        ProducesComponent producesComponent = this;
        synchronized (producesComponent) {
            if (this._isBound) {
                return;
            }
            this._isBound = true;
            String loc = WebBeansContainer.location(this._method);
            Type[] param = this._method.getGenericParameterTypes();
            Annotation[][] paramAnn = this._method.getParameterAnnotations();
            this._args = new ComponentImpl[param.length];
            for (int i = 0; i < param.length; ++i) {
                this._args[i] = this._webbeans.bindParameter(loc, param[i], paramAnn[i]);
                if (this._args[i] != null) continue;
                throw this.error(this._method, L.l("Type '{0}' for method parameter #{1} has no matching component.", (Object)ProducesComponent.getSimpleName(param[i]), i));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this.getName() != null) {
            sb.append("name=");
            sb.append(this.getName());
            sb.append(", ");
        }
        sb.append(this.getTargetSimpleName());
        sb.append(", ");
        sb.append(this._method.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("(), @");
        sb.append(this.getType().getType().getSimpleName());
        sb.append("]");
        return sb.toString();
    }
}

