/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.component;

import com.caucho.config.ConfigContext;
import com.caucho.jmx.Jmx;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.ClassComponent;
import com.caucho.webbeans.component.HandleAware;
import com.caucho.webbeans.context.SingletonScope;
import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SingletonClassComponent
extends ClassComponent
implements Closeable {
    private static final Logger log = Logger.getLogger(SingletonClassComponent.class.getName());
    private Object _value;

    public SingletonClassComponent(WbWebBeans webbeans) {
        super(webbeans);
        super.setScope(new SingletonScope());
    }

    public Object getIfExists() {
        return this.get();
    }

    public Object get() {
        if (this._value == null) {
            return this.get(null);
        }
        return this._value;
    }

    public Object get(ConfigContext env) {
        if (this._value == null) {
            this._value = this.createNew(null);
            this.init(this._value, new ConfigContext(this, this._value, new SingletonScope()));
            if (this._value instanceof HandleAware) {
                ((HandleAware)this._value).setSerializationHandle(this.getHandle());
            }
        }
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createNew(ConfigContext env) {
        ClassLoader loader = this.getWebBeans().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            Object object = super.createNew(env);
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object init(Object value, ConfigContext env) {
        ClassLoader loader = this.getWebBeans().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            value = super.init(value, env);
            try {
                if (this.getMBeanInterface() != null) {
                    Jmx.register(value, this.getMBeanName());
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            Object object = value;
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void close() {
        if (this._value != null) {
            this.destroy(this._value);
        }
    }
}

