/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.component;

import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.Binding;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansHandle
implements Serializable {
    private static final L10N L = new L10N(WebBeansHandle.class);
    private static final Logger log = Logger.getLogger(WebBeansHandle.class.getName());
    private Class _type;
    private HashMap<Class, HashMap<String, Object>> _binding;

    public WebBeansHandle() {
    }

    public WebBeansHandle(Class type) {
        this._type = type;
        this._binding = new HashMap();
    }

    public WebBeansHandle(Type type, ArrayList<WbBinding> bindingList) {
        if (type instanceof Class) {
            this._type = (Class)type;
        }
        this._binding = new HashMap();
        for (WbBinding binding : bindingList) {
            Class annType = binding.getBindingClass();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            for (WbBinding.WbBindingValue value : binding.getValueList()) {
                valueMap.put(value.getName(), value.getValue());
            }
            this._binding.put(annType, valueMap);
        }
    }

    public Object readResolve() {
        try {
            ArrayList<Binding> bindingList = new ArrayList<Binding>();
            for (Map.Entry<Class, HashMap<String, Object>> entry : this._binding.entrySet()) {
                Class type = entry.getKey();
                HashMap<String, Object> valueMap = entry.getValue();
                Binding binding = new Binding(type);
                for (Map.Entry<String, Object> bindingEntry : valueMap.entrySet()) {
                    binding.put(bindingEntry.getKey(), bindingEntry.getValue());
                }
                bindingList.add(binding);
            }
            WebBeansContainer webBeans = WebBeansContainer.create();
            ComponentImpl comp = webBeans.bindByBindings("", this._type, bindingList);
            if (comp != null) {
                return comp.get();
            }
            log.warning(L.l("'{0}' is an unknown WebBean at deserialization", (Object)this));
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._type + "," + this._binding + "]";
    }
}

