/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.context;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.server.webapp.WebApp;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.context.DestructionListener;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.SingletonScope;
import javax.webbeans.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationScope
extends ScopeContext {
    @Override
    public <T> T get(ComponentFactory<T> component, boolean create) {
        WebApp webApp = WebApp.getLocal();
        if (webApp != null) {
            ComponentImpl comp = (ComponentImpl)component;
            return (T)webApp.getAttribute(comp.getScopeId());
        }
        return null;
    }

    @Override
    public <T> void put(ComponentFactory<T> component, T value) {
        WebApp webApp = WebApp.getLocal();
        if (webApp != null) {
            ComponentImpl comp = (ComponentImpl)component;
            webApp.setAttribute(comp.getScopeId(), value);
        }
    }

    public <T> void remove(ComponentFactory<T> component) {
        WebApp webApp = WebApp.getLocal();
        if (webApp != null) {
            ComponentImpl comp = (ComponentImpl)component;
            webApp.removeAttribute(comp.getScopeId());
        }
    }

    @Override
    public boolean canInject(ScopeContext scope) {
        return scope instanceof SingletonScope || scope instanceof ApplicationScope;
    }

    @Override
    public void addDestructor(ComponentImpl comp, Object value) {
        EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
        if (loader != null) {
            DestructionListener listener = (DestructionListener)loader.getAttribute("caucho.destroy");
            if (listener == null) {
                listener = new DestructionListener();
                loader.setAttribute("caucho.destroy", listener);
                loader.addListener(listener);
            }
            listener.addValue(comp, value);
        }
    }
}

