/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.context;

import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.SingletonScope;
import java.util.IdentityHashMap;

public class DependentScope {
    private static final ThreadLocal<DependentScope> _threadScope = new ThreadLocal();
    private ComponentImpl _owner;
    private Object _value;
    private ScopeContext _scope;
    private IdentityHashMap<ComponentImpl, Object> _map;

    public DependentScope() {
    }

    public DependentScope(ComponentImpl owner, Object value, ScopeContext scope) {
        this._owner = owner;
        this._value = value;
        this._scope = scope;
    }

    public DependentScope(ScopeContext scope) {
        this._scope = scope;
    }

    public static DependentScope getCurrent() {
        return _threadScope.get();
    }

    public static DependentScope begin(ScopeContext ownerScope) {
        throw new UnsupportedOperationException();
    }

    public static void end(DependentScope oldScope) {
        _threadScope.set(oldScope);
    }

    public Object get(ComponentImpl comp) {
        if (comp == this._owner) {
            return this._value;
        }
        if (this._map != null) {
            return this._map.get(comp);
        }
        return null;
    }

    public void put(ComponentImpl comp, Object value) {
        if (this._map == null) {
            this._map = new IdentityHashMap(8);
        }
        this._map.put(comp, value);
    }

    public boolean canInject(ScopeContext scope) {
        if (scope == null) {
            return true;
        }
        if (this._scope == null) {
            return scope instanceof SingletonScope;
        }
        return this._scope.canInject(scope);
    }

    public void addDestructor(ComponentImpl comp, Object value) {
        if (this._scope != null) {
            this._scope.addDestructor(comp, value);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._owner + "," + this._scope + "]";
    }
}

