/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.context;

import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.context.ApplicationScope;
import com.caucho.webbeans.context.ConversationScope;
import com.caucho.webbeans.context.DestructionListener;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.SessionScope;
import com.caucho.webbeans.context.SingletonScope;
import javax.servlet.ServletRequest;
import javax.webbeans.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestScope
extends ScopeContext {
    @Override
    public <T> T get(ComponentFactory<T> component, boolean create) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            ComponentImpl comp = (ComponentImpl)component;
            Object value = request.getAttribute(comp.getScopeId());
            if (value == null && create) {
                value = component.create();
                request.setAttribute(comp.getScopeId(), value);
            }
            return (T)value;
        }
        return null;
    }

    @Override
    public <T> void put(ComponentFactory<T> component, T value) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            ComponentImpl comp = (ComponentImpl)component;
            request.setAttribute(comp.getScopeId(), value);
        }
    }

    public <T> void remove(ComponentFactory<T> component) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            ComponentImpl comp = (ComponentImpl)component;
            request.removeAttribute(comp.getScopeId());
        }
    }

    @Override
    public boolean canInject(ScopeContext scope) {
        return scope instanceof SingletonScope || scope instanceof ApplicationScope || scope instanceof SessionScope || scope instanceof ConversationScope || scope instanceof RequestScope;
    }

    @Override
    public void addDestructor(ComponentImpl comp, Object value) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            DestructionListener listener = (DestructionListener)request.getAttribute("caucho.destroy");
            if (listener == null) {
                listener = new DestructionListener();
                request.setAttribute("caucho.destroy", (Object)listener);
            }
            listener.addValue(comp, value);
        }
    }
}

