/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.context;

import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.context.ApplicationScope;
import com.caucho.webbeans.context.DestructionListener;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.SingletonScope;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.webbeans.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionScope
extends ScopeContext {
    @Override
    public <T> T get(ComponentFactory<T> component, boolean create) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            ComponentImpl comp = (ComponentImpl)component;
            return (T)session.getAttribute(comp.getScopeId());
        }
        return null;
    }

    @Override
    public <T> void put(ComponentFactory<T> component, T value) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            ComponentImpl comp = (ComponentImpl)component;
            session.setAttribute(comp.getScopeId(), value);
        }
    }

    public <T> void remove(ComponentFactory<T> component) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            ComponentImpl comp = (ComponentImpl)component;
            session.removeAttribute(comp.getScopeId());
        }
    }

    @Override
    public boolean canInject(ScopeContext scope) {
        return scope instanceof SingletonScope || scope instanceof ApplicationScope || scope instanceof SessionScope;
    }

    @Override
    public void addDestructor(ComponentImpl comp, Object value) {
        ServletRequest request = ServletInvocation.getContextRequest();
        if (request != null) {
            HttpSession session = ((HttpServletRequest)request).getSession();
            DestructionListener listener = (DestructionListener)session.getAttribute("caucho.destroy");
            if (listener == null) {
                listener = new DestructionListener();
                session.setAttribute("caucho.destroy", (Object)listener);
            }
            listener.addValue(comp, value);
        }
    }
}

