/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.context;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.context.DestructionListener;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.ScopeMap;
import javax.webbeans.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonScope
extends ScopeContext {
    private static final EnvironmentLocal<ScopeMap> _localScopeMap = new EnvironmentLocal();

    @Override
    public <T> T get(ComponentFactory<T> component, boolean create) {
        ScopeMap map = _localScopeMap.get();
        if (map != null) {
            ComponentImpl comp = (ComponentImpl)component;
            return map.get(comp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(ComponentFactory<T> component, T value) {
        ScopeMap<T> map;
        SingletonScope singletonScope = this;
        synchronized (singletonScope) {
            map = _localScopeMap.getLevel();
            if (map == null) {
                map = new ScopeMap<T>();
                _localScopeMap.set(map);
            }
        }
        map.put(component, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void remove(ComponentFactory<T> component) {
        ScopeMap map = _localScopeMap.getLevel();
        if (map != null) {
            ScopeMap scopeMap = map;
            synchronized (scopeMap) {
                map.remove(component);
            }
        }
    }

    @Override
    public void addDestructor(ComponentImpl comp, Object value) {
        EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
        if (loader != null) {
            DestructionListener listener = (DestructionListener)loader.getAttribute("caucho.destroy");
            if (listener == null) {
                listener = new DestructionListener();
                loader.setAttribute("caucho.destroy", listener);
                loader.addListener(listener);
            }
            listener.addValue(comp, value);
        }
    }
}

