/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.event;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.webbeans.IfExists;
import javax.webbeans.Observes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverImpl {
    private static final L10N L = new L10N(ObserverImpl.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private final ComponentImpl _component;
    private final Method _method;
    private final int _paramIndex;
    private boolean _hasBinding;
    private boolean _ifExists;
    private ComponentImpl[] _args;
    private ArrayList<WbBinding> _bindingList = new ArrayList();

    public ObserverImpl(ComponentImpl comp, Method method, int paramIndex) {
        this._component = comp;
        this._method = method;
        this._method.setAccessible(true);
        this._paramIndex = paramIndex;
        for (Annotation ann : method.getParameterAnnotations()[paramIndex]) {
            if (!(ann instanceof IfExists)) continue;
            this._ifExists = true;
        }
        this.bind();
    }

    public Class getType() {
        return this._method.getParameterTypes()[this._paramIndex];
    }

    public void setBindingList(ArrayList<WbBinding> bindingList) {
        this._bindingList = bindingList;
    }

    public ArrayList<WbBinding> getBindingList() {
        return this._bindingList;
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        ObserverImpl observerImpl = this;
        synchronized (observerImpl) {
            if (this._args != null) {
                return;
            }
            Type[] param = this._method.getGenericParameterTypes();
            Annotation[][] annList = this._method.getParameterAnnotations();
            this._args = new ComponentImpl[param.length];
            WebBeansContainer webBeans = this._component.getWebBeans().getContainer();
            String loc = LineConfigException.loc((Method)this._method);
            for (int i = 0; i < param.length; ++i) {
                if (this.hasObserves(annList[i])) continue;
                ComponentImpl comp = webBeans.bind(loc, param[i], annList[i]);
                if (comp == null) {
                    throw new ConfigException(loc + L.l("Parameter '{0}' binding does not have a matching component", (Object)ObserverImpl.getSimpleName(param[i])));
                }
                this._args[i] = comp;
            }
        }
    }

    private boolean hasObserves(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!(ann instanceof Observes)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatch(Annotation[] bindList) {
        int size = this._bindingList.size();
        if (bindList.length < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            WbBinding binding = this._bindingList.get(i);
            boolean isMatch = false;
            for (Annotation ann : bindList) {
                if (!binding.isMatch(ann)) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            return false;
        }
        return true;
    }

    public void raiseEvent(Object event) {
        Object obj = this._ifExists ? this._component.getIfExists() : this._component.get();
        try {
            if (obj != null) {
                Object[] args = new Object[this._args.length];
                for (int i = 0; i < this._args.length; ++i) {
                    ComponentImpl comp = this._args[i];
                    args[i] = comp != null ? comp.get() : event;
                }
                this._method.invoke(obj, args);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObserverImpl)) {
            return false;
        }
        ObserverImpl comp = (ObserverImpl)obj;
        if (!this._component.equals(comp._component)) {
            return false;
        }
        int size = this._bindingList.size();
        if (size != comp._bindingList.size()) {
            return false;
        }
        for (int i = size - 1; i >= 0; --i) {
            if (comp._bindingList.contains(this._bindingList.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._method.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("[");
        ComponentImpl comp = this._component;
        sb.append(comp.getTargetSimpleName());
        sb.append("]");
        return sb.toString();
    }

    protected static String getSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return String.valueOf(type);
    }
}

