/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.manager;

import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.j2ee.InjectProgram;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.MethodComponentProgram;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.webbeans.Names;
import com.caucho.webbeans.Singleton;
import com.caucho.webbeans.cfg.Binding;
import com.caucho.webbeans.cfg.WbBinding;
import com.caucho.webbeans.cfg.WbComponentType;
import com.caucho.webbeans.cfg.WbInterceptor;
import com.caucho.webbeans.cfg.WbWebBeans;
import com.caucho.webbeans.component.ClassComponent;
import com.caucho.webbeans.component.ComponentClose;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.component.SingletonComponent;
import com.caucho.webbeans.component.WebBeansHandle;
import com.caucho.webbeans.context.ApplicationScope;
import com.caucho.webbeans.context.ConversationScope;
import com.caucho.webbeans.context.RequestScope;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.webbeans.context.SessionScope;
import com.caucho.webbeans.context.SingletonScope;
import com.caucho.webbeans.event.ObserverImpl;
import com.caucho.webbeans.manager.ObserverMap;
import com.caucho.webbeans.manager.WebBeansRootContext;
import com.caucho.webbeans.manager.WebComponent;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.webbeans.ApplicationScoped;
import javax.webbeans.BindingType;
import javax.webbeans.ComponentFactory;
import javax.webbeans.ComponentType;
import javax.webbeans.Container;
import javax.webbeans.Context;
import javax.webbeans.Conversation;
import javax.webbeans.ConversationScoped;
import javax.webbeans.Dependent;
import javax.webbeans.Named;
import javax.webbeans.New;
import javax.webbeans.Produces;
import javax.webbeans.RequestScoped;
import javax.webbeans.SessionScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansContainer
implements ScanListener,
EnvironmentListener,
Container,
Serializable {
    private static final L10N L = new L10N(WebBeansContainer.class);
    private static final Logger log = Logger.getLogger(WebBeansContainer.class.getName());
    private static final String SCHEMA = "com/caucho/webbeans/cfg/webbeans.rnc";
    private static final EnvironmentLocal<WebBeansContainer> _localContainer = new EnvironmentLocal();
    private static final Annotation[] NULL_ANN = new Annotation[0];
    private WebBeansContainer _parent;
    private EnvironmentClassLoader _classLoader;
    private ClassLoader _tempClassLoader;
    private WbWebBeans _wbWebBeans;
    private HashMap<Path, WbWebBeans> _webBeansMap = new HashMap();
    private HashMap<Type, WebComponent> _componentMap = new HashMap();
    private HashMap<String, ComponentImpl> _namedComponentMap = new HashMap();
    private HashMap<Path, WebBeansRootContext> _rootContextMap = new HashMap();
    private HashMap<Class, Context> _contextMap = new HashMap();
    private HashMap<Class, ObserverMap> _observerMap = new HashMap();
    private HashMap<Class, ArrayList<ObserverMap>> _observerListCache = new HashMap();
    private HashMap<Class, ClassComponent> _transientMap = new HashMap();
    private HashMap<FactoryBinding, ComponentFactory> _objectFactoryMap = new HashMap();
    private ArrayList<WebBeansRootContext> _pendingRootContextList = new ArrayList();
    private ArrayList<ComponentImpl> _pendingBindList = new ArrayList();
    private ArrayList<ComponentImpl> _pendingSingletonList = new ArrayList();
    private HashMap<Class, InjectProgram> _injectMap = new HashMap();
    private RuntimeException _configException;

    private WebBeansContainer(ClassLoader loader) {
        this._classLoader = Environment.getEnvironmentClassLoader(loader);
        if (this._classLoader != null) {
            this._parent = WebBeansContainer.create(this._classLoader.getParent());
        }
        _localContainer.set(this, this._classLoader);
        this._tempClassLoader = this._classLoader != null ? this._classLoader.getNewTempClassLoader() : new DynamicClassLoader(null);
        this._wbWebBeans = new WbWebBeans(this, Vfs.lookup());
        this._contextMap.put(RequestScoped.class, new RequestScope());
        this._contextMap.put(SessionScoped.class, new SessionScope());
        this._contextMap.put(ConversationScoped.class, new ConversationScope());
        this._contextMap.put(ApplicationScoped.class, new ApplicationScope());
        this._contextMap.put(Singleton.class, new SingletonScope());
        if (this._classLoader != null) {
            this._classLoader.addScanListener(this);
        }
        Environment.addEnvironmentListener(this, this._classLoader);
    }

    public static WebBeansContainer getCurrent() {
        return WebBeansContainer.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebBeansContainer getCurrent(ClassLoader loader) {
        EnvironmentLocal<WebBeansContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            return _localContainer.get(loader);
        }
    }

    public static WebBeansContainer create() {
        return WebBeansContainer.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebBeansContainer create(ClassLoader loader) {
        WebBeansContainer webBeans = null;
        EnvironmentLocal<WebBeansContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            webBeans = _localContainer.getLevel(loader);
            if (webBeans != null) {
                return webBeans;
            }
            webBeans = new WebBeansContainer(loader);
            _localContainer.set(webBeans);
        }
        return webBeans;
    }

    public WbWebBeans getWbWebBeans() {
        return this._wbWebBeans;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    private void init() {
        try {
            this.update();
        }
        catch (RuntimeException e) {
            this._configException = e;
            throw this._configException;
        }
        catch (Exception e) {
            this._configException = ConfigException.create((Throwable)e);
            throw this._configException;
        }
        Environment.addEnvironmentListener(this);
    }

    public WbComponentType createComponentType(Class cl) {
        return this._wbWebBeans.createComponentType(cl);
    }

    public void addComponent(ComponentImpl comp) {
        this.addComponentByType(comp.getTargetType(), comp);
        String name = comp.getName();
        if (name != null) {
            this._namedComponentMap.put(name, comp);
        }
        this._pendingBindList.add(comp);
        if (comp.isSingleton()) {
            this._pendingSingletonList.add(comp);
        }
    }

    public void addComponentByName(String name, ComponentImpl comp) {
        this._namedComponentMap.put(name, comp);
    }

    public void addComponentByType(Type type, ComponentImpl comp) {
        if (type == null) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(comp.toDebugString() + " added to " + this);
        }
        if (comp.isSingleton()) {
            this._pendingSingletonList.add(comp);
        }
        this.addComponentRec(type, comp);
    }

    public ArrayList<ComponentFactory> getBeansOfType(Type type) {
        ArrayList<ComponentFactory> beans = new ArrayList<ComponentFactory>();
        WebComponent webComponent = this._componentMap.get(type);
        if (webComponent == null) {
            return beans;
        }
        beans.addAll(webComponent.getComponentList());
        return beans;
    }

    private void addComponentRec(Type type, ComponentImpl comp) {
        if (type == null || Object.class.equals((Object)type)) {
            return;
        }
        WebComponent webComponent = this._componentMap.get(type);
        if (webComponent == null) {
            webComponent = new WebComponent(type);
            this._componentMap.put(type, webComponent);
        }
        webComponent.addComponent(comp);
        if (!(type instanceof Class)) {
            if (type instanceof ParameterizedType) {
                Class cl = (Class)((ParameterizedType)type).getRawType();
                this.addComponentRec(cl, comp);
                return;
            }
            return;
        }
        Class cl = (Class)type;
        this.addComponentRec(cl.getSuperclass(), comp);
        for (Class<?> subClass : cl.getInterfaces()) {
            this.addComponentRec(subClass, comp);
        }
    }

    public void addSingleton(Object object) {
        SingletonComponent comp = new SingletonComponent(this._wbWebBeans, object);
        comp.init();
        this.addComponent(comp);
    }

    public void addSingleton(Object object, String name) {
        SingletonComponent comp = new SingletonComponent(this._wbWebBeans, object);
        comp.setName(name);
        WbBinding binding = new WbBinding();
        binding.setClass(Named.class);
        binding.addValue("value", (Object)name);
        ArrayList<WbBinding> bindingList = new ArrayList<WbBinding>();
        bindingList.add(binding);
        comp.setBindingList(bindingList);
        comp.init();
        this.addComponent(comp);
    }

    public void addSingleton(Object object, String name, Class componentType) {
        SingletonComponent comp = new SingletonComponent(this._wbWebBeans, object);
        comp.setName(name);
        comp.setType(this._wbWebBeans.createComponentType(componentType));
        WbBinding binding = new WbBinding();
        binding.setClass(Named.class);
        binding.addValue("value", (Object)name);
        ArrayList<WbBinding> bindingList = new ArrayList<WbBinding>();
        bindingList.add(binding);
        comp.setBindingList(bindingList);
        comp.init();
        this.addComponent(comp);
    }

    public void addSingletonByName(Object object, String name) {
        SingletonComponent comp = new SingletonComponent(this._wbWebBeans, object);
        comp.setName(name);
        comp.init();
        this._namedComponentMap.put(name, comp);
    }

    public void addEnabledInterceptor(Class cl) {
        this._wbWebBeans.addEnabledInterceptor(cl);
    }

    public ArrayList<Class> findInterceptors(ArrayList<Annotation> annList) {
        ArrayList<Class> list = new ArrayList<Class>();
        ArrayList<WbInterceptor> interceptors = this._wbWebBeans.findInterceptors(annList);
        if (interceptors != null) {
            this.addInterceptorClasses(list, interceptors);
            return list;
        }
        for (WbWebBeans wbWebBeans : this._webBeansMap.values()) {
            interceptors = wbWebBeans.findInterceptors(annList);
            if (interceptors == null) continue;
            this.addInterceptorClasses(list, interceptors);
        }
        return list;
    }

    private void addInterceptorClasses(ArrayList<Class> classes, ArrayList<WbInterceptor> interceptors) {
        for (WbInterceptor interceptor : interceptors) {
            classes.add(interceptor.getInterceptorClass());
        }
    }

    public ScopeContext getScopeContext(Class scope) {
        if (scope == null) {
            throw new NullPointerException();
        }
        if (Dependent.class.equals((Object)scope)) {
            return null;
        }
        Context context = this._contextMap.get(scope);
        if (context != null) {
            return (ScopeContext)context;
        }
        throw new IllegalArgumentException(L.l("'{0}' is an unknown scope.", (Object)scope.getName()));
    }

    public void createProgram(ArrayList<ConfigProgram> injectList, Field field) throws ConfigException {
        ComponentImpl component = this.bind(WebBeansContainer.location(field), field.getGenericType(), field.getAnnotations());
        if (component == null) {
            throw WebBeansContainer.injectError(field, L.l("Can't find a component for '{0}'", (Object)field.getType().getName()));
        }
        component.createProgram(injectList, field);
    }

    public void createProgram(ArrayList<ConfigProgram> injectList, Method method) throws ConfigException {
        if (method.isAnnotationPresent(Produces.class)) {
            throw WebBeansContainer.error(method, "An injection method may not have the @Produces annotation.");
        }
        try {
            Type[] paramTypes = method.getGenericParameterTypes();
            Annotation[][] paramAnn = method.getParameterAnnotations();
            ComponentImpl[] args = new ComponentImpl[paramTypes.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.bind(WebBeansContainer.location(method), paramTypes[i], paramAnn[i]);
                if (args[i] != null) continue;
                throw WebBeansContainer.error(method, L.l("Injection for type '{0}' of method parameter #{1} has no matching component.", (Object)WebBeansContainer.getSimpleName(paramTypes[i]), i));
            }
            injectList.add(new MethodComponentProgram(method, args));
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw LineConfigException.create((Method)method, (Throwable)e);
        }
    }

    public ComponentImpl bind(String location, Type type, String name) {
        ArrayList<Binding> bindingList = new ArrayList<Binding>();
        Binding binding = new Binding(Named.class);
        binding.put("value", name);
        bindingList.add(binding);
        return this.bindByBindings(location, type, bindingList);
    }

    public ComponentImpl bind(String location, Type type) {
        ArrayList<Binding> bindingList = new ArrayList<Binding>();
        return this.bindByBindings(location, type, bindingList);
    }

    public ComponentImpl bind(String location, Type type, Annotation[] paramAnn) {
        ArrayList<Annotation> bindingList = new ArrayList<Annotation>();
        boolean isNew = false;
        for (Annotation ann : paramAnn) {
            if (ann instanceof New) {
                isNew = true;
                continue;
            }
            if (!ann.annotationType().isAnnotationPresent(BindingType.class)) continue;
            bindingList.add(ann);
        }
        if (isNew) {
            return this.bindNew(location, (Class)type);
        }
        return this.bind(location, type, bindingList);
    }

    private ComponentImpl bindNew(String location, Class type) {
        ComponentImpl component = this.bind(location, (Type)type, new Annotation[0]);
        if (component == null) {
            ClassComponent newComp = new ClassComponent(this._wbWebBeans);
            newComp.setInstanceClass(type);
            newComp.setTargetType(type);
            newComp.init();
            this.addComponent(newComp);
            component = newComp;
        }
        return component;
    }

    public ComponentImpl bind(String location, Type type, ArrayList<Annotation> bindingList) {
        this._wbWebBeans.init();
        WebComponent component = this._componentMap.get(type);
        if (component != null) {
            ComponentImpl comp = component.bind(location, bindingList);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " bind(" + WebBeansContainer.getSimpleName(type) + ") returns " + comp);
            }
            return comp;
        }
        if (this._parent != null) {
            return this._parent.bind(location, type, bindingList);
        }
        return null;
    }

    public ComponentImpl bindByBindings(String location, Type type, ArrayList<Binding> bindingList) {
        this._wbWebBeans.init();
        WebComponent component = this._componentMap.get(type);
        if (component != null) {
            return component.bindByBindings(location, type, bindingList);
        }
        if (this._parent != null) {
            return this._parent.bindByBindings(location, type, bindingList);
        }
        return null;
    }

    public ComponentImpl findByName(String name) {
        if (this._namedComponentMap == null) {
            return null;
        }
        ComponentImpl comp = this._namedComponentMap.get(name);
        if (comp != null) {
            return comp;
        }
        if (this._parent != null) {
            return this._parent.findByName(name);
        }
        return null;
    }

    public Object getObjectByName(String name) {
        ComponentImpl comp = this._namedComponentMap.get(name);
        if (comp != null) {
            return comp.get();
        }
        if (this._parent != null) {
            return this._parent.getObjectByName(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectObject(Object obj) {
        InjectProgram program;
        if (obj == null) {
            return;
        }
        Class<?> cl = obj.getClass();
        HashMap<Class, InjectProgram> hashMap = this._injectMap;
        synchronized (hashMap) {
            program = this._injectMap.get(cl);
            if (program == null) {
                program = InjectIntrospector.introspectProgram(cl);
                this._injectMap.put(cl, program);
            }
        }
        program.configure(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ObserverImpl observer) {
        HashMap<Class, ObserverMap> hashMap = this._observerMap;
        synchronized (hashMap) {
            ObserverMap map = this._observerMap.get(observer.getType());
            if (map == null) {
                map = new ObserverMap(observer.getType());
                this._observerMap.put(observer.getType(), map);
            }
            map.addObserver(observer);
        }
    }

    public <T> ComponentFactory<T> resolveByType(Class<T> apiType, Annotation ... bindingTypes) {
        return this.bind("", apiType, bindingTypes);
    }

    public <T> T getByType(Class<T> apiType, Annotation ... bindingTypes) {
        ComponentImpl factory = this.bind("", apiType, bindingTypes);
        if (factory != null) {
            return (T)factory.get();
        }
        return null;
    }

    public void addContext(Class<Annotation> scopeType, Context context) {
        this._contextMap.put(scopeType, context);
    }

    public Context getContext(Class<Annotation> scopeType) {
        return this._contextMap.get(scopeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseEvent(Object event, Annotation ... bindings) {
        ArrayList<ObserverMap> observerList;
        if (this._parent != null) {
            this._parent.raiseEvent(event, bindings);
        }
        HashMap<Class, ArrayList<ObserverMap>> hashMap = this._observerListCache;
        synchronized (hashMap) {
            observerList = this._observerListCache.get(event.getClass());
            if (observerList == null) {
                observerList = new ArrayList();
                this.fillObserverList(observerList, event.getClass());
                this._observerListCache.put(event.getClass(), observerList);
            }
        }
        int size = observerList.size();
        for (int i = 0; i < size; ++i) {
            observerList.get(i).raiseEvent(event, bindings);
        }
    }

    public Conversation createConversation() {
        return (Conversation)this._contextMap.get(ConversationScoped.class);
    }

    private void fillObserverList(ArrayList<ObserverMap> list, Class cl) {
        if (cl == null) {
            return;
        }
        this.fillObserverList(list, cl.getSuperclass());
        for (Class<?> iface : cl.getInterfaces()) {
            this.fillObserverList(list, iface);
        }
        ObserverMap map = this._observerMap.get(cl);
        if (map != null) {
            list.add(map);
        }
    }

    public <T> T createTransientObject(Class<T> type) {
        ComponentFactory<T> factory = this.createTransient(type);
        return (T)factory.create();
    }

    public <T> T createTransientObjectNoInit(Class<T> type) {
        ComponentImpl comp = (ComponentImpl)this.createTransient(type);
        return (T)comp.createNoInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ComponentFactory<T> createTransient(Class<T> type) {
        HashMap<Class, ClassComponent> hashMap = this._transientMap;
        synchronized (hashMap) {
            ClassComponent comp = this._transientMap.get(type);
            if (comp == null) {
                if (type.isInterface()) {
                    throw new ConfigException(L.l("'{0}' cannot be an interface.  createTransient requires a concrete type.", (Object)type.getName()));
                }
                if (Modifier.isAbstract(type.getModifiers())) {
                    throw new ConfigException(L.l("'{0}' cannot be an abstract.  createTransient requires a concrete type.", (Object)type.getName()));
                }
                comp = new ClassComponent(this._wbWebBeans);
                comp.setInstanceClass(type);
                try {
                    Constructor<T> nullCtor = type.getConstructor(new Class[0]);
                    if (nullCtor != null) {
                        comp.setConstructor(nullCtor);
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                comp.init();
                this._transientMap.put(type, comp);
                comp.bind();
            }
            return comp;
        }
    }

    public ELContext getELContext() {
        return new ConfigELContext();
    }

    public <T> T getObject(Class<T> type, Annotation ... ann) {
        return (T)this.createFactory(type, ann).get();
    }

    public <T> T getObject(Class<T> type, String name) {
        Annotation[] ann = new Annotation[]{Names.create(name)};
        return (T)this.createFactory(type, ann).get();
    }

    public <T> T createFactory(Class<T> type, String name) {
        Annotation[] ann = new Annotation[]{Names.create(name)};
        return (T)this.createFactory(type, ann);
    }

    public <T> T getEnvironmentObject(Class<T> type, Annotation ... ann) {
        ComponentImpl comp = (ComponentImpl)this.createFactory(type, ann);
        Object value = comp.get();
        if (comp.isDestroyPresent()) {
            Environment.addClassLoaderListener(new ComponentClose(value, comp));
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentFactory createFactory(Class type, Annotation ... ann) {
        FactoryBinding binding = new FactoryBinding(type, ann);
        HashMap<FactoryBinding, ComponentFactory> hashMap = this._objectFactoryMap;
        synchronized (hashMap) {
            ComponentFactory factory = this._objectFactoryMap.get(binding);
            if (factory != null) {
                return factory;
            }
            if (ann == null) {
                ann = NULL_ANN;
            }
            if ((factory = this.resolveByType(type, ann)) != null) {
                this._objectFactoryMap.put(binding, factory);
                return factory;
            }
            if (type.isInterface()) {
                throw new ConfigException(L.l("'{0}' cannot be an interface.  createTransient requires a concrete type.", (Object)type.getName()));
            }
            if (Modifier.isAbstract(type.getModifiers())) {
                throw new ConfigException(L.l("'{0}' cannot be an abstract.  createTransient requires a concrete type.", (Object)type.getName()));
            }
            ClassComponent comp = new ClassComponent(this._wbWebBeans);
            comp.setInstanceClass(type);
            try {
                Constructor nullCtor = type.getConstructor(new Class[0]);
                if (nullCtor != null) {
                    comp.setConstructor(nullCtor);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            comp.init();
            this._objectFactoryMap.put(binding, comp);
            return comp;
        }
    }

    public void update() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            ArrayList<WebBeansRootContext> rootContextList = new ArrayList<WebBeansRootContext>(this._pendingRootContextList);
            this._pendingRootContextList.clear();
            for (WebBeansRootContext context : rootContextList) {
                Path root = context.getRoot();
                WbWebBeans webBeans = this._webBeansMap.get(root);
                if (webBeans == null) {
                    webBeans = new WbWebBeans(this, root);
                    this._webBeansMap.put(root, webBeans);
                    Path path = root.lookup("META-INF/web-beans.xml");
                    if (path.canRead()) {
                        path.setUserPath(path.getURL());
                        new Config().configure((Object)webBeans, path, SCHEMA);
                    }
                }
                for (String className : context.getClassNameList()) {
                    try {
                        Class<?> cl = Class.forName(className, false, this._classLoader);
                        webBeans.addScannedClass(cl);
                    }
                    catch (ClassNotFoundException e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
                webBeans.update();
                webBeans.init();
            }
            this._wbWebBeans.init();
        }
        catch (ConfigException e) {
            if (this._configException == null) {
                this._configException = e;
            }
            throw e;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void bind() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            ArrayList<ComponentImpl> bindList = new ArrayList<ComponentImpl>(this._pendingBindList);
            this._pendingBindList.clear();
            for (ComponentImpl comp : bindList) {
                if (!comp.getType().isEnabled()) continue;
                comp.bind();
            }
        }
        catch (ConfigException e) {
            if (this._configException == null) {
                this._configException = e;
            }
            throw e;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public Class loadClass(String className) {
        try {
            return Class.forName(className, false, this._classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
        this.update();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.update();
        this.bind();
        this._wbWebBeans.init();
        this.startSingletons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSingletons() {
        ArrayList<ComponentImpl> singletons;
        ArrayList<ComponentImpl> arrayList = this._pendingSingletonList;
        synchronized (arrayList) {
            if (this._pendingSingletonList.size() == 0) {
                return;
            }
            singletons = new ArrayList<ComponentImpl>();
            singletons.addAll(this._pendingSingletonList);
            this._pendingSingletonList.clear();
        }
        for (ComponentImpl singleton : singletons) {
            singleton.get();
        }
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this._componentMap = null;
        this._namedComponentMap = null;
    }

    public static ConfigException injectError(AccessibleObject prop, String msg) {
        String location = "";
        if (prop instanceof Field) {
            Field field = (Field)prop;
            String className = field.getDeclaringClass().getName();
            location = className + "." + field.getName() + ": ";
        } else if (prop instanceof Method) {
            Method method = (Method)prop;
            String className = method.getDeclaringClass().getName();
            location = className + "." + method.getName() + ": ";
        }
        return new ConfigException(location + msg);
    }

    public static String location(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName() + ": ";
    }

    public static String location(Method method) {
        return LineConfigException.loc((Method)method);
    }

    public static ConfigException error(Method method, String msg) {
        return new ConfigException(WebBeansContainer.location(method) + msg);
    }

    @Override
    public boolean isRootScannable(Path root) {
        if (!root.lookup("META-INF/web-beans.xml").canRead()) {
            return false;
        }
        WebBeansRootContext context = this._rootContextMap.get(root);
        if (context == null) {
            context = new WebBeansRootContext(root);
            this._rootContextMap.put(root, context);
            this._pendingRootContextList.add(context);
        }
        if (context.isScanComplete()) {
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("WebBeans scanning " + root.getURL());
        }
        context.setScanComplete(true);
        return true;
    }

    @Override
    public boolean isScanMatch(CharBuffer annotationName) {
        try {
            String className = annotationName.toString();
            Class<?> cl = Class.forName(className, false, this._tempClassLoader);
            return cl.isAnnotationPresent(ComponentType.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
        WebBeansRootContext context = this._rootContextMap.get(root);
        if (context == null) {
            context = new WebBeansRootContext(root);
            this._rootContextMap.put(root, context);
            this._pendingRootContextList.add(context);
        }
        context.addClassName(className);
    }

    public Object writeReplace() {
        return new WebBeansHandle(Container.class);
    }

    public String toString() {
        if (this._classLoader != null && this._classLoader.getId() != null) {
            return "WebBeansContainer[" + this._classLoader.getId() + "]";
        }
        return "WebBeansContainer[]";
    }

    static String getSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return String.valueOf(type);
    }

    static class FactoryBinding {
        private static final Annotation[] NULL = new Annotation[0];
        private final Type _type;
        private final Annotation[] _ann;

        FactoryBinding(Type type, Annotation[] ann) {
            this._type = type;
            this._ann = ann != null ? ann : NULL;
        }

        public int hashCode() {
            int hash = this._type.hashCode();
            for (Annotation ann : this._ann) {
                hash = 65521 * hash + ((Object)ann).hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FactoryBinding)) {
                return false;
            }
            FactoryBinding binding = (FactoryBinding)obj;
            if (this._type != binding._type) {
                return false;
            }
            if (this._ann.length != binding._ann.length) {
                return false;
            }
            for (int i = 0; i < this._ann.length; ++i) {
                if (((Object)this._ann[i]).equals(binding._ann[i])) continue;
                return false;
            }
            return true;
        }
    }
}

