/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webbeans.manager;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.Binding;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebComponent {
    private static L10N L = new L10N(WebComponent.class);
    private Type _type;
    private ArrayList<ComponentImpl> _componentList = new ArrayList();

    public WebComponent(Type type) {
        this._type = type;
    }

    public void addComponent(ComponentImpl comp) {
        for (int i = this._componentList.size() - 1; i >= 0; --i) {
            ComponentImpl oldComponent = this._componentList.get(i);
            if (!comp.getClassName().equals(oldComponent.getClassName())) continue;
            if (comp.isFromClass() && !oldComponent.isFromClass()) {
                return;
            }
            if (!comp.isFromClass() && oldComponent.isFromClass()) {
                this._componentList.remove(i);
                continue;
            }
            if (!comp.equals(oldComponent)) continue;
            return;
        }
        this._componentList.add(comp);
    }

    public void createProgram(ArrayList<ConfigProgram> initList, Field field, ArrayList<Annotation> bindList) throws ConfigException {
        ComponentImpl comp = this.bind(WebBeansContainer.location(field), bindList);
        comp.createProgram(initList, field);
    }

    public ComponentImpl bind(String location, ArrayList<Annotation> bindList) throws ConfigException {
        ComponentImpl matchComp = null;
        ComponentImpl secondComp = null;
        for (int i = 0; i < this._componentList.size(); ++i) {
            ComponentImpl comp = this._componentList.get(i);
            if (!comp.isMatch(bindList)) continue;
            if (matchComp == null) {
                matchComp = comp;
                continue;
            }
            if (comp.getBindingList().size() == bindList.size() && matchComp.getBindingList().size() != bindList.size()) {
                matchComp = comp;
                secondComp = null;
                continue;
            }
            if (matchComp.getBindingList().size() == bindList.size() && comp.getBindingList().size() != bindList.size()) continue;
            if (matchComp.getType().getPriority() < comp.getType().getPriority()) {
                matchComp = comp;
                secondComp = null;
                continue;
            }
            if (comp.getType().getPriority() < matchComp.getType().getPriority()) continue;
            secondComp = comp;
        }
        if (matchComp == null) {
            return null;
        }
        if (matchComp != null && secondComp != null) {
            throw new ConfigException(location + L.l("WebBeans conflict between '{0}' and '{1}'.  WebBean injection must match uniquely.", (Object)matchComp, secondComp));
        }
        return matchComp;
    }

    ArrayList<ComponentImpl> getComponentList() {
        return this._componentList;
    }

    public ComponentImpl bindByBindings(String location, Type type, ArrayList<Binding> bindList) throws ConfigException {
        ComponentImpl matchComp = null;
        ComponentImpl secondComp = null;
        for (int i = 0; i < this._componentList.size(); ++i) {
            ComponentImpl comp = this._componentList.get(i);
            if (!comp.isMatchByBinding(bindList)) continue;
            if (matchComp == null) {
                matchComp = comp;
                continue;
            }
            if (comp.getBindingList().size() == bindList.size() && matchComp.getBindingList().size() != bindList.size()) {
                matchComp = comp;
                secondComp = null;
                continue;
            }
            if (matchComp.getBindingList().size() == bindList.size() && comp.getBindingList().size() != bindList.size()) continue;
            if (matchComp.getType().getPriority() < comp.getType().getPriority()) {
                matchComp = comp;
                secondComp = null;
                continue;
            }
            if (comp.getType().getPriority() < matchComp.getType().getPriority()) continue;
            secondComp = comp;
        }
        if (matchComp == null) {
            return null;
        }
        if (matchComp != null && secondComp != null) {
            throw new ConfigException(location + L.l("Injection of '{0}' conflicts between '{1}' and '{2}'.  WebBean injection must match uniquely.", (Object)WebComponent.getName(type), (Object)matchComp, secondComp));
        }
        return matchComp;
    }

    static String getName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return String.valueOf(type);
    }
}

