/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.ExtendedLocator;
import com.caucho.xml.QAttributes;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElement;
import com.caucho.xml.QEntityReference;
import com.caucho.xml.QName;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMBuilder
implements XMLWriter,
ContentHandler,
ErrorHandler {
    static final Logger log = Log.open(DOMBuilder.class);
    static final L10N L = new L10N(DOMBuilder.class);
    static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    private QDocument _doc;
    private Node _top;
    private Node _node;
    private String _singleText;
    private CharBuffer _text = new CharBuffer();
    private boolean _escapeText;
    private boolean _strictXml;
    private boolean _isCoalescing = true;
    private boolean _skipWhitespace = false;
    private ArrayList<QName> _prefixNames = new ArrayList();
    private ArrayList<String> _prefixValues = new ArrayList();
    private Locator _locator;
    private ExtendedLocator _extLocator;
    private String _systemId;

    public void init(Node top) {
        this._doc = top instanceof QDocument ? (QDocument)top : (QDocument)top.getOwnerDocument();
        this._top = top;
        this._node = top;
        this._singleText = null;
        this._prefixNames.clear();
        this._prefixValues.clear();
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
        if (systemId != null && this._top instanceof Document) {
            Document tdoc = (Document)this._top;
            DocumentType dtd = tdoc.getDoctype();
            if (tdoc instanceof QDocument && dtd == null) {
                dtd = new QDocumentType(null);
                ((QDocument)tdoc).setDoctype(dtd);
            }
            if (dtd instanceof QDocumentType && dtd.getSystemId() == null) {
                ((QDocumentType)dtd).setSystemId(systemId);
            }
        }
        if (this._doc != null) {
            this._doc.setSystemId(systemId);
        }
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setFilename(String filename) {
        if (filename != null && this._top instanceof QDocument) {
            this._doc.setRootFilename(filename);
        }
    }

    public void setStrictXML(boolean isStrictXml) {
        this._strictXml = isStrictXml;
    }

    public void setCoalescing(boolean isCoalescing) {
        this._isCoalescing = isCoalescing;
    }

    public void setSkipWhitespace(boolean skipWhitespace) {
        this._skipWhitespace = skipWhitespace;
    }

    public void setDocumentLocator(Locator loc) {
        if (this._doc == null) {
            this._doc = new QDocument();
            this._node = this._doc;
            this._top = this._doc;
        }
        this._locator = loc;
        if (loc instanceof ExtendedLocator) {
            this._extLocator = (ExtendedLocator)loc;
        }
        if (this._extLocator != null && this._doc.getSystemId() == null) {
            this._doc.setLocation(this._extLocator.getSystemId(), this._extLocator.getFilename(), this._extLocator.getLineNumber(), this._extLocator.getColumnNumber());
        }
    }

    public void startPrefixMapping(String prefix, String url) {
        if (this._node == null || this._node == this._top) {
            this._doc.addNamespace(prefix, url);
        }
        if (prefix == null || prefix.equals("")) {
            this._prefixNames.add(new QName(null, "xmlns", XMLNS));
            this._prefixValues.add(url);
        } else {
            this._prefixNames.add(new QName("xmlns", prefix, XMLNS));
            this._prefixValues.add(url);
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public Node getNode() {
        return this._top;
    }

    public void startDocument() {
        if (this._doc == null) {
            this._doc = new QDocument();
            this._node = this._doc;
            this._top = this._doc;
        }
    }

    public void endDocument() throws SAXException {
        this.popText();
    }

    public void setLocation(String filename, int line, int column) {
    }

    public void startElement(String uri, String localName, String qName) throws IOException {
        this.popText();
        Element elt = uri != null && !uri.equals("") ? this._doc.createElementNS(uri, qName) : (!qName.equals("") ? this._doc.createElement(qName) : this._doc.createElement(localName));
        if (this._node == this._doc && this._doc.getDocumentElement() == null) {
            this._doc.setDocumentElement(elt);
        }
        this._node.appendChild(elt);
        this._node = elt;
        if (this._extLocator != null && elt instanceof QElement) {
            ((QElement)elt).setLocation(this._extLocator.getSystemId(), this._extLocator.getFilename(), this._extLocator.getLineNumber(), this._extLocator.getColumnNumber());
        }
    }

    public void startElement(QName name, QAttributes attributes) throws SAXException {
        QDocumentType dtd;
        this.popText();
        QElement elt = (QElement)this._doc.createElementByName(name);
        this._node.appendChild(elt);
        this._node = elt;
        if (this._node == this._doc && this._doc.getDocumentElement() == null) {
            this._doc.setDocumentElement(elt);
        }
        for (int i = 0; i < this._prefixNames.size(); ++i) {
            QName attrName = this._prefixNames.get(i);
            String value = this._prefixValues.get(i);
            elt.setAttribute(attrName, value);
        }
        this._prefixNames.clear();
        this._prefixValues.clear();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            QName attrName = attributes.getName(i);
            String value = attributes.getValue(i);
            elt.setAttribute(attrName, value);
        }
        if (this._extLocator != null) {
            elt.setLocation(this._extLocator.getSystemId(), this._extLocator.getFilename(), this._extLocator.getLineNumber(), this._extLocator.getColumnNumber());
        }
        if ((dtd = (QDocumentType)this._doc.getDoctype()) != null) {
            dtd.fillDefaults(elt);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        QDocumentType dtd;
        this.popText();
        Element elt = uri != null && !uri.equals("") ? this._doc.createElementNS(uri, qName) : (!qName.equals("") ? this._doc.createElement(qName) : this._doc.createElement(localName));
        if (this._node == this._doc) {
            if (this._doc.getDocumentElement() == null) {
                this._doc.setDocumentElement(elt);
            } else if (this._strictXml) {
                throw this.error(L.l("expected a single top-level element at `{0}'", (Object)qName));
            }
        }
        this._node.appendChild(elt);
        this._node = elt;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String attrUri = attributes.getURI(i);
            String attrQname = attributes.getQName(i);
            String value = attributes.getValue(i);
            Attr attr = attrUri != null && !attrUri.equals("") ? this._doc.createAttributeNS(attrUri, attrQname) : (!attrQname.equals("") ? this._doc.createAttribute(attrQname) : this._doc.createAttribute(attributes.getLocalName(i)));
            attr.setNodeValue(value);
            ((Element)this._node).setAttributeNode(attr);
        }
        if (this._extLocator != null) {
            ((QElement)elt).setLocation(this._extLocator.getSystemId(), this._extLocator.getFilename(), this._extLocator.getLineNumber(), this._extLocator.getColumnNumber());
        }
        if ((dtd = (QDocumentType)this._doc.getDoctype()) != null) {
            dtd.fillDefaults((QElement)elt);
        }
    }

    public void dtd(QDocumentType dtd) {
        this._doc.setDoctype(dtd);
        this._doc.appendChild(dtd);
    }

    public void attribute(String uri, String localName, String qName, String value) throws IOException {
        if (this._node instanceof Element) {
            Attr attr = this._doc.createAttributeNS(uri, qName);
            attr.setNodeValue(value);
            ((Element)this._node).setAttributeNode(attr);
        } else {
            ((QDocument)this._node).setAttribute(qName, value);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this.popText();
        if (this._node != null) {
            this._node = this._node.getParentNode();
        }
        if (this._node == null) {
            this._node = this._doc;
        }
    }

    public void processingInstruction(String name, String data) {
        this.popText();
        ProcessingInstruction pi = this._doc.createProcessingInstruction(name, data);
        this._node.appendChild(pi);
    }

    public void comment(char[] buf, int offset, int length) throws SAXException {
        try {
            this.comment(new String(buf, offset, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void comment(String data) throws IOException {
        this.popText();
        Comment comment = this._doc.createComment(data);
        this._node.appendChild(comment);
    }

    public boolean getEscapeText() {
        return this._escapeText;
    }

    public void setEscapeText(boolean isEscaped) {
        this._escapeText = isEscaped;
    }

    public void text(String text) throws IOException {
        if (this._singleText == null && this._text.length() == 0) {
            if (!text.equals("")) {
                this._singleText = text;
            }
        } else if (this._singleText != null) {
            this._text.append(this._singleText);
            this._text.append(text);
        } else {
            this._text.append(text);
        }
        if (!this._isCoalescing) {
            this.popText();
        }
    }

    public void text(char[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this._singleText != null) {
            this._singleText = null;
            this._text.append(this._singleText);
        }
        this._text.append(buffer, offset, length);
        if (!this._isCoalescing) {
            this.popText();
        }
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this._strictXml && this._node == this._doc && this._doc.getDocumentElement() == null) {
            while (length > 0 && XmlChar.isWhitespace(buffer[offset])) {
                ++offset;
                --length;
            }
            for (int i = 0; i < length; ++i) {
                if (buffer[offset + i] != '\n' && buffer[offset + i] != '\r') continue;
                length = i;
                break;
            }
            if (length > 16) {
                length = 16;
            }
            if (length > 0) {
                throw this.error(L.l("expected top element at `{0}'", (Object)new String(buffer, offset, length)));
            }
        }
        this._text.append(buffer, offset, length);
    }

    public void ignorableWhitespace(char[] buffer, int offset, int length) throws SAXException {
        if (!this._skipWhitespace) {
            this.characters(buffer, offset, length);
        }
    }

    public void entityReference(String name) {
        this.popText();
        QEntityReference er = new QEntityReference(name);
        er._owner = this._doc;
        this._node.appendChild(er);
    }

    public void skippedEntity(String s) {
        this._text.append(s);
    }

    public void cdata(String text) throws IOException {
        this.popText();
        this._node.appendChild(this._doc.createCDATASection(text));
    }

    public void cdata(char[] buffer, int offset, int length) throws IOException {
        this.cdata(new String(buffer, offset, length));
    }

    private void popText() {
        if (this._singleText != null) {
            Text text = this._doc.createTextNode(this._singleText);
            this._node.appendChild(text);
            this._singleText = null;
            return;
        }
        if (this._text.length() == 0) {
            return;
        }
        Text text = this._doc.createTextNode(this._text.toString());
        this._text.clear();
        this._node.appendChild(text);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        log.log(Level.FINE, e.toString(), e);
        throw this.error(e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        log.log(Level.FINER, e.toString(), e);
        throw this.error(e.getMessage());
    }

    public void warning(SAXParseException e) throws SAXException {
        log.log(Level.FINER, e.toString(), e);
    }

    public SAXException createError(Exception e) {
        if (e instanceof SAXException) {
            return (SAXException)e;
        }
        return new SAXException(e);
    }

    XmlParseException error(String text) {
        String loc = "";
        if (this._extLocator != null) {
            return new XmlParseException(this._extLocator.getFilename(), this._extLocator.getLineNumber(), text);
        }
        if (this._locator != null) {
            return new XmlParseException(this._locator.getSystemId(), this._locator.getLineNumber(), text);
        }
        return new XmlParseException(text);
    }
}

