/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentFragment;
import com.caucho.xml.QText;
import com.caucho.xpath.pattern.NodeListIterator;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class QNode
extends QAbstractNode {
    protected QAbstractNode _firstChild;
    protected QAbstractNode _lastChild;

    protected QNode() {
    }

    protected QNode(QDocument owner) {
        super(owner);
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String value) {
    }

    public NodeList getChildNodes() {
        return new ChildNodeList();
    }

    public Node getFirstChild() {
        return this._firstChild;
    }

    public Node getLastChild() {
        return this._lastChild;
    }

    public Node getPreviousSibling() {
        return this._previous;
    }

    public Node getNextSibling() {
        return this._next;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        QAbstractNode qNewChild = (QAbstractNode)newChild;
        QAbstractNode qRefChild = (QAbstractNode)refChild;
        if (qNewChild._owner != this._owner && qNewChild._owner != this) {
            throw new QDOMException(4, "insertBefore new child from wrong document");
        }
        qNewChild.remove();
        if (qRefChild != null && qRefChild._parent != this) {
            throw new QDOMException(8, "insertBefore has no such child");
        }
        if (qNewChild instanceof QDocumentFragment) {
            QDocumentFragment frag = (QDocumentFragment)qNewChild;
            QAbstractNode first = frag._firstChild;
            QAbstractNode next = null;
            QAbstractNode ptr = first;
            while (ptr != null) {
                next = ptr._next;
                this.insertBefore(ptr, refChild);
                ptr = next;
            }
            return first;
        }
        qNewChild._parent = this;
        if (refChild == null) {
            if (this._firstChild == null) {
                qNewChild._previous = null;
                qNewChild._next = null;
                this._firstChild = this._lastChild = qNewChild;
            } else {
                this._lastChild._next = qNewChild;
                qNewChild._previous = this._lastChild;
                this._lastChild = qNewChild;
                qNewChild._next = null;
            }
            return qNewChild;
        }
        qNewChild._previous = qRefChild._previous;
        qNewChild._next = qRefChild;
        if (qRefChild._previous == null) {
            this._firstChild = qNewChild;
        } else {
            qRefChild._previous._next = qNewChild;
        }
        qRefChild._previous = qNewChild;
        return qNewChild;
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        QAbstractNode qNewChild = (QAbstractNode)newChild;
        QAbstractNode qRefChild = (QAbstractNode)refChild;
        if (qRefChild == null || qRefChild._parent != this) {
            throw new QDOMException(8, "ref is not child");
        }
        if (qNewChild == null || qNewChild._owner != this._owner) {
            throw new QDOMException(4, "wrong document");
        }
        if (this._owner != null) {
            ++this._owner._changeCount;
        }
        qNewChild._previous = qRefChild._previous;
        qNewChild._next = qRefChild._next;
        qNewChild._parent = this;
        if (qNewChild._previous == null) {
            this._firstChild = qNewChild;
        } else {
            qNewChild._previous._next = qNewChild;
        }
        if (qNewChild._next == null) {
            this._lastChild = qNewChild;
        } else {
            qNewChild._next._previous = qNewChild;
        }
        qRefChild._previous = null;
        qRefChild._next = null;
        qRefChild._parent = null;
        return qRefChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        QAbstractNode qOldChild = (QAbstractNode)oldChild;
        if (qOldChild != null && qOldChild._parent != this) {
            throw new QDOMException(8, "removeChild has no such child");
        }
        if (this._owner != null) {
            ++this._owner._changeCount;
        }
        if (qOldChild._previous == null) {
            this._firstChild = qOldChild._next;
        } else {
            qOldChild._previous._next = qOldChild._next;
        }
        if (qOldChild._next == null) {
            this._lastChild = qOldChild._previous;
        } else {
            qOldChild._next._previous = qOldChild._previous;
        }
        qOldChild._parent = null;
        qOldChild._next = null;
        qOldChild._previous = null;
        return qOldChild;
    }

    private static void setOwner(QAbstractNode node, QDocument owner) {
        if (node._owner == null) {
            node._owner = owner;
            String namespace = node.getNamespaceURI();
            if (namespace != "") {
                owner.addNamespace(node.getPrefix(), namespace);
            }
            for (QAbstractNode child = (QAbstractNode)node.getFirstChild(); child != null; child = (QAbstractNode)child.getNextSibling()) {
                QNode.setOwner(child, owner);
            }
        }
    }

    public Node appendChild(Node newNode) throws DOMException {
        QAbstractNode qNewNode = (QAbstractNode)newNode;
        QNode.setOwner(qNewNode, this._owner);
        if (qNewNode._owner != this._owner && qNewNode._owner != this) {
            throw new QDOMException(4, "can't appendChild from different document");
        }
        qNewNode.remove();
        if (qNewNode instanceof QDocumentFragment) {
            QDocumentFragment frag = (QDocumentFragment)qNewNode;
            QAbstractNode first = frag._firstChild;
            QAbstractNode next = null;
            QAbstractNode ptr = first;
            while (ptr != null) {
                next = ptr._next;
                this.appendChild(ptr);
                ptr = next;
            }
            return first;
        }
        qNewNode._parent = this;
        qNewNode._next = null;
        qNewNode._previous = this._lastChild;
        if (this._lastChild == null) {
            this._lastChild = qNewNode;
            this._firstChild = qNewNode;
        } else {
            this._lastChild._next = qNewNode;
            this._lastChild = qNewNode;
        }
        return qNewNode;
    }

    public boolean hasChildNodes() {
        return this._firstChild != null;
    }

    public void setTextContent(String content) {
        QText text = new QText(content);
        text._owner = this._owner;
        this._firstChild = this._lastChild = text;
    }

    public void normalize() {
    }

    public boolean checkValid() throws Exception {
        if (!super.checkValid()) {
            throw new Exception("super bad: " + this);
        }
        if (this._firstChild != null && this._firstChild._previous != null) {
            throw new Exception("first child bad: " + this);
        }
        if (this._lastChild != null && this._lastChild._next != null) {
            throw new Exception("last child bad:" + this);
        }
        QAbstractNode ptr = this._firstChild;
        while (ptr != null) {
            if (ptr._parent != this) {
                throw new Exception("child parent bad:" + this + " " + ptr);
            }
            if (ptr._owner != this._owner && ptr._owner != this) {
                throw new Exception("child owner bad:" + this + " " + ptr + " " + ptr._owner + " " + this._owner);
            }
            if (ptr._next != null && ptr._next._previous != ptr) {
                throw new Exception("child links bad:" + this + " " + ptr);
            }
            ptr = ptr._next;
        }
        ptr = this._lastChild;
        while (ptr != null) {
            if (ptr._parent != this) {
                throw new Exception("child parent bad:" + this + " " + ptr);
            }
            if (ptr._owner != this._owner && ptr._owner != this) {
                throw new Exception("child owner bad:" + this + " " + ptr);
            }
            if (ptr._previous != null && ptr._previous._next != ptr) {
                throw new Exception("child links bad:" + this + " " + ptr);
            }
            ptr = ptr._previous;
        }
        return true;
    }

    public QAbstractNode getNextPreorder() {
        if (this._firstChild != null) {
            return this._firstChild;
        }
        if (this._next != null) {
            return this._next;
        }
        QNode ptr = this._parent;
        while (ptr != null) {
            if (ptr._next != null) {
                return ptr._next;
            }
            ptr = ptr._parent;
        }
        return null;
    }

    public boolean equals(Object arg) {
        return this == arg;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChildNodeList
    implements NodeList {
        @Override
        public Node item(int index) {
            QAbstractNode ptr = QNode.this._firstChild;
            while (ptr != null && index > 0) {
                ptr = ptr._next;
                --index;
            }
            return ptr;
        }

        @Override
        public int getLength() {
            int index = 0;
            QAbstractNode ptr = QNode.this._firstChild;
            while (ptr != null) {
                ++index;
                ptr = ptr._next;
            }
            return index;
        }

        public Iterator<Node> iterator() {
            return new NodeListIterator(null, this);
        }
    }
}

