/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.util.Base64;
import com.caucho.xml.saaj.SAAJCommandMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.activation.CommandMap;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

public class AttachmentPartImpl
extends AttachmentPart {
    private static final String CONTENT_TYPE = "Content-Type";
    private DataHandler _dataHandler;
    private MimeHeaders _headers = new MimeHeaders();

    public void addMimeHeader(String name, String value) {
        this._headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this._headers.getAllHeaders();
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this._headers.getMatchingHeaders(names);
    }

    public String[] getMimeHeader(String name) {
        return this._headers.getHeader(name);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this._headers.getNonMatchingHeaders(names);
    }

    public void removeAllMimeHeaders() {
        this._headers.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this._headers.removeHeader(header);
    }

    public void setMimeHeader(String name, String value) {
        try {
            if (CONTENT_TYPE.equals(name) && this._dataHandler != null && !value.equals(this._dataHandler.getContentType())) {
                Object o = this._dataHandler.getContent();
                this._dataHandler = new DataHandler(o, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._headers.setHeader(name, value);
    }

    public void clearContent() {
        this._dataHandler = null;
    }

    public InputStream getBase64Content() throws SOAPException {
        try {
            InputStream is = this.getRawContent();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(os);
            Base64.encode((Writer)w, (InputStream)is);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public Object getContent() throws SOAPException {
        if (this._dataHandler == null) {
            throw new SOAPException("No content available");
        }
        try {
            return this._dataHandler.getContent();
        }
        catch (IOException e) {
            return new SOAPException((Throwable)e);
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this._dataHandler == null) {
            throw new SOAPException("DataHandler not set");
        }
        return this._dataHandler;
    }

    public InputStream getRawContent() throws SOAPException {
        if (this._dataHandler == null) {
            throw new SOAPException("Content not set");
        }
        try {
            return this._dataHandler.getInputStream();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public byte[] getRawContentBytes() throws SOAPException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this._dataHandler.writeTo((OutputStream)os);
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public int getSize() throws SOAPException {
        if (this._dataHandler == null) {
            return 0;
        }
        byte[] buffer = this.getRawContentBytes();
        this._dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(buffer, this.getContentType()));
        this._dataHandler.setCommandMap((CommandMap)SAAJCommandMap.COMMAND_MAP);
        return buffer.length;
    }

    public void setBase64Content(InputStream content, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException("Content InputStream cannot be null");
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Base64.decode((Reader)new InputStreamReader(content), (OutputStream)os);
            byte[] buffer = os.toByteArray();
            this.setRawContentBytes(buffer, 0, buffer.length, contentType);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void setContent(Object object, String contentType) {
        this.setContentType(contentType);
        this._dataHandler = new DataHandler(object, contentType);
        this._dataHandler.setCommandMap((CommandMap)SAAJCommandMap.COMMAND_MAP);
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("DataHandler cannot be null");
        }
        this._dataHandler = dataHandler;
    }

    public void setRawContent(InputStream content, String contentType) throws SOAPException {
        if (content == null) {
            throw new SOAPException("InputStream cannot be null");
        }
        this.setContentType(contentType);
        try {
            ByteArrayDataSource source = new ByteArrayDataSource(content, contentType);
            this._dataHandler = new DataHandler((DataSource)source);
            this._dataHandler.setCommandMap((CommandMap)SAAJCommandMap.COMMAND_MAP);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void setRawContentBytes(byte[] content, int offset, int len, String contentType) throws SOAPException {
        this.setContentType(contentType);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content, offset, len);
            ByteArrayDataSource source = new ByteArrayDataSource((InputStream)stream, contentType);
            this._dataHandler = new DataHandler((DataSource)source);
            this._dataHandler.setCommandMap((CommandMap)SAAJCommandMap.COMMAND_MAP);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    static {
        try {
            DataHandler.setDataContentHandlerFactory((DataContentHandlerFactory)SAAJCommandMap.COMMAND_MAP);
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

