/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NameImpl
extends QName
implements Name {
    private String _qualifiedName;

    NameImpl(String localPart) {
        super(localPart);
        this._qualifiedName = localPart;
    }

    NameImpl(String namespaceURI, String localPart) {
        super(namespaceURI, localPart);
        this._qualifiedName = localPart;
    }

    NameImpl(String namespaceURI, String localPart, String prefix) {
        super(namespaceURI, localPart, prefix);
        this._qualifiedName = prefix != null && !"".equals(prefix) ? prefix + ':' + localPart : localPart;
    }

    static NameImpl fromQualifiedName(String uri, String qualifiedName) {
        int colon = qualifiedName.indexOf(58);
        if (colon >= 0) {
            String prefix = qualifiedName.substring(0, colon);
            String localName = qualifiedName.substring(colon + 1);
            return new NameImpl(uri, localName, prefix);
        }
        return new NameImpl(uri, qualifiedName);
    }

    static NameImpl fromName(Name name) {
        if (name instanceof NameImpl) {
            return (NameImpl)name;
        }
        if (name.getPrefix() != null) {
            return new NameImpl(name.getURI(), name.getLocalName(), name.getPrefix());
        }
        if (name.getURI() != null) {
            return new NameImpl(name.getURI(), name.getLocalName());
        }
        return new NameImpl(name.getLocalName());
    }

    static NameImpl fromQName(QName qname) {
        if (qname instanceof NameImpl) {
            return (NameImpl)qname;
        }
        if (qname.getPrefix() != null) {
            return new NameImpl(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix());
        }
        if (qname.getNamespaceURI() != null) {
            return new NameImpl(qname.getNamespaceURI(), qname.getLocalPart());
        }
        return new NameImpl(qname.getLocalPart());
    }

    static NameImpl fromElement(Element element) {
        return NameImpl.fromNode(element);
    }

    static NameImpl fromNode(Node node) {
        if (node.getPrefix() != null) {
            return new NameImpl(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
        }
        if (node.getNamespaceURI() != null) {
            return new NameImpl(node.getNamespaceURI(), node.getLocalName());
        }
        if (node.getLocalName() != null) {
            return new NameImpl(node.getLocalName());
        }
        return new NameImpl(node.getNodeName());
    }

    public String getLocalName() {
        return this.getLocalPart();
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    public String getURI() {
        return this.getNamespaceURI();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    static QName toQName(Name name) {
        if (name instanceof QName) {
            return (QName)name;
        }
        if (name.getPrefix() != null) {
            return new QName(name.getURI(), name.getLocalName(), name.getPrefix());
        }
        if (name.getURI() != null) {
            return new QName(name.getURI(), name.getLocalName());
        }
        return new QName(name.getLocalName());
    }
}

