/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.xml.transform.stream.StreamSource;

public class SAAJCommandMap
extends MailcapCommandMap
implements DataContentHandlerFactory {
    private static final DataContentHandler _plainDataContentHandler = new PlainDataContentHandler();
    private static final DataContentHandler _xmlDataContentHandler = new XmlDataContentHandler();
    private static final DataContentHandler _imageDataContentHandler = new ImageDataContentHandler();
    public static final SAAJCommandMap COMMAND_MAP = new SAAJCommandMap();

    public DataContentHandler createDataContentHandler(String mimeType) {
        if ("text/plain".equals(mimeType)) {
            return _plainDataContentHandler;
        }
        if ("text/xml".equals(mimeType)) {
            return _xmlDataContentHandler;
        }
        if ("image/gif".equals(mimeType)) {
            return _imageDataContentHandler;
        }
        if ("image/jpeg".equals(mimeType)) {
            return _imageDataContentHandler;
        }
        return super.createDataContentHandler(mimeType);
    }

    static class ImageDataContentHandler
    implements DataContentHandler {
        static final DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(BufferedImage.class, "image/gif"), new DataFlavor(BufferedImage.class, "image/jpeg")};

        ImageDataContentHandler() {
        }

        public Object getContent(DataSource ds) throws IOException {
            return ImageIO.read(ds.getInputStream());
        }

        public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
            if (df.equals(flavors[0]) || df.equals(flavors[1])) {
                return this.getContent(ds);
            }
            throw new UnsupportedFlavorException(df);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
            int slash = mimeType.indexOf(47);
            if (slash < 0) {
                throw new IOException("Unrecognized MIME type : " + mimeType);
            }
            String formatName = mimeType.substring(slash + 1);
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
            if (!writers.hasNext()) {
                throw new IOException("Unsupported image type : " + mimeType);
            }
            ImageWriter writer = writers.next();
            MemoryCacheImageOutputStream out = new MemoryCacheImageOutputStream(os);
            writer.setOutput(out);
            writer.write((BufferedImage)obj);
            out.flush();
        }
    }

    static class XmlDataContentHandler
    implements DataContentHandler {
        static final DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(StreamSource.class, "text/xml")};

        XmlDataContentHandler() {
        }

        public Object getContent(DataSource ds) throws IOException {
            return new StreamSource(ds.getInputStream());
        }

        public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
            if (df.equals(flavors[0])) {
                return this.getContent(ds);
            }
            throw new UnsupportedFlavorException(df);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
            StreamSource source = (StreamSource)obj;
            InputStream is = source.getInputStream();
            if (is != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int b = is.read();
                while (b >= 0) {
                    os.write(b);
                    baos.write(b);
                    b = is.read();
                }
                source.setInputStream(new ByteArrayInputStream(baos.toByteArray()));
            } else {
                Reader r = source.getReader();
                if (r != null) {
                    CharArrayWriter copy = new CharArrayWriter();
                    OutputStreamWriter w = new OutputStreamWriter(os);
                    int ch = r.read();
                    while (ch >= 0) {
                        ((Writer)w).write(ch);
                        copy.write(ch);
                        ch = r.read();
                    }
                    ((Writer)w).flush();
                    source.setReader(new CharArrayReader(copy.toCharArray()));
                } else {
                    throw new IOException("No data available from StreamSource");
                }
            }
        }
    }

    static class PlainDataContentHandler
    implements DataContentHandler {
        static final DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(String.class, "text/plain")};

        PlainDataContentHandler() {
        }

        public Object getContent(DataSource ds) throws IOException {
            InputStream is = ds.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int b = is.read();
            while (b >= 0) {
                os.write(b);
                b = is.read();
            }
            return new String(os.toByteArray());
        }

        public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
            if (df.equals(flavors[0])) {
                return this.getContent(ds);
            }
            throw new UnsupportedFlavorException(df);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
            os.write(obj.toString().getBytes());
        }
    }
}

