/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAP11HeaderElementImpl;
import com.caucho.xml.saaj.SOAPElementImpl;
import com.caucho.xml.saaj.SOAPEnvelopeImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.w3c.dom.Node;

public class SOAP11HeaderImpl
extends SOAPElementImpl
implements SOAPHeader {
    private static final NameImpl QNAME_NAME = new NameImpl("qname");
    protected static final NameImpl SOAP_1_1_SUPPORTED_ENVELOPE_NAME = new NameImpl("http://schemas.xmlsoap.org/soap/envelope/", "SupportedEnvelope", "env");
    protected static final NameImpl SOAP_1_2_SUPPORTED_ENVELOPE_NAME = new NameImpl("http://www.w3.org/2003/05/soap-envelope", "SupportedEnvelope", "env");
    protected NameImpl _supportedEnvelopeName = SOAP_1_1_SUPPORTED_ENVELOPE_NAME;
    protected NameImpl _upgradeName = SOAP11HeaderElementImpl.SOAP_1_1_UPGRADE_NAME;

    SOAP11HeaderImpl(SOAPFactory factory, NameImpl name) throws SOAPException {
        super(factory, name);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.addHeaderElement(name);
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        SOAPElement child = element;
        if (!(element instanceof SOAPHeaderElement)) {
            element = new SOAP11HeaderElementImpl(this._factory, element);
        }
        return super.addChildElement(element);
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAP11HeaderElementImpl child = new SOAP11HeaderElementImpl(this._factory, NameImpl.fromName(name));
        this.appendChild((Node)((Object)child));
        return child;
    }

    public SOAPHeaderElement addHeaderElement(QName qname) throws SOAPException {
        return this.addHeaderElement(NameImpl.fromQName(qname));
    }

    public SOAPHeaderElement addNotUnderstoodHeaderElement(QName name) throws SOAPException {
        throw new UnsupportedOperationException("NotUnderstood Header element not supported by SOAP 1.1");
    }

    public SOAPHeaderElement addUpgradeHeaderElement(Iterator supportedSoapUris) throws SOAPException {
        SOAPHeaderElement element = this.createHeaderElement(this._upgradeName);
        int i = 1;
        while (supportedSoapUris.hasNext()) {
            String uri = supportedSoapUris.next().toString();
            element.addChildElement(this.createSupportedElement(uri, i++));
        }
        this.addChildElement((SOAPElement)element);
        return element;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String supportedSoapUri) throws SOAPException {
        SOAPHeaderElement element = this.createHeaderElement(this._upgradeName);
        element.addChildElement(this.createSupportedElement(supportedSoapUri, 1));
        this.addChildElement((SOAPElement)element);
        return element;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String[] supportedSoapUris) throws SOAPException {
        SOAPHeaderElement element = this.createHeaderElement(this._upgradeName);
        for (int i = 0; i < supportedSoapUris.length; ++i) {
            String uri = supportedSoapUris[i];
            element.addChildElement(this.createSupportedElement(uri, i++));
        }
        this.addChildElement((SOAPElement)element);
        return element;
    }

    private SOAPElement createSupportedElement(String uri, int i) throws SOAPException {
        SOAPHeaderElement supported = this.createHeaderElement(this._supportedEnvelopeName);
        supported.addAttribute((Name)QNAME_NAME, "ns" + i + ":Envelope");
        supported.addNamespaceDeclaration("ns" + i, uri);
        return supported;
    }

    protected SOAPHeaderElement createHeaderElement(NameImpl name) throws SOAPException {
        return new SOAP11HeaderElementImpl(this._factory, name);
    }

    public Iterator examineAllHeaderElements() {
        return this.getChildElements();
    }

    public Iterator examineHeaderElements(String actor) {
        return new HeaderElementIterator(actor);
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        return new HeaderElementIterator(actor, true);
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<SOAPHeaderElement> elements = new ArrayList<SOAPHeaderElement>();
        Iterator i = this.examineAllHeaderElements();
        while (i.hasNext()) {
            SOAPHeaderElement element = (SOAPHeaderElement)i.next();
            element.detachNode();
            elements.add(element);
        }
        return elements.iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        ArrayList<SOAPHeaderElement> elements = new ArrayList<SOAPHeaderElement>();
        Iterator i = this.examineAllHeaderElements();
        while (i.hasNext()) {
            SOAPHeaderElement element = (SOAPHeaderElement)i.next();
            if (!actor.equals(element.getActor())) continue;
            element.detachNode();
            elements.add(element);
        }
        return elements.iterator();
    }

    public SOAPElement setElementQName(QName newName) throws SOAPException {
        throw new SOAPException("Cannot set name of SOAP Header");
    }

    public void detachNode() {
        if (this.getParentNode() instanceof SOAPEnvelopeImpl) {
            SOAPEnvelopeImpl parent = (SOAPEnvelopeImpl)((Object)this.getParentNode());
            parent._header = null;
        }
        super.detachNode();
    }

    protected class HeaderElementIterator
    implements Iterator {
        private String _actor;
        private boolean _mustUnderstand;
        private SOAPHeaderElement _headerElement;

        public HeaderElementIterator(String actor) {
            this(actor, false);
        }

        public HeaderElementIterator(String actor, boolean mustUnderstand) {
            this._actor = actor;
            this._mustUnderstand = mustUnderstand;
            this.advanceHeaderElement((SOAPHeaderElement)SOAP11HeaderImpl.this._firstChild);
        }

        public boolean hasNext() {
            return this._headerElement != null;
        }

        public Object next() {
            if (this._headerElement == null) {
                throw new NoSuchElementException();
            }
            SOAPHeaderElement next = this._headerElement;
            this.advanceHeaderElement((SOAPHeaderElement)this._headerElement.getNextSibling());
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceHeaderElement(SOAPHeaderElement next) {
            this._headerElement = next;
            while (this._headerElement != null && (!this._actor.equals(this._headerElement.getActor()) || this._mustUnderstand && !this._headerElement.getMustUnderstand())) {
                this._headerElement = (SOAPHeaderElement)this._headerElement.getNextSibling();
            }
        }
    }
}

