/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAP11FaultImpl;
import com.caucho.xml.saaj.SOAP12DetailImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Node;

public class SOAP12FaultImpl
extends SOAP11FaultImpl {
    private static final NameImpl SOAP_1_2_FAULT_NAME = new NameImpl("http://www.w3.org/2003/05/soap-envelope", "Fault", "env");
    private String _faultNode;
    private String _faultRole;
    private final ArrayList<SOAPElement> _subcodes = new ArrayList();
    private final Map<Locale, String> _faultReasons = new HashMap<Locale, String>();

    SOAP12FaultImpl(SOAPFactory factory) throws SOAPException {
        this(factory, SOAP_1_2_FAULT_NAME);
    }

    SOAP12FaultImpl(SOAPFactory factory, NameImpl name) throws SOAPException {
        super(factory, name);
    }

    public Detail addDetail() throws SOAPException {
        if (this._detail != null) {
            throw new SOAPException("Fault already contains a valid Detail");
        }
        this._detail = new SOAP12DetailImpl(this._factory);
        return this._detail;
    }

    public void appendFaultSubcode(QName subcode) throws SOAPException {
        if (subcode.getPrefix() == null || "".equals(subcode.getPrefix())) {
            throw new SOAPException("Fault subcodes must have qualified names");
        }
        SOAPElement element = this._factory.createElement(subcode);
        if (this.getNamespaceURI(subcode.getPrefix()) == null) {
            element.addNamespaceDeclaration(subcode.getPrefix(), subcode.getNamespaceURI());
        }
        this._subcodes.add(element);
        this._faultCode.addChildElement(element);
    }

    public Iterator getFaultSubcodes() {
        return new SubcodeIterator();
    }

    public void removeAllFaultSubcodes() {
        for (int i = 0; i < this._subcodes.size(); ++i) {
            this._faultCode.removeChild((Node)this._subcodes.get(i));
        }
        this._subcodes.clear();
    }

    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        this._faultReasons.put(locale, text);
    }

    public Iterator getFaultReasonLocales() throws SOAPException {
        return this._faultReasons.keySet().iterator();
    }

    public String getFaultReasonText(Locale locale) throws SOAPException {
        return this._faultReasons.get(locale);
    }

    public Iterator getFaultReasonTexts() throws SOAPException {
        return this._faultReasons.values().iterator();
    }

    public String getFaultString() {
        String reason = null;
        try {
            reason = (String)this.getFaultReasonTexts().next();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return reason;
    }

    public Locale getFaultStringLocale() {
        Locale locale = null;
        try {
            locale = (Locale)this.getFaultReasonLocales().next();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return locale;
    }

    public void setFaultString(String faultString) throws SOAPException {
        this.addFaultReasonText(faultString, Locale.getDefault());
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        this.addFaultReasonText(faultString, locale);
    }

    public String getFaultNode() {
        return this._faultNode;
    }

    public void setFaultNode(String uri) throws SOAPException {
        this._faultNode = uri;
    }

    public String getFaultRole() {
        return this._faultRole;
    }

    public void setFaultRole(String uri) throws SOAPException {
        this._faultRole = uri;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubcodeIterator
    implements Iterator<QName> {
        private Iterator<SOAPElement> _iterator;

        public SubcodeIterator() {
            this._iterator = SOAP12FaultImpl.this._subcodes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public QName next() {
            return this._iterator.next().getElementQName();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

