/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAP11HeaderImpl;
import com.caucho.xml.saaj.SOAP12HeaderElementImpl;
import com.caucho.xml.saaj.TextImpl;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeaderElement;
import org.w3c.dom.Node;

public class SOAP12HeaderImpl
extends SOAP11HeaderImpl {
    private static final Name ENCODING_STYLE_NAME = new NameImpl("http://www.w3.org/2003/05/soap-envelope", "encodingStyle", "env");
    private static final NameImpl QNAME_NAME = new NameImpl("qname");

    SOAP12HeaderImpl(SOAPFactory factory, NameImpl name) throws SOAPException {
        super(factory, name);
        this._supportedEnvelopeName = SOAP_1_2_SUPPORTED_ENVELOPE_NAME;
        this._upgradeName = SOAP12HeaderElementImpl.SOAP_1_2_UPGRADE_NAME;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        if (text.indexOf(60) >= 0) {
            throw new SOAPException("Child tags not allowed in the Text nodes of SOAP 1.2 headers");
        }
        this.appendChild((Node)((Object)new TextImpl(this._factory, text)));
        return this;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if (name.equals(ENCODING_STYLE_NAME)) {
            throw new SOAPException("encodingStyle illegal for this element");
        }
        return super.addAttribute(name, value);
    }

    public SOAPElement addAttribute(QName qname, String value) throws SOAPException {
        if (qname.equals(ENCODING_STYLE_NAME)) {
            throw new SOAPException("encodingStyle illegal for this element");
        }
        return super.addAttribute(qname, value);
    }

    public String getEncodingStyle() {
        return null;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        throw new SOAPException("encodingStyle illegal for this element");
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        SOAPElement child = element;
        if (!(element instanceof SOAPHeaderElement)) {
            element = new SOAP12HeaderElementImpl(this._factory, element);
        }
        return super.addChildElement(element);
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAP12HeaderElementImpl child = new SOAP12HeaderElementImpl(this._factory, NameImpl.fromName(name));
        this.appendChild((Node)((Object)child));
        return child;
    }

    public SOAPHeaderElement addNotUnderstoodHeaderElement(QName name) throws SOAPException {
        SOAPHeaderElement element = this.createHeaderElement(SOAP12HeaderElementImpl.NOT_UNDERSTOOD_NAME);
        if (name.getPrefix() == null) {
            throw new SOAPException("No prefix given with NotUnderstood header");
        }
        if (name.getNamespaceURI() == null) {
            throw new SOAPException("No namespace given with NotUnderstood header");
        }
        element.addAttribute((Name)QNAME_NAME, name.getPrefix() + ':' + name.getLocalPart());
        element.addNamespaceDeclaration(name.getPrefix(), name.getNamespaceURI());
        this.addChildElement((SOAPElement)element);
        return element;
    }

    protected SOAPHeaderElement createHeaderElement(NameImpl name) throws SOAPException {
        return new SOAP12HeaderElementImpl(this._factory, name);
    }
}

