/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAPAttrImpl;
import com.caucho.xml.saaj.SOAPNodeImpl;
import com.caucho.xml.saaj.TextImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SOAPElementImpl
extends SOAPNodeImpl
implements SOAPElement {
    private static final Name ENCODING_STYLE_NAME = new NameImpl("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", "env");
    protected SOAPAttrImpl _firstAttribute;
    protected SOAPAttrImpl _lastAttribute;
    private String _encoding;
    private HashMap<String, String> _namespaces = new HashMap();

    SOAPElementImpl(SOAPFactory factory, NameImpl name, SOAPPart owner) throws SOAPException {
        super(factory, name, (Document)owner);
    }

    SOAPElementImpl(SOAPFactory factory, NameImpl name) throws SOAPException {
        this(factory, name, (SOAPPart)null);
    }

    SOAPElementImpl(SOAPFactory factory, Element element) throws SOAPException {
        this(factory, element, false);
    }

    SOAPElementImpl(SOAPFactory factory, Element element, boolean deepCopy) throws SOAPException {
        this(factory, NameImpl.fromElement(element));
        if (deepCopy) {
            this.deepCopy(element);
        } else {
            this.copyElement(element, true);
        }
    }

    protected void setOwner(SOAPPart owner) {
        this._owner = owner;
    }

    protected void copySOAPElement(SOAPElement source) {
        try {
            this.setEncodingStyle(source.getEncodingStyle());
        }
        catch (SOAPException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (source instanceof SOAPElementImpl) {
            SOAPElementImpl sourceImpl = (SOAPElementImpl)source;
            this._namespaces = (HashMap)sourceImpl._namespaces.clone();
            this._factory = sourceImpl._factory;
            this.copyElement((Element)((Object)sourceImpl), false);
        } else {
            this.copyElement((Element)source, true);
        }
    }

    protected void copyElement(Element source, boolean addNamespaces) {
        this._name = NameImpl.fromElement(source);
        for (Node node = source.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.appendChild(node);
        }
        this.copyAttributesAndNamespaces(source, addNamespaces);
    }

    protected void deepCopy(Element source) throws SOAPException {
        this._name = NameImpl.fromElement(source);
        for (Node node = source.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof CharacterData) {
                this.addTextNode(((CharacterData)node).getData());
                continue;
            }
            if (node instanceof Element) {
                NameImpl name = NameImpl.fromNode(node);
                SOAPElementImpl child = (SOAPElementImpl)this._factory.createElement((Name)name);
                child.deepCopy((Element)node);
                this.addChildElement(child);
                continue;
            }
            this.appendChild(node.cloneNode(true));
        }
        this.copyAttributesAndNamespaces(source, true);
    }

    private void copyAttributesAndNamespaces(Element source, boolean addNamespaces) {
        if (source instanceof SOAPElementImpl) {
            for (Attr attr = ((SOAPElementImpl)((Object)source))._firstAttribute; attr != null; attr = (Attr)attr.getNextSibling()) {
                if (addNamespaces && "http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                    this._namespaces.put(attr.getLocalName(), attr.getValue());
                }
                this.setAttributeNode(attr);
            }
        } else {
            NamedNodeMap attributes = source.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                if (addNamespaces && "http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                    this._namespaces.put(attr.getLocalName(), attr.getValue());
                }
                this.setAttributeNode(attr);
            }
        }
    }

    public SOAPAttrImpl getFirstAttribute() {
        return this._firstAttribute;
    }

    public SOAPAttrImpl getLastAttribute() {
        return this._lastAttribute;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        this.setAttribute(NameImpl.fromName(name), value);
        return this;
    }

    public SOAPElement addAttribute(QName qname, String value) throws SOAPException {
        this.setAttribute(NameImpl.fromQName(qname), value);
        return this;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPElement child = this._factory.createElement(name);
        this.appendChild((Node)child);
        return child;
    }

    public SOAPElement addChildElement(QName qname) throws SOAPException {
        return this.addChildElement(NameImpl.fromQName(qname));
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        this.appendChild((Node)element);
        return element;
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addChildElement(new NameImpl(localName));
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String uri = this.getNamespaceURI(prefix);
        if (uri == null) {
            throw new SOAPException("Undefined prefix: " + prefix);
        }
        return this.addChildElement(localName, prefix, uri);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        return this.addChildElement(new NameImpl(uri, localName, prefix));
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        this._namespaces.put(prefix, uri);
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        return this;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        if (this._namespaces.remove(prefix) != null) {
            this.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix);
            return true;
        }
        return false;
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        this.appendChild((Node)((Object)new TextImpl(this._factory, text)));
        return this;
    }

    public QName createQName(String localName, String prefix) throws SOAPException {
        String uri = this.getNamespaceURI(prefix);
        if (uri == null) {
            throw new SOAPException("Undefined prefix: " + prefix);
        }
        return new NameImpl(uri, localName, prefix);
    }

    public Iterator getAllAttributes() {
        return new AttributeIterator(this._firstAttribute);
    }

    public Iterator getAllAttributesAsQNames() {
        return new AttributeIterator(this._firstAttribute);
    }

    public String getAttributeValue(Name name) {
        return this.getAttributeValue(NameImpl.toQName(name));
    }

    public String getAttributeValue(QName qname) {
        Attr attr = null;
        attr = qname.getNamespaceURI() != null ? this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart()) : this.getAttributeNode(qname.getLocalPart());
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public Iterator getChildElements() {
        return new NodeIterator();
    }

    public Iterator getChildElements(Name name) {
        return this.getChildElements(NameImpl.toQName(name));
    }

    public Iterator getChildElements(QName qname) {
        return new NodeIterator(qname);
    }

    public Name getElementName() {
        return this._name;
    }

    public QName getElementQName() {
        return this._name;
    }

    public String getEncodingStyle() {
        return this.getAttributeValue(ENCODING_STYLE_NAME);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        try {
            new URL(encodingStyle);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.addAttribute(ENCODING_STYLE_NAME, encodingStyle);
    }

    public Iterator getNamespacePrefixes() {
        return this._namespaces.keySet().iterator();
    }

    public Iterator getVisibleNamespacePrefixes() {
        return this._namespaces.keySet().iterator();
    }

    public String getNamespaceURI(String prefix) {
        String uri = this._namespaces.get(prefix);
        if (uri == null) {
            if (prefix.equals(this._name.getPrefix())) {
                return this._name.getURI();
            }
            if (this.getParentNode() != null) {
                return ((SOAPElement)this.getParentNode()).getNamespaceURI(prefix);
            }
            return null;
        }
        return uri;
    }

    public boolean removeAttribute(Name name) {
        SOAPAttrImpl attr = null;
        attr = name.getURI() != null ? (SOAPAttrImpl)this.getAttributeNodeNS(name.getURI(), name.getLocalName()) : (SOAPAttrImpl)this.getAttributeNode(name.getQualifiedName());
        if (attr != null) {
            attr.detachNode();
            return true;
        }
        return false;
    }

    public boolean removeAttribute(QName qname) {
        return this.removeAttribute(NameImpl.fromQName(qname));
    }

    public void removeContents() {
        SOAPNodeImpl node = this._firstChild;
        while (node != null) {
            SOAPNodeImpl current = node;
            node = current._next;
            current._parent = null;
            current._next = null;
            current._previous = null;
        }
        this._firstChild = null;
        this._lastChild = null;
    }

    public SOAPElement setElementQName(QName newName) throws SOAPException {
        this._name = NameImpl.fromQName(newName);
        return this;
    }

    public boolean hasAttributes() {
        return this._firstAttribute != null;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public String lookupNamespaceURI(String prefix) {
        return this.getNamespaceURI(prefix);
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this._firstAttribute);
    }

    public String getAttribute(String name) {
        for (Attr attr = this._firstAttribute; attr != null; attr = (Attr)attr.getNextSibling()) {
            if (!name.equals(attr.getName())) continue;
            return attr.getValue();
        }
        return "";
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        for (Attr attr = this._firstAttribute; attr != null; attr = (Attr)attr.getNextSibling()) {
            if (!localName.equals(attr.getLocalName()) || !namespaceURI.equals(attr.getNamespaceURI())) continue;
            return attr.getValue();
        }
        return "";
    }

    public Attr getAttributeNode(String name) {
        for (Attr attr = this._firstAttribute; attr != null; attr = (Attr)attr.getNextSibling()) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        for (Attr attr = this._firstAttribute; attr != null; attr = (Attr)attr.getNextSibling()) {
            if (!localName.equals(attr.getLocalName()) || !namespaceURI.equals(attr.getNamespaceURI())) continue;
            return attr;
        }
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        return new SelectiveNodeListImpl(name);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new SelectiveNodeListImpl(namespaceURI, localName);
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public String getTagName() {
        return this._name.getQualifiedName();
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public void removeAttribute(String name) {
        SOAPAttrImpl attr = (SOAPAttrImpl)this.getAttributeNode(name);
        if (attr == null) {
            return;
        }
        this.removeAttributeNode(attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        SOAPAttrImpl attr = (SOAPAttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (attr == null) {
            return;
        }
        this.removeAttributeNode(attr);
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        SOAPAttrImpl attr = (SOAPAttrImpl)oldAttr;
        if (attr._parent == this) {
            attr._parent = null;
            if (attr._previous != null) {
                attr._previous._next = attr._next;
            }
            if (attr._next != null) {
                attr._next._previous = attr._previous;
            }
        }
        return attr;
    }

    private void appendAttribute(SOAPAttrImpl attr) {
        attr._parent = this;
        if (this._lastAttribute != null) {
            this._lastAttribute._next = attr;
            attr._previous = this._lastAttribute;
            this._lastAttribute = attr;
        } else {
            this._lastAttribute = this._firstAttribute = attr;
        }
    }

    private void setAttribute(NameImpl name, String value) {
        Attr attr = null;
        attr = name.getURI() != null ? this.getAttributeNodeNS(name.getURI(), name.getLocalName()) : this.getAttributeNode(name.getLocalName());
        if (attr != null) {
            attr.setValue(value);
        } else {
            this.appendAttribute(new SOAPAttrImpl(this._factory, name, value));
        }
    }

    public void setAttribute(String name, String value) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setValue(value);
        } else {
            this.appendAttribute(new SOAPAttrImpl(this._factory, new NameImpl(name), value));
        }
    }

    public Attr setAttributeNode(Attr newAttr) {
        Attr attr = this.getAttributeNode(newAttr.getName());
        if (attr != null) {
            attr.setValue(newAttr.getValue());
            return attr;
        }
        if (newAttr instanceof SOAPAttrImpl) {
            this.appendAttribute((SOAPAttrImpl)newAttr);
            return newAttr;
        }
        SOAPAttrImpl soapAttr = new SOAPAttrImpl(this._factory, NameImpl.fromNode(newAttr));
        soapAttr.setValue(newAttr.getValue());
        this.appendAttribute(soapAttr);
        return soapAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        Attr attr = this.getAttributeNodeNS(newAttr.getNamespaceURI(), newAttr.getName());
        if (attr != null) {
            attr.setValue(newAttr.getValue());
            return attr;
        }
        this.appendAttribute((SOAPAttrImpl)newAttr);
        return newAttr;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, qualifiedName);
        if (attr != null) {
            attr.setValue(value);
        } else {
            NameImpl name = NameImpl.fromQualifiedName(namespaceURI, qualifiedName);
            this.appendAttribute(new SOAPAttrImpl(this._factory, name, value));
        }
    }

    public void setIdAttribute(String name, boolean isId) {
        SOAPAttrImpl attr = (SOAPAttrImpl)this.getAttributeNode(name);
        if (attr != null) {
            attr.setIsId(isId);
        }
    }

    public void setIdAttributeNode(Attr attr, boolean isId) {
        if (attr.getParentNode() != this) {
            throw new DOMException(8, "Attribute does not belong to this element");
        }
        ((SOAPAttrImpl)attr).setIsId(isId);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        SOAPAttrImpl attr = (SOAPAttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            attr.setIsId(isId);
        }
    }

    public String toString() {
        return "SOAPElement(" + System.identityHashCode(this) + ")[" + this._name + "]";
    }

    protected class SelectiveNodeListImpl
    implements NodeList {
        private String _name;
        private String _namespace;

        public SelectiveNodeListImpl(String namespace, String name) {
            this._namespace = namespace;
            this._name = name;
        }

        public SelectiveNodeListImpl(String name) {
            this(null, name);
        }

        public int getLength() {
            int length = 0;
            for (Object node = SOAPElementImpl.this._firstChild; node != null; node = node.getNextSibling()) {
                if (this._namespace != null) {
                    if (!this._namespace.equals(node.getNamespaceURI()) || !this._name.equals(node.getLocalName())) continue;
                    ++length;
                    continue;
                }
                if (!this._name.equals(node.getNodeName())) continue;
                ++length;
            }
            return length;
        }

        public Node item(int i) {
            int j = 0;
            for (Object node = SOAPElementImpl.this._firstChild; node != null; node = node.getNextSibling()) {
                if (i == j) {
                    return node;
                }
                if (this._namespace != null) {
                    if (!this._namespace.equals(node.getNamespaceURI()) || !this._name.equals(node.getLocalName())) continue;
                    ++j;
                    continue;
                }
                if (!this._name.equals(node.getNodeName())) continue;
                ++j;
            }
            return null;
        }
    }

    protected class NodeIterator
    implements Iterator {
        private QName _name;
        private SOAPNodeImpl _node;

        public NodeIterator(QName name) {
            this._name = name;
            if (this._name == null) {
                this._node = SOAPElementImpl.this._firstChild;
            } else if (this._name.getNamespaceURI() == null) {
                this._node = SOAPElementImpl.this._firstChild;
                while (this._node != null && !this._name.getLocalPart().equals(this._node.getLocalName())) {
                    this._node = this._node._next;
                }
            } else {
                this._node = SOAPElementImpl.this._firstChild;
                while (!(this._node == null || this._name.getNamespaceURI().equals(this._node.getNamespaceURI()) && this._name.getLocalPart().equals(this._node.getLocalName()))) {
                    this._node = this._node._next;
                }
            }
        }

        public NodeIterator() {
            this(null);
        }

        public boolean hasNext() {
            return this._node != null;
        }

        public Object next() {
            if (this._node == null) {
                throw new NoSuchElementException();
            }
            if (this._name == null) {
                SOAPNodeImpl next = this._node;
                this._node = this._node._next;
                return next;
            }
            if (this._name.getNamespaceURI() == null) {
                SOAPNodeImpl next = this._node;
                this._node = this._node._next;
                while (this._node != null && !this._name.getLocalPart().equals(this._node.getNodeName())) {
                    this._node = this._node._next;
                }
                return next;
            }
            SOAPNodeImpl next = this._node;
            this._node = this._node._next;
            while (!(this._node == null || this._name.getLocalPart().equals(this._node.getLocalName()) && this._name.getNamespaceURI().equals(this._node.getNamespaceURI()))) {
                this._node = this._node._next;
            }
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class NamedNodeMapImpl
    implements NamedNodeMap {
        private Node _first;

        NamedNodeMapImpl(Node first) {
            this._first = first;
        }

        public int getLength() {
            int length = 0;
            for (Node node = this._first; node != null; node = node.getNextSibling()) {
                ++length;
            }
            return length;
        }

        public Node getNamedItem(String name) {
            for (Node node = this._first; node != null; node = node.getNextSibling()) {
                if (!name.equals(node.getNodeName())) continue;
                return node;
            }
            return null;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            for (Node node = this._first; node != null; node = node.getNextSibling()) {
                if (!localName.equals(node.getLocalName()) || !namespaceURI.equals(node.getNamespaceURI())) continue;
                return node;
            }
            return null;
        }

        public Node item(int index) {
            int i = 0;
            for (Node node = this._first; node != null; node = node.getNextSibling()) {
                if (i == index) {
                    return node;
                }
                ++i;
            }
            return null;
        }

        public Node removeNamedItem(String name) {
            SOAPNodeImpl node = (SOAPNodeImpl)((Object)this.getNamedItem(name));
            node._parent = null;
            if (node._previous != null) {
                node._previous._next = node._next;
            }
            if (node._next != null) {
                node._next._previous = node._previous;
            }
            node._previous = null;
            node._next = null;
            return node;
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) {
            SOAPNodeImpl node = (SOAPNodeImpl)((Object)this.getNamedItemNS(namespaceURI, localName));
            node._parent = null;
            if (node._previous != null) {
                node._previous._next = node._next;
            }
            if (node._next != null) {
                node._next._previous = node._previous;
            }
            node._previous = null;
            node._next = null;
            return node;
        }

        public Node setNamedItem(Node arg) {
            Node node = this.getNamedItem(arg.getNodeName());
            if (arg.getParentNode() != null) {
                return arg.getParentNode().replaceChild(arg, node);
            }
            return null;
        }

        public Node setNamedItemNS(Node arg) {
            Node node = this.getNamedItemNS(arg.getNamespaceURI(), arg.getLocalName());
            if (arg.getParentNode() != null) {
                return arg.getParentNode().replaceChild(arg, node);
            }
            return null;
        }
    }

    private static class AttributeIterator
    implements Iterator {
        private SOAPAttrImpl _current;

        public AttributeIterator(SOAPAttrImpl first) {
            this._current = first;
        }

        public boolean hasNext() {
            return this._current != null;
        }

        public Object next() {
            if (this._current == null) {
                throw new NoSuchElementException();
            }
            NameImpl name = this._current._name;
            this._current = (SOAPAttrImpl)this._current.getNextSibling();
            return name;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

