/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAPElementImpl;
import com.caucho.xml.saaj.SOAPNodeImpl;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import org.w3c.dom.Element;

public abstract class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope {
    protected SOAPHeader _header;
    protected SOAPBody _body;
    protected static final NameImpl SOAP_1_1_ENVELOPE_NAME = new NameImpl("http://schemas.xmlsoap.org/soap/envelope/", "Envelope", "env");
    protected static final NameImpl SOAP_1_1_BODY_NAME = new NameImpl("http://schemas.xmlsoap.org/soap/envelope/", "Body", "env");
    protected static final NameImpl SOAP_1_1_HEADER_NAME = new NameImpl("http://schemas.xmlsoap.org/soap/envelope/", "Header", "env");
    protected static final NameImpl SOAP_1_2_ENVELOPE_NAME = new NameImpl("http://www.w3.org/2003/05/soap-envelope", "Envelope", "env");
    protected static final NameImpl SOAP_1_2_BODY_NAME = new NameImpl("http://www.w3.org/2003/05/soap-envelope", "Body", "env");
    protected static final NameImpl SOAP_1_2_HEADER_NAME = new NameImpl("http://www.w3.org/2003/05/soap-envelope", "Header", "env");

    protected SOAPEnvelopeImpl(SOAPFactory factory, NameImpl name) throws SOAPException {
        super(factory, name);
    }

    public SOAPBody addBody() throws SOAPException {
        if (this._body != null) {
            throw new SOAPException("Envelope already contains Body");
        }
        SOAPBody body = (SOAPBody)this._factory.createElement(this.getBodyName());
        this.addChildElement((SOAPElement)body);
        this._body = body;
        return this._body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        if (this._header != null) {
            throw new SOAPException("Envelope already contains Header");
        }
        this._header = (SOAPHeader)this._factory.createElement(this.getHeaderName());
        SOAPBody body = this._body;
        if (body != null) {
            body.detachNode();
        }
        this.addChildElement((SOAPElement)this._header);
        if (body != null) {
            this.addChildElement((SOAPElement)body);
            this._body = body;
        }
        return this._header;
    }

    public Name createName(String localName) throws SOAPException {
        return this._factory.createName(localName);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return this._factory.createName(localName, prefix, uri);
    }

    public SOAPBody getBody() throws SOAPException {
        return this._body;
    }

    public SOAPHeader getHeader() throws SOAPException {
        return this._header;
    }

    public SOAPElement setElementQName(QName newName) throws SOAPException {
        throw new SOAPException("Cannot set name of SOAP Envelope");
    }

    protected void deepCopy(Element source) throws SOAPException {
        super.deepCopy(source);
        SOAPNodeImpl node = this._firstChild;
        while (node != null) {
            if (node instanceof SOAPBody) {
                this._body = (SOAPBody)node;
            } else if (node instanceof SOAPHeader) {
                this._header = (SOAPHeader)node;
            }
            if (this._body != null && this._header != null) break;
            node = node._next;
        }
    }

    protected abstract Name getBodyName();

    protected abstract Name getHeaderName();
}

