/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAP11BodyImpl;
import com.caucho.xml.saaj.SOAP11DetailImpl;
import com.caucho.xml.saaj.SOAP11EnvelopeImpl;
import com.caucho.xml.saaj.SOAP11FaultImpl;
import com.caucho.xml.saaj.SOAP11HeaderImpl;
import com.caucho.xml.saaj.SOAP12BodyImpl;
import com.caucho.xml.saaj.SOAP12DetailImpl;
import com.caucho.xml.saaj.SOAP12EnvelopeImpl;
import com.caucho.xml.saaj.SOAP12FaultImpl;
import com.caucho.xml.saaj.SOAP12HeaderImpl;
import com.caucho.xml.saaj.SOAPElementImpl;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Element;

public class SOAPFactoryImpl
extends SOAPFactory {
    private final String _protocol;

    public SOAPFactoryImpl() throws SOAPException {
        this("SOAP 1.1 Protocol");
    }

    public SOAPFactoryImpl(String protocol) throws SOAPException {
        if (!(protocol.equals("SOAP 1.1 Protocol") || protocol.equals("SOAP 1.2 Protocol") || protocol.equals("Dynamic Protocol"))) {
            throw new SOAPException("Unsupported protocol : " + protocol);
        }
        this._protocol = protocol;
    }

    public Detail createDetail() throws SOAPException {
        if (this._protocol.equals("SOAP 1.1 Protocol")) {
            return new SOAP11DetailImpl(this);
        }
        if (this._protocol.equals("SOAP 1.2 Protocol")) {
            return new SOAP12DetailImpl(this);
        }
        throw new SOAPException("Cannot create detail for protocol: " + this._protocol);
    }

    public SOAPElement createElement(Element domElement) throws SOAPException {
        return new SOAPElementImpl((SOAPFactory)this, domElement);
    }

    public SOAPElement createElement(Name name) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(name.getURI())) {
            if ("Envelope".equals(name.getLocalName())) {
                return new SOAP11EnvelopeImpl(this);
            }
            if ("Header".equals(name.getLocalName())) {
                return new SOAP11HeaderImpl((SOAPFactory)this, NameImpl.fromName(name));
            }
            if ("Body".equals(name.getLocalName())) {
                return new SOAP11BodyImpl((SOAPFactory)this, NameImpl.fromName(name));
            }
            if ("Fault".equals(name.getLocalName())) {
                return new SOAP11FaultImpl((SOAPFactory)this, NameImpl.fromName(name));
            }
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(name.getURI())) {
            if ("Envelope".equals(name.getLocalName())) {
                return new SOAP12EnvelopeImpl(this);
            }
            if ("Header".equals(name.getLocalName())) {
                return new SOAP12HeaderImpl((SOAPFactory)this, NameImpl.fromName(name));
            }
            if ("Body".equals(name.getLocalName())) {
                return new SOAP12BodyImpl((SOAPFactory)this, NameImpl.fromName(name));
            }
            if ("Fault".equals(name.getLocalName())) {
                return new SOAP12FaultImpl((SOAPFactory)this, NameImpl.fromName(name));
            }
        }
        return new SOAPElementImpl((SOAPFactory)this, NameImpl.fromName(name));
    }

    public SOAPElement createElement(QName qname) throws SOAPException {
        return this.createElement(NameImpl.fromQName(qname));
    }

    public SOAPElement createElement(String localName) throws SOAPException {
        return new SOAPElementImpl((SOAPFactory)this, new NameImpl(localName));
    }

    public SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        return new SOAPElementImpl((SOAPFactory)this, new NameImpl(uri, localName, prefix));
    }

    public SOAPFault createFault() throws SOAPException {
        if ("SOAP 1.1 Protocol".equals(this._protocol)) {
            return new SOAP11FaultImpl(this);
        }
        if ("SOAP 1.2 Protocol".equals(this._protocol)) {
            return new SOAP12FaultImpl(this);
        }
        throw new SOAPException("Unsupported protocol: " + this._protocol);
    }

    public SOAPFault createFault(String reasonText, QName faultCode) throws SOAPException {
        SOAPFault fault = this.createFault();
        fault.setFaultString(reasonText);
        fault.setFaultCode(faultCode);
        return fault;
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(uri, localName, prefix);
    }
}

