/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.util.Base64;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlPrinter;
import com.caucho.xml.saaj.AttachmentPartImpl;
import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAPPartImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.SAXException;

public class SOAPMessageImpl
extends SOAPMessage {
    private static final Name SOAP_NAMESPACE_NAME = new NameImpl("http://www.w3.org/2000/xmlns/", "env", "xmlns");
    private final ArrayList<AttachmentPart> _attachments = new ArrayList();
    private final HashMap<String, Object> _properties = new HashMap();
    private static Random _r = new Random();
    private String _description;
    private SOAPPart _part;
    private SOAPFactory _factory;
    private String _protocol;
    private boolean _saveRequired = true;
    private MimeHeaders _headers = new MimeHeaders();

    public static void setRandomSeed(long seed) {
        _r = new Random(seed);
    }

    SOAPMessageImpl(SOAPFactory factory, String protocol) throws SOAPException {
        this.init(factory, protocol);
        this._part = new SOAPPartImpl(factory, protocol);
    }

    SOAPMessageImpl(SOAPFactory factory, String protocol, MimeHeaders headers, InputStream in) throws IOException, SOAPException {
        this.init(factory, protocol);
        try {
            Document doc = new Xml().parseDocument(in);
            this._part = new SOAPPartImpl(factory, protocol, doc);
        }
        catch (SAXException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    private void init(SOAPFactory factory, String protocol) {
        this._factory = factory;
        this._protocol = protocol;
        this._properties.put("javax.xml.soap.write-xml-declaration", "false");
        this._properties.put("javax.xml.soap.character-set-encoding", "utf-8");
        this._headers.addHeader("Content-Type", "text/xml");
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        this._attachments.add(attachmentPart);
    }

    public int countAttachments() {
        return this._attachments.size();
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public AttachmentPart createAttachmentPart(DataHandler dataHandler) {
        AttachmentPartImpl attachmentPart = new AttachmentPartImpl();
        attachmentPart.setDataHandler(dataHandler);
        return attachmentPart;
    }

    public AttachmentPart createAttachmentPart(Object content, String contentType) {
        AttachmentPartImpl attachmentPart = new AttachmentPartImpl();
        attachmentPart.setContent(content, contentType);
        return attachmentPart;
    }

    public AttachmentPart getAttachment(SOAPElement element) throws SOAPException {
        String href = element.getAttribute("href");
        if (href != null && !"".equals(href)) {
            if (href.startsWith("cid:")) {
                String contentId = '<' + href.substring("cid:".length()) + '>';
                return this.findAttachmentByContentId(contentId);
            }
            return this.findAttachmentByContentLocation(href);
        }
        href = element.getValue();
        if (href != null && !"".equals(href)) {
            if (href.startsWith("cid:")) {
                String contentId = '<' + href.substring("cid:".length()) + '>';
                return this.findAttachmentByContentId(contentId);
            }
            return this.findAttachmentByContentLocation(href);
        }
        return null;
    }

    private AttachmentPart findAttachmentByContentId(String contentId) {
        for (int i = 0; i < this._attachments.size(); ++i) {
            if (!contentId.equals(this._attachments.get(i).getContentId())) continue;
            return this._attachments.get(i);
        }
        return null;
    }

    private AttachmentPart findAttachmentByContentLocation(String contentLocation) {
        for (int i = 0; i < this._attachments.size(); ++i) {
            if (!contentLocation.equals(this._attachments.get(i).getContentLocation())) continue;
            return this._attachments.get(i);
        }
        return null;
    }

    public Iterator getAttachments() {
        return this._attachments.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return new MatchingHeadersIterator(headers);
    }

    public String getContentDescription() {
        return this._description;
    }

    public void setContentDescription(String description) {
        this._description = description;
    }

    public MimeHeaders getMimeHeaders() {
        return this._headers;
    }

    public Object getProperty(String property) throws SOAPException {
        Object o = this._properties.get(property);
        if (o == null) {
            throw new SOAPException("Unrecognized property : " + property);
        }
        return o;
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this._part.getEnvelope().getBody();
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this._part.getEnvelope().getHeader();
    }

    public SOAPPart getSOAPPart() {
        return this._part;
    }

    public void removeAllAttachments() {
        this._attachments.clear();
    }

    public void removeAttachments(MimeHeaders headers) {
        Iterator iterator = this.getAttachments(headers);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public void saveChanges() throws SOAPException {
        this._saveRequired = false;
    }

    public boolean saveRequired() {
        return this._saveRequired;
    }

    public void setProperty(String property, Object value) throws SOAPException {
        this._properties.put(property, value);
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        this.saveChanges();
        OutputStreamWriter osw = new OutputStreamWriter(out);
        PrintWriter w = new PrintWriter(osw);
        String separator = null;
        if (this._attachments.size() > 0) {
            separator = "------=_Part_" + _r.nextLong();
            w.println(separator);
            Iterator iterator = this.getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader header = (MimeHeader)iterator.next();
                w.println(header.getName() + ": " + header.getValue());
            }
            w.println();
        }
        XmlPrinter printer = new XmlPrinter(w);
        printer.setEncoding((String)this._properties.get("javax.xml.soap.character-set-encoding"));
        boolean printDeclaration = Boolean.valueOf((String)this._properties.get("javax.xml.soap.write-xml-declaration"));
        printer.setPrintDeclaration(printDeclaration);
        SOAPEnvelope envelope = this._part.getEnvelope();
        Iterator attrs = envelope.getAllAttributes();
        boolean foundSoapNS = false;
        while (attrs.hasNext()) {
            Name name = (Name)attrs.next();
            String value = envelope.getAttributeValue(name);
            if (!value.equals(envelope.getNamespaceURI()) || !"xmlns".equals(name.getPrefix())) continue;
            foundSoapNS = true;
            break;
        }
        if (!foundSoapNS) {
            envelope.addAttribute(SOAP_NAMESPACE_NAME, envelope.getNamespaceURI());
        }
        printer.printNode((Node)this._part);
        if (!foundSoapNS) {
            envelope.removeAttribute(SOAP_NAMESPACE_NAME);
        }
        if (this._attachments.size() > 0) {
            w.println();
        }
        for (int i = 0; i < this._attachments.size(); ++i) {
            w.println(separator);
            AttachmentPart ap = this._attachments.get(i);
            Iterator iterator = ap.getAllMimeHeaders();
            while (iterator.hasNext()) {
                MimeHeader header = (MimeHeader)iterator.next();
                w.println(header.getName() + ": " + header.getValue());
            }
            w.println();
            Base64.encode((Writer)w, (InputStream)ap.getRawContent());
        }
        if (this._attachments.size() > 0) {
            w.println();
            w.println(separator + "--");
        }
        w.flush();
    }

    public Node adoptNode(Node source) {
        throw new UnsupportedOperationException();
    }

    public Attr createAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    public CDATASection createCDATASection(String data) {
        throw new UnsupportedOperationException();
    }

    public Comment createComment(String data) {
        throw new UnsupportedOperationException();
    }

    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException();
    }

    public Element createElement(String tagName) {
        throw new UnsupportedOperationException();
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    public EntityReference createEntityReference(String name) {
        throw new UnsupportedOperationException();
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        throw new UnsupportedOperationException();
    }

    public Text createTextNode(String data) {
        throw new UnsupportedOperationException();
    }

    public DocumentType getDoctype() {
        throw new UnsupportedOperationException();
    }

    public Element getDocumentElement() {
        throw new UnsupportedOperationException();
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException();
    }

    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException();
    }

    public Element getElementById(String elementId) {
        throw new UnsupportedOperationException();
    }

    public NodeList getElementsByTagName(String tagname) {
        throw new UnsupportedOperationException();
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException();
    }

    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException();
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException();
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException();
    }

    public String getXmlEncoding() {
        throw new UnsupportedOperationException();
    }

    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException();
    }

    public String getXmlVersion() {
        throw new UnsupportedOperationException();
    }

    public Node importNode(Node importedNode, boolean deep) {
        throw new UnsupportedOperationException();
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException();
    }

    public void setXmlStandalone(boolean xmlStandalone) {
        throw new UnsupportedOperationException();
    }

    public void setXmlVersion(String xmlVersion) {
        throw new UnsupportedOperationException();
    }

    public Node appendChild(Node newChild) {
        throw new UnsupportedOperationException();
    }

    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    public short compareDocumentPosition(Node other) {
        throw new UnsupportedOperationException();
    }

    public NamedNodeMap getAttributes() {
        throw new UnsupportedOperationException();
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException();
    }

    public NodeList getChildNodes() {
        throw new UnsupportedOperationException();
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public Node getFirstChild() {
        throw new UnsupportedOperationException();
    }

    public Node getLastChild() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceURI() {
        throw new UnsupportedOperationException();
    }

    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    public String getNodeName() {
        throw new UnsupportedOperationException();
    }

    public short getNodeType() {
        throw new UnsupportedOperationException();
    }

    public String getNodeValue() {
        throw new UnsupportedOperationException();
    }

    public Document getOwnerDocument() {
        throw new UnsupportedOperationException();
    }

    public Node getParentNode() {
        throw new UnsupportedOperationException();
    }

    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    public String getTextContent() {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAttributes() {
        throw new UnsupportedOperationException();
    }

    public boolean hasChildNodes() {
        throw new UnsupportedOperationException();
    }

    public Node insertBefore(Node newChild, Node refChild) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public void normalize() {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(Node oldChild) {
        throw new UnsupportedOperationException();
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        throw new UnsupportedOperationException();
    }

    public void setNodeValue(String nodeValue) {
        throw new UnsupportedOperationException();
    }

    public void setPrefix(String prefix) {
        throw new UnsupportedOperationException();
    }

    public void setTextContent(String textContent) {
        throw new UnsupportedOperationException();
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }

    private class MatchingHeadersIterator
    implements Iterator {
        private MimeHeaders _headers;
        private int _current = -1;
        private int _last = -1;

        public MatchingHeadersIterator(MimeHeaders headers) {
            this._headers = headers;
            this.advance();
        }

        public Object next() {
            if (this.hasNext()) {
                Object next = SOAPMessageImpl.this._attachments.get(this._current);
                this.advance();
                return next;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this._current < SOAPMessageImpl.this._attachments.size();
        }

        public void remove() {
            SOAPMessageImpl.this._attachments.remove(this._last);
        }

        private void advance() {
            this._last = this._current++;
            while (this._current < SOAPMessageImpl.this._attachments.size() && !this.attachmentMatchesHeaders((AttachmentPart)SOAPMessageImpl.this._attachments.get(this._current))) {
                ++this._current;
            }
        }

        private boolean attachmentMatchesHeaders(AttachmentPart attachment) {
            Iterator iterator = this._headers.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader header = (MimeHeader)iterator.next();
                String[] values = attachment.getMimeHeader(header.getName());
                boolean headerFound = false;
                for (String value : values) {
                    if (!header.getValue().equals(value)) continue;
                    headerFound = true;
                    break;
                }
                if (headerFound) continue;
                return false;
            }
            return true;
        }
    }
}

