/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.xml.XmlUtil;
import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAPElementImpl;
import com.caucho.xml.saaj.TextImpl;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Text;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class SOAPNodeImpl
implements Node {
    protected SOAPFactory _factory;
    protected Document _owner;
    protected SOAPElementImpl _parent;
    protected SOAPNodeImpl _firstChild;
    protected SOAPNodeImpl _lastChild;
    protected SOAPNodeImpl _next;
    protected SOAPNodeImpl _previous;
    protected NameImpl _name;

    protected SOAPNodeImpl(SOAPFactory factory, NameImpl name) {
        this._factory = factory;
        this._name = name;
    }

    protected SOAPNodeImpl(SOAPFactory factory, NameImpl name, Document owner) {
        this._factory = factory;
        this._name = name;
        this._owner = owner;
    }

    public void setOwner(Document owner) {
        this._owner = owner;
    }

    public void detachNode() {
        if (this.getParentNode() != null) {
            this.getParentNode().removeChild((org.w3c.dom.Node)((Object)this));
        }
    }

    public SOAPElement getParentElement() {
        return (SOAPElement)this.getParentNode();
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parent instanceof SOAPElementImpl ? (SOAPElementImpl)parent : new SOAPElementImpl(this._factory, (Element)parent);
    }

    public String getValue() {
        if (this._firstChild == null || this._firstChild != this._lastChild) {
            return null;
        }
        if (this._firstChild instanceof Text) {
            return ((Text)this._firstChild).getValue();
        }
        return null;
    }

    public void setValue(String value) {
        if (this._firstChild == null) {
            this.appendChild((org.w3c.dom.Node)((Object)new TextImpl(this._factory, value)));
        } else {
            if (this._firstChild != this._lastChild) {
                throw new IllegalStateException("Element has more than one child");
            }
            if (!(this._firstChild instanceof Text)) {
                throw new IllegalStateException("Child is not a Text node");
            }
            ((Text)this._firstChild).setValue(value);
        }
    }

    public void recycleNode() {
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this._owner;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) {
        SOAPNodeImpl node = (SOAPNodeImpl)((Object)newChild);
        try {
            if (this instanceof SOAPElementImpl) {
                node.setParentElement((SOAPElementImpl)this);
            }
        }
        catch (SOAPException e) {
            throw new DOMException(3, e.getMessage());
        }
        node._owner = this._owner;
        if (this._lastChild == null) {
            this._firstChild = this._lastChild = node;
        } else {
            this._lastChild._next = node;
            node._previous = this._lastChild;
            this._lastChild = node;
        }
        return newChild;
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) {
        throw new UnsupportedOperationException();
    }

    public String getBaseURI() {
        return null;
    }

    public NodeList getChildNodes() {
        return new NodeListImpl();
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public org.w3c.dom.Node getFirstChild() {
        return this._firstChild;
    }

    public org.w3c.dom.Node getLastChild() {
        return this._lastChild;
    }

    public String getPrefix() {
        return this._name.getPrefix();
    }

    public String getLocalName() {
        return this._name.getLocalName();
    }

    public String getNamespaceURI() {
        if ("".equals(this._name.getURI())) {
            return null;
        }
        return this._name.getURI();
    }

    public org.w3c.dom.Node getNextSibling() {
        return this._next;
    }

    public org.w3c.dom.Node getParentNode() {
        return this._parent;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return this._previous;
    }

    public String getTextContent() {
        return XmlUtil.textValue((org.w3c.dom.Node)((Object)this));
    }

    public Object getUserData(String key) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return this._firstChild != null;
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        NamedNodeMap otherMap;
        if (arg == null) {
            return false;
        }
        if (this.getNodeType() != arg.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null && arg.getNodeName() != null || this.getNodeName() != null && !this.getNodeName().equals(arg.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null && arg.getLocalName() != null || this.getLocalName() != null && !this.getLocalName().equals(arg.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null && arg.getNamespaceURI() != null || this.getNamespaceURI() != null && !this.getNamespaceURI().equals(arg.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null && arg.getPrefix() != null || this.getPrefix() != null && !this.getPrefix().equals(arg.getPrefix())) {
            return false;
        }
        if (this.getNodeValue() == null && arg.getNodeValue() != null || this.getNodeValue() != null && !this.getNodeValue().equals(arg.getNodeValue())) {
            return false;
        }
        NamedNodeMap map = this.getAttributes();
        if (map == null != ((otherMap = arg.getAttributes()) == null)) {
            return false;
        }
        if (map != null) {
            if (map.getLength() != otherMap.getLength()) {
                return false;
            }
            for (int i = 0; i < map.getLength(); ++i) {
                org.w3c.dom.Node attr = map.item(i);
                org.w3c.dom.Node otherAttr = null;
                otherAttr = attr.getNamespaceURI() != null ? otherMap.getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : otherMap.getNamedItem(attr.getLocalName());
                if (otherAttr != null && attr.isEqualNode(otherAttr)) continue;
                return false;
            }
        }
        this.normalize();
        arg.normalize();
        NodeList children = this.getChildNodes();
        NodeList otherChildren = arg.getChildNodes();
        if (children.getLength() != otherChildren.getLength()) {
            return false;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).isEqualNode(otherChildren.item(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        return this == other;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public void normalize() {
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) {
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, "Child does not belong to this node");
        }
        SOAPNodeImpl node = (SOAPNodeImpl)((Object)oldChild);
        node._parent = null;
        if (node == this._firstChild) {
            this._firstChild = node._next;
        } else if (node._previous != null) {
            node._previous._next = node._next;
        }
        if (node == this._lastChild) {
            this._lastChild = node._previous;
        } else if (node._next != null) {
            node._next._previous = node._previous;
        }
        node._previous = null;
        node._next = null;
        return node;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) {
        throw new UnsupportedOperationException();
    }

    public void setNodeValue(String nodeValue) {
    }

    public void setPrefix(String prefix) {
    }

    public void setTextContent(String textContent) {
        throw new UnsupportedOperationException();
    }

    protected class NodeListImpl
    implements NodeList {
        protected NodeListImpl() {
        }

        public int getLength() {
            int length = 0;
            for (Object node = SOAPNodeImpl.this._firstChild; node != null; node = node.getNextSibling()) {
                ++length;
            }
            return length;
        }

        public org.w3c.dom.Node item(int i) {
            int j = 0;
            for (Object node = SOAPNodeImpl.this._firstChild; node != null; node = node.getNextSibling()) {
                if (i == j) {
                    return node;
                }
                ++j;
            }
            return null;
        }
    }
}

