/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.saaj;

import com.caucho.util.L10N;
import com.caucho.xml.saaj.NameImpl;
import com.caucho.xml.saaj.SOAPEnvelopeImpl;
import java.util.Iterator;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private static final L10N L = new L10N(SOAPPartImpl.class);
    private SOAPFactory _factory;
    private SOAPEnvelopeImpl _envelope;
    private String _protocol;
    private MimeHeaders _headers = new MimeHeaders();
    private Transformer _transformer;
    private String _xmlEncoding = "utf-8";
    private String _xmlVersion = "1.0";
    private boolean _xmlStandalone = true;

    SOAPPartImpl(SOAPFactory factory, String protocol) throws SOAPException {
        this._factory = factory;
        this._protocol = protocol;
        NameImpl envelopeName = null;
        if ("SOAP 1.1 Protocol".equals(this._protocol)) {
            envelopeName = SOAPEnvelopeImpl.SOAP_1_1_ENVELOPE_NAME;
        } else if ("SOAP 1.2 Protocol".equals(this._protocol)) {
            envelopeName = SOAPEnvelopeImpl.SOAP_1_2_ENVELOPE_NAME;
        } else {
            if ("Dynamic Protocol".equals(this._protocol)) {
                throw new UnsupportedOperationException();
            }
            throw new SOAPException("Unknown SOAP protocol: " + this._protocol);
        }
        this._envelope = (SOAPEnvelopeImpl)this._factory.createElement((Name)envelopeName);
        this._envelope.setOwner((Document)((Object)this));
        this._envelope.addHeader();
        this._envelope.addBody();
    }

    SOAPPartImpl(SOAPFactory factory, String protocol, Document document) throws SOAPException {
        this._factory = factory;
        this._protocol = protocol;
        NameImpl envelopeName = null;
        if ("SOAP 1.1 Protocol".equals(this._protocol)) {
            envelopeName = SOAPEnvelopeImpl.SOAP_1_1_ENVELOPE_NAME;
        } else if ("SOAP 1.2 Protocol".equals(this._protocol)) {
            envelopeName = SOAPEnvelopeImpl.SOAP_1_2_ENVELOPE_NAME;
        } else if ("Dynamic Protocol".equals(this._protocol)) {
            envelopeName = NameImpl.fromElement(document.getDocumentElement());
        } else {
            throw new SOAPException("Unknown SOAP protocol: " + this._protocol);
        }
        this._xmlEncoding = document.getXmlEncoding();
        this._xmlVersion = document.getXmlVersion();
        this._xmlStandalone = document.getXmlStandalone();
        this._envelope = (SOAPEnvelopeImpl)this._factory.createElement((Name)envelopeName);
        this._envelope.setOwner((Document)((Object)this));
        this._envelope.deepCopy(document.getDocumentElement());
    }

    private Transformer getTransformer() throws TransformerException {
        if (this._transformer == null) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this._transformer = transformerFactory.newTransformer();
        }
        return this._transformer;
    }

    public void addMimeHeader(String name, String value) {
        this._headers.addHeader(name, value);
    }

    public Iterator getAllMimeHeaders() {
        return this._headers.getAllHeaders();
    }

    public Source getContent() throws SOAPException {
        return new DOMSource((Node)((Object)this));
    }

    public SOAPEnvelope getEnvelope() throws SOAPException {
        return this._envelope;
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        return this._headers.getMatchingHeaders(names);
    }

    public String[] getMimeHeader(String name) {
        return this._headers.getHeader(name);
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this._headers.getNonMatchingHeaders(names);
    }

    public void removeAllMimeHeaders() {
        this._headers.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this._headers.removeHeader(header);
    }

    public void setContent(Source source) throws SOAPException {
        Node node = null;
        Element element = null;
        if (source instanceof DOMSource) {
            node = ((DOMSource)source).getNode();
        } else {
            try {
                DOMResult result = new DOMResult();
                this.getTransformer().transform(source, result);
                node = result.getNode();
            }
            catch (TransformerException e) {
                throw new SOAPException((Throwable)e);
            }
        }
        if (node.getNodeType() == 9) {
            element = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() == 1) {
            element = (Element)node;
        } else {
            throw new SOAPException(L.l("Source (or transformed DOM) does not have a Document or Element node: {0}", (Object)source));
        }
        NameImpl envelopeName = null;
        if ("SOAP 1.1 Protocol".equals(this._protocol)) {
            envelopeName = SOAPEnvelopeImpl.SOAP_1_1_ENVELOPE_NAME;
        } else if ("SOAP 1.2 Protocol".equals(this._protocol)) {
            envelopeName = SOAPEnvelopeImpl.SOAP_1_2_ENVELOPE_NAME;
        } else if ("Dynamic Protocol".equals(this._protocol)) {
            envelopeName = NameImpl.fromElement(element);
        } else {
            throw new SOAPException("Unknown SOAP protocol: " + this._protocol);
        }
        this._envelope = (SOAPEnvelopeImpl)this._factory.createElement((Name)envelopeName);
        this._envelope.setOwner((Document)((Object)this));
        this._envelope.deepCopy(element);
    }

    public void setMimeHeader(String name, String value) {
        this._headers.setHeader(name, value);
    }

    public void detachNode() {
        throw new UnsupportedOperationException();
    }

    public SOAPElement getParentElement() {
        throw new UnsupportedOperationException();
    }

    public String getValue() {
        throw new UnsupportedOperationException();
    }

    public void recycleNode() {
        throw new UnsupportedOperationException();
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public Node adoptNode(Node source) {
        throw new UnsupportedOperationException();
    }

    public Attr createAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    public CDATASection createCDATASection(String data) {
        throw new UnsupportedOperationException();
    }

    public Comment createComment(String data) {
        throw new UnsupportedOperationException();
    }

    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException();
    }

    public Element createElement(String tagName) {
        throw new UnsupportedOperationException();
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    public EntityReference createEntityReference(String name) {
        throw new UnsupportedOperationException();
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        throw new UnsupportedOperationException();
    }

    public Text createTextNode(String data) {
        throw new UnsupportedOperationException();
    }

    public DocumentType getDoctype() {
        throw new UnsupportedOperationException();
    }

    public Element getDocumentElement() {
        return this._envelope;
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException();
    }

    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException();
    }

    public Element getElementById(String elementId) {
        throw new UnsupportedOperationException();
    }

    public NodeList getElementsByTagName(String tagname) {
        throw new UnsupportedOperationException();
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException();
    }

    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException();
    }

    public String getInputEncoding() {
        throw new UnsupportedOperationException();
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException();
    }

    public String getXmlEncoding() {
        return this._xmlEncoding;
    }

    public boolean getXmlStandalone() {
        return this._xmlStandalone;
    }

    public String getXmlVersion() {
        return this._xmlVersion;
    }

    public Node importNode(Node importedNode, boolean deep) {
        throw new UnsupportedOperationException();
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException();
    }

    public void setXmlStandalone(boolean xmlStandalone) {
        this._xmlStandalone = xmlStandalone;
    }

    public void setXmlVersion(String xmlVersion) {
        this._xmlVersion = xmlVersion;
    }

    public Node appendChild(Node newChild) {
        throw new UnsupportedOperationException();
    }

    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    public short compareDocumentPosition(Node other) {
        throw new UnsupportedOperationException();
    }

    public NamedNodeMap getAttributes() {
        throw new UnsupportedOperationException();
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException();
    }

    public NodeList getChildNodes() {
        return new NodeListImpl();
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public Node getFirstChild() {
        return this._envelope;
    }

    public Node getLastChild() {
        return this._envelope;
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceURI() {
        throw new UnsupportedOperationException();
    }

    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeValue() {
        throw new UnsupportedOperationException();
    }

    public Document getOwnerDocument() {
        throw new UnsupportedOperationException();
    }

    public Node getParentNode() {
        throw new UnsupportedOperationException();
    }

    public String getPrefix() {
        throw new UnsupportedOperationException();
    }

    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    public String getTextContent() {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAttributes() {
        throw new UnsupportedOperationException();
    }

    public boolean hasChildNodes() {
        throw new UnsupportedOperationException();
    }

    public Node insertBefore(Node newChild, Node refChild) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public void normalize() {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(Node oldChild) {
        throw new UnsupportedOperationException();
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        throw new UnsupportedOperationException();
    }

    public void setNodeValue(String nodeValue) {
        throw new UnsupportedOperationException();
    }

    public void setPrefix(String prefix) {
        throw new UnsupportedOperationException();
    }

    public void setTextContent(String textContent) {
        throw new UnsupportedOperationException();
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }

    protected class NodeListImpl
    implements NodeList {
        protected NodeListImpl() {
        }

        public int getLength() {
            return 1;
        }

        public Node item(int i) {
            if (i != 0) {
                return null;
            }
            return SOAPPartImpl.this._envelope;
        }
    }
}

