/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.vfs.WriteStream;
import com.caucho.xml.stream.NamespaceBinding;
import com.caucho.xml.stream.NamespaceContextImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class NamespaceWriterContext
extends NamespaceContextImpl {
    private final LinkedHashMap<String, NamespaceBinding> _bindings = new LinkedHashMap();
    private ArrayList<NamespaceBinding> _duplicatePrefixes = new ArrayList();
    private int _uniqueId = 0;
    private NamespaceBinding _nullBinding = new NamespaceBinding(null, null, 0);
    private boolean _repair = false;

    public NamespaceWriterContext() {
        this(false);
    }

    public NamespaceWriterContext(boolean repair) {
        this._repair = repair;
    }

    protected void remove(String prefix, String uri) {
        this._bindings.remove(uri);
    }

    public boolean getRepair() {
        return this._repair;
    }

    public void setRepair(boolean repair) {
        this._repair = repair;
    }

    public void declare(String prefix, String uri) {
        this.declare(prefix, uri, false);
    }

    public void declare(String prefix, String uri, boolean forceEmit) {
        NamespaceBinding binding;
        if (uri == null) {
            binding = this._nullBinding;
        } else {
            binding = this._bindings.get(uri);
            if (binding != null && binding.getPrefix() != null && binding.getPrefix().equals(prefix)) {
                if (forceEmit) {
                    binding.setEmit(true);
                }
                return;
            }
            if (binding == null) {
                binding = new NamespaceBinding(prefix, null, this._version);
                this._bindings.put(uri, binding);
            }
        }
        NamespaceContextImpl.ElementBinding eltBinding = (NamespaceContextImpl.ElementBinding)this._stack.get(this._stack.size() - 1);
        if (eltBinding == null) {
            eltBinding = new NamespaceContextImpl.ElementBinding();
            this._stack.set(this._stack.size() - 1, eltBinding);
        }
        eltBinding.addOldBinding(binding, prefix, binding.getUri(), uri);
        if (binding.isEmit() && !prefix.equals(binding.getPrefix())) {
            NamespaceBinding copy = new NamespaceBinding(binding.getPrefix(), binding.getUri(), binding.getVersion());
            copy.setEmit(true);
            this._duplicatePrefixes.add(copy);
        }
        ++this._version;
        binding.setPrefix(prefix);
        binding.setUri(uri);
        binding.setVersion(this._version);
        binding.setEmit(forceEmit);
    }

    public String declare(String uri) {
        NamespaceBinding binding = this._bindings.get(uri);
        if (binding != null) {
            return binding.getPrefix();
        }
        String prefix = "ns" + this._uniqueId++;
        this.declare(prefix, uri, this._repair);
        return prefix;
    }

    public String getPrefix(String uri) {
        NamespaceBinding binding = this._bindings.get(uri);
        if (binding == null) {
            return null;
        }
        return binding.getPrefix();
    }

    public String getNamespaceURI(String prefix) {
        for (NamespaceBinding binding : this._bindings.values()) {
            if (!prefix.equals(binding.getPrefix())) continue;
            return binding.getUri();
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (NamespaceBinding binding : this._bindings.values()) {
            if (!uri.equals(binding.getUri())) continue;
            prefixes.add(binding.getPrefix());
        }
        return prefixes.iterator();
    }

    public void emitDeclarations(WriteStream ws) throws IOException {
        for (NamespaceBinding binding : this._bindings.values()) {
            binding.emit(ws);
        }
        for (int i = 0; i < this._duplicatePrefixes.size(); ++i) {
            this._duplicatePrefixes.get(i).emit(ws);
        }
        this._duplicatePrefixes.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NamespaceWriterContext:\n");
        for (Map.Entry<String, NamespaceBinding> entry : this._bindings.entrySet()) {
            sb.append(entry.getKey() + "->" + entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

