/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.xml.stream.NamespaceContextImpl;
import com.caucho.xml.stream.events.AttributeImpl;
import com.caucho.xml.stream.events.NamespaceImpl;
import com.caucho.xml.stream.events.StartDocumentImpl;
import com.caucho.xml.stream.events.StartElementImpl;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    private static final XMLEventFactory EVENT_FACTORY = XMLEventFactory.newInstance();

    public XMLEvent allocate(XMLStreamReader reader) throws XMLStreamException {
        switch (reader.getEventType()) {
            case 10: {
                break;
            }
            case 12: {
                return EVENT_FACTORY.createCData(reader.getText());
            }
            case 4: {
                return EVENT_FACTORY.createCharacters(reader.getText());
            }
            case 5: {
                return EVENT_FACTORY.createComment(reader.getText());
            }
            case 11: {
                break;
            }
            case 8: {
                return EVENT_FACTORY.createEndDocument();
            }
            case 2: {
                return EVENT_FACTORY.createEndElement(reader.getName(), null);
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                return EVENT_FACTORY.createProcessingInstruction(reader.getPITarget(), reader.getPIData());
            }
            case 6: {
                NamespaceContextImpl context = (NamespaceContextImpl)reader.getNamespaceContext();
                if (context.getDepth() == 0) {
                    return EVENT_FACTORY.createIgnorableSpace(reader.getText());
                }
                return EVENT_FACTORY.createSpace(reader.getText());
            }
            case 7: {
                boolean encodingSet = true;
                String encoding = reader.getCharacterEncodingScheme();
                if (encoding == null) {
                    encoding = "utf-8";
                    encodingSet = false;
                }
                return new StartDocumentImpl(encodingSet, encoding, null, reader.getVersion(), reader.isStandalone(), reader.standaloneSet());
            }
            case 1: {
                HashMap<QName, Attribute> attributes = new HashMap<QName, Attribute>();
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    AttributeImpl attribute = new AttributeImpl(reader.getAttributeName(i), reader.getAttributeValue(i));
                    attributes.put(reader.getAttributeName(i), attribute);
                }
                HashMap<String, Namespace> namespaces = new HashMap<String, Namespace>();
                for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                    String prefix = reader.getNamespacePrefix(i);
                    if (prefix == null) {
                        prefix = "";
                    }
                    NamespaceImpl namespace = new NamespaceImpl(reader.getNamespaceURI(i), prefix);
                    namespaces.put(prefix, namespace);
                }
                return new StartElementImpl(reader.getName(), attributes, namespaces, reader.getNamespaceContext());
            }
        }
        throw new XMLStreamException("Event type = " + reader.getEventType());
    }

    public void allocate(XMLStreamReader reader, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.allocate(reader));
    }

    public XMLEventAllocator newInstance() {
        return new XMLEventAllocatorImpl();
    }
}

