/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.stream.Escapifier;
import com.caucho.xml.stream.NamespaceWriterContext;
import com.caucho.xml.stream.PropertyNotSupportedException;
import com.caucho.xml.stream.XMLStreamReaderImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamWriterImpl
implements XMLStreamWriter {
    private static final L10N L = new L10N(XMLStreamWriterImpl.class);
    private static final Logger log = Logger.getLogger(XMLStreamReaderImpl.class.getName());
    private WriteStream _out;
    private NamespaceWriterContext _tracker;
    private QName _pendingTagName = null;
    private boolean _shortTag = false;
    private boolean _repair = false;
    private ArrayList<QName> _pendingAttributeNames = new ArrayList();
    private ArrayList<String> _pendingAttributeValues = new ArrayList();
    private int _indent = -1;
    private int _currentIndent;
    private boolean _flushed = true;

    public XMLStreamWriterImpl(WriteStream ws) {
        this(ws, false);
    }

    public XMLStreamWriterImpl(WriteStream ws, boolean repair) {
        this._out = ws;
        this._repair = repair;
        this._tracker = new NamespaceWriterContext(repair);
    }

    public XMLStreamWriterImpl(Writer w, boolean repair) {
        this(Vfs.openWrite(w), repair);
    }

    public XMLStreamWriterImpl(OutputStream os, boolean repair) {
        this(Vfs.openWrite(os), repair);
    }

    public void setIndent(int indent) {
        this._indent = indent;
    }

    public void setRepair(boolean repair) {
        this._repair = repair;
        this._tracker.setRepair(repair);
    }

    public void close() throws XMLStreamException {
        this.flushPending();
        this.flush();
    }

    public void flush() throws XMLStreamException {
        try {
            this._out.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return this._tracker;
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this._tracker.getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            return this._repair;
        }
        throw new PropertyNotSupportedException(name);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this._tracker.declare("", uri, this._repair);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        String message = "please do not set the NamespaceContext";
        throw new UnsupportedOperationException(message);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this._tracker.declare(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this._pendingAttributeNames.add(new QName(localName));
        this._pendingAttributeValues.add(value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this._repair) {
            String prefix = this._tracker.declare(namespaceURI);
            if (prefix == null) {
                this._pendingAttributeNames.add(new QName(namespaceURI, localName));
            } else {
                this._pendingAttributeNames.add(new QName(namespaceURI, localName, prefix));
            }
        } else {
            String prefix = this._tracker.getPrefix(namespaceURI);
            if (prefix == null) {
                throw new XMLStreamException(L.l("No prefix defined for namespace {0}", (Object)namespaceURI));
            }
            this._pendingAttributeNames.add(new QName(namespaceURI, localName, prefix));
        }
        this._pendingAttributeValues.add(value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this._repair && this._tracker.getPrefix(namespaceURI) == null) {
            this._tracker.declare(prefix, namespaceURI, true);
        } else {
            this._tracker.declare(prefix, namespaceURI);
        }
        this._pendingAttributeNames.add(new QName(namespaceURI, localName, prefix));
        this._pendingAttributeValues.add(value);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.flushPending();
        try {
            this._out.print("<![CDATA[");
            this._out.print(data);
            this._out.print("]]>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.flushPending();
        try {
            Escapifier.escape(text, start, len, this._out);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.flushPending();
        try {
            Escapifier.escape(text, this._out);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeComment(String data) throws XMLStreamException {
        this.flushPending();
        try {
            this._out.print("<!--");
            this._out.print(data);
            this._out.print("-->");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this._tracker.declare("", namespaceURI, true);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.flushPending();
        try {
            this._out.print(dtd);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeElement(String localName, String contents) throws XMLStreamException {
        this.writeStartElement(localName);
        if (contents != null) {
            this.writeCharacters(contents);
        }
        this.writeEndElement();
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.flushPending();
        try {
            QName qname = new QName(localName);
            this.pushContext(qname);
            this._pendingTagName = qname;
            this._shortTag = true;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.flushPending();
        try {
            QName qname = null;
            if (this._repair) {
                this.flushContext();
                this._tracker.push();
                String prefix = this._tracker.declare(namespaceURI);
                qname = prefix == null ? new QName(namespaceURI, localName) : new QName(namespaceURI, localName, prefix);
                this._tracker.setElementName(qname);
                this._flushed = false;
            } else {
                String prefix = this._tracker.getPrefix(namespaceURI);
                if (prefix == null) {
                    throw new XMLStreamException(L.l("No prefix defined for namespace {0}", (Object)namespaceURI));
                }
                qname = new QName(namespaceURI, localName, prefix);
                this.pushContext(qname);
            }
            this._pendingTagName = qname;
            this._shortTag = true;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.flushPending();
        try {
            QName qname = new QName(namespaceURI, localName, prefix);
            if (this._repair && this._tracker.getPrefix(namespaceURI) == null) {
                this.flushContext();
                this._tracker.push();
                this._tracker.declare(prefix, namespaceURI, true);
                this._tracker.setElementName(qname);
                this._flushed = false;
            } else {
                this.pushContext(qname);
            }
            this._pendingTagName = qname;
            this._shortTag = true;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    public void writeEndElement() throws XMLStreamException {
        this.writeEndElement(null, null);
    }

    public void writeEndElement(String localName) throws XMLStreamException {
        this.writeEndElement(null, localName);
    }

    public void writeEndElement(String namespaceURI, String localName) throws XMLStreamException {
        this.flushPending();
        try {
            QName name = this.popContext();
            if (localName != null && !localName.equals(name.getLocalPart()) || namespaceURI != null && !namespaceURI.equals(name.getNamespaceURI())) {
                throw new XMLStreamException(L.l("unbalanced close, expecting `{0}' not `{1}'", (Object)name, (Object)new QName(namespaceURI, localName)));
            }
            this._out.print("</");
            this._out.print(XMLStreamWriterImpl.printQName(name));
            this._out.print(">");
            if (this._indent >= 0) {
                this._out.println();
                this._currentIndent -= this._indent;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private static String printQName(QName name) {
        if (name.getPrefix() == null || name.getPrefix().equals("")) {
            return name.getLocalPart();
        }
        return name.getPrefix() + ":" + name.getLocalPart();
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.flushPending();
        try {
            this._out.print("&");
            this._out.print(name);
            this._out.print(";");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this._pendingTagName == null) {
            throw new XMLStreamException("Namespace written before element");
        }
        if (prefix == null || "".equals(prefix) || "xmlns".equals(prefix)) {
            this.writeDefaultNamespace(namespaceURI);
        } else {
            this._tracker.declare(prefix, namespaceURI, true);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.flushPending();
        try {
            this._out.print("<?");
            this._out.print(target);
            this._out.print("?>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.flushPending();
        try {
            this._out.print("<?");
            this._out.print(target);
            this._out.print(" ");
            this._out.print(data);
            this._out.print("?>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("1.0");
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument("utf-8", version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        try {
            this._out.print("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"?>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.flushPending();
        try {
            QName qname = new QName(localName);
            this.pushContext(qname);
            this._pendingTagName = qname;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.flushPending();
        try {
            QName qname = null;
            if (this._repair) {
                this.flushContext();
                this._tracker.push();
                String prefix = this._tracker.declare(namespaceURI);
                qname = prefix == null ? new QName(namespaceURI, localName) : new QName(namespaceURI, localName, prefix);
                this._tracker.setElementName(qname);
                this._flushed = false;
            } else {
                String prefix = this._tracker.getPrefix(namespaceURI);
                if (prefix == null) {
                    throw new XMLStreamException(L.l("No prefix defined for namespace {0}", (Object)namespaceURI));
                }
                qname = new QName(namespaceURI, localName, prefix);
                this.pushContext(qname);
            }
            this._pendingTagName = qname;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.flushPending();
        try {
            QName qname = new QName(namespaceURI, localName, prefix);
            if (this._repair && this._tracker.getPrefix(namespaceURI) == null) {
                this.flushContext();
                this._tracker.push();
                this._tracker.declare(prefix, namespaceURI, true);
                this._tracker.setElementName(qname);
                this._flushed = false;
            } else {
                this.pushContext(qname);
            }
            this._pendingTagName = qname;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void pushContext(QName elementName) throws IOException {
        this.flushContext();
        this._tracker.push();
        this._tracker.setElementName(elementName);
        this._flushed = false;
    }

    private QName popContext() throws IOException, XMLStreamException {
        this.flushContext();
        QName name = this._tracker.getElementName();
        this._tracker.pop();
        return name;
    }

    private void flushContext() throws IOException {
        if (this._flushed) {
            return;
        }
        this._tracker.emitDeclarations(this._out);
        this._flushed = true;
    }

    private void flushPending() throws XMLStreamException {
        try {
            if (this._pendingTagName == null) {
                return;
            }
            this._out.print("<");
            this._out.print(XMLStreamWriterImpl.printQName(this._pendingTagName));
            for (int i = 0; i < this._pendingAttributeNames.size(); ++i) {
                this._out.print(" ");
                this._out.print(XMLStreamWriterImpl.printQName(this._pendingAttributeNames.get(i)));
                this._out.print("=\"");
                Escapifier.escape(this._pendingAttributeValues.get(i), this._out);
                this._out.print('\"');
            }
            this.flushContext();
            if (this._shortTag) {
                this._out.print("/>");
                this.popContext();
            } else {
                this._out.print(">");
                if (this._indent > -1) {
                    this._currentIndent += this._indent;
                }
            }
            this._pendingTagName = null;
            this._pendingAttributeNames.clear();
            this._pendingAttributeValues.clear();
            this._shortTag = false;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }
}

