/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.IntMap;
import com.caucho.xml2.Entities;
import com.caucho.xml2.XmlPrinter;
import java.io.IOException;

class HtmlEntities
extends Entities {
    private static HtmlEntities _html40;
    private static HtmlEntities _html32;
    protected char[][] _latin1;
    protected char[][] _attrLatin1;
    protected char[][] _sparseEntity = new char[8192][];
    protected char[] _sparseChar = new char[8192];
    protected IntMap _entityToChar = new IntMap();

    static Entities create(double version) {
        if (version == 0.0 || version >= 4.0) {
            if (_html40 == null) {
                _html40 = new HtmlEntities(4.0);
            }
            return _html40;
        }
        if (_html32 == null) {
            _html32 = new HtmlEntities(3.2);
        }
        return _html32;
    }

    protected HtmlEntities(double version) {
        int i;
        this.initLatin1();
        if (version >= 4.0) {
            this.initSymbol();
            this.initSpecial();
        }
        this._latin1 = new char[256][];
        for (i = 0; i < 32; ++i) {
            this._latin1[i] = ("&#" + i + ";").toCharArray();
        }
        this._latin1[9] = "\t".toCharArray();
        this._latin1[10] = "\n".toCharArray();
        this._latin1[13] = "\r".toCharArray();
        for (i = 32; i < 127; ++i) {
            this._latin1[i] = ("" + (char)i).toCharArray();
        }
        this._latin1[60] = "&lt;".toCharArray();
        this._latin1[62] = "&gt;".toCharArray();
        this._latin1[38] = "&amp;".toCharArray();
        for (i = 127; i < 256; ++i) {
            char[] value = this.getSparseEntity(i);
            this._latin1[i] = value != null ? value : ("&#" + i + ";").toCharArray();
        }
        this._attrLatin1 = new char[256][];
        for (i = 0; i < this._latin1.length; ++i) {
            this._attrLatin1[i] = this._latin1[i];
        }
        this._attrLatin1[60] = "<".toCharArray();
        this._attrLatin1[62] = ">".toCharArray();
        this._attrLatin1[34] = "&quot;".toCharArray();
        this._attrLatin1[10] = "&#10;".toCharArray();
        this._attrLatin1[13] = "&#13;".toCharArray();
    }

    int getEntity(String entity) {
        return this._entityToChar.get((Object)entity);
    }

    void printText(XmlPrinter os, char[] text, int offset, int length, boolean attr) throws IOException {
        for (int i = 0; i < length; ++i) {
            char ch = text[offset + i];
            if (ch == '&') {
                if (i + 1 < length && text[offset + i + 1] == '{') {
                    os.print('&');
                    continue;
                }
                if (attr) {
                    os.print(this._attrLatin1[ch]);
                    continue;
                }
                os.print(this._latin1[ch]);
                continue;
            }
            if (ch < '\u0100') {
                if (attr) {
                    os.print(this._attrLatin1[ch]);
                    continue;
                }
                os.print(this._latin1[ch]);
                continue;
            }
            char[] value = this.getSparseEntity(ch);
            if (value != null) {
                os.print(value);
                continue;
            }
            os.print("&#");
            os.print((int)ch);
            os.print(";");
        }
    }

    private void initLatin1() {
        this.entity("nbsp", 160);
        this.entity("iexcl", 161);
        this.entity("cent", 162);
        this.entity("pound", 163);
        this.entity("curren", 164);
        this.entity("yen", 165);
        this.entity("brvbar", 166);
        this.entity("sect", 167);
        this.entity("uml", 168);
        this.entity("copy", 169);
        this.entity("ordf", 170);
        this.entity("laquo", 171);
        this.entity("not", 172);
        this.entity("shy", 173);
        this.entity("reg", 174);
        this.entity("macr", 175);
        this.entity("deg", 176);
        this.entity("plusmn", 177);
        this.entity("sup2", 178);
        this.entity("sup3", 179);
        this.entity("acute", 180);
        this.entity("micro", 181);
        this.entity("para", 182);
        this.entity("middot", 183);
        this.entity("cedil", 184);
        this.entity("sup1", 185);
        this.entity("ordm", 186);
        this.entity("raquo", 187);
        this.entity("frac14", 188);
        this.entity("frac12", 189);
        this.entity("frac34", 190);
        this.entity("iquest", 191);
        this.entity("Agrave", 192);
        this.entity("Aacute", 193);
        this.entity("Acirc", 194);
        this.entity("Atilde", 195);
        this.entity("Auml", 196);
        this.entity("Aring", 197);
        this.entity("AElig", 198);
        this.entity("Ccedil", 199);
        this.entity("Egrave", 200);
        this.entity("Eacute", 201);
        this.entity("Ecirc", 202);
        this.entity("Euml", 203);
        this.entity("Igrave", 204);
        this.entity("Iacute", 205);
        this.entity("Icirc", 206);
        this.entity("Iuml", 207);
        this.entity("ETH", 208);
        this.entity("Ntilde", 209);
        this.entity("Ograve", 210);
        this.entity("Oacute", 211);
        this.entity("Ocirc", 212);
        this.entity("Otilde", 213);
        this.entity("Ouml", 214);
        this.entity("times", 215);
        this.entity("Oslash", 216);
        this.entity("Ugrave", 217);
        this.entity("Uacute", 218);
        this.entity("Ucirc", 219);
        this.entity("Uuml", 220);
        this.entity("Yacute", 221);
        this.entity("THORN", 222);
        this.entity("szlig", 223);
        this.entity("agrave", 224);
        this.entity("aacute", 225);
        this.entity("acirc", 226);
        this.entity("atilde", 227);
        this.entity("auml", 228);
        this.entity("aring", 229);
        this.entity("aelig", 230);
        this.entity("ccedil", 231);
        this.entity("egrave", 232);
        this.entity("eacute", 233);
        this.entity("ecirc", 234);
        this.entity("euml", 235);
        this.entity("igrave", 236);
        this.entity("iacute", 237);
        this.entity("icirc", 238);
        this.entity("iuml", 239);
        this.entity("eth", 240);
        this.entity("ntilde", 241);
        this.entity("ograve", 242);
        this.entity("oacute", 243);
        this.entity("ocirc", 244);
        this.entity("otilde", 245);
        this.entity("ouml", 246);
        this.entity("divide", 247);
        this.entity("oslash", 248);
        this.entity("ugrave", 249);
        this.entity("uacute", 250);
        this.entity("ucirc", 251);
        this.entity("uuml", 252);
        this.entity("yacute", 253);
        this.entity("thorn", 254);
        this.entity("yuml", 255);
    }

    private void initSymbol() {
        this.entity("fnof", 402);
        this.entity("Alpha", 913);
        this.entity("Beta", 914);
        this.entity("Gamma", 915);
        this.entity("Delta", 916);
        this.entity("Epsilon", 917);
        this.entity("Zeta", 918);
        this.entity("Eta", 919);
        this.entity("Theta", 920);
        this.entity("Iota", 921);
        this.entity("Kappa", 922);
        this.entity("Lambda", 923);
        this.entity("Mu", 924);
        this.entity("Nu", 925);
        this.entity("Xi", 926);
        this.entity("Omicron", 927);
        this.entity("Pi", 928);
        this.entity("Rho", 929);
        this.entity("Sigma", 931);
        this.entity("Tau", 932);
        this.entity("Upsilon", 933);
        this.entity("Phi", 934);
        this.entity("Chi", 935);
        this.entity("Psi", 936);
        this.entity("Omega", 937);
        this.entity("alpha", 945);
        this.entity("beta", 946);
        this.entity("gamma", 947);
        this.entity("delta", 948);
        this.entity("epsilon", 949);
        this.entity("zeta", 950);
        this.entity("eta", 951);
        this.entity("theta", 952);
        this.entity("iota", 953);
        this.entity("kappa", 954);
        this.entity("lambda", 955);
        this.entity("mu", 956);
        this.entity("nu", 957);
        this.entity("xi", 958);
        this.entity("omicron", 959);
        this.entity("pi", 960);
        this.entity("rho", 961);
        this.entity("sigmaf", 962);
        this.entity("sigma", 963);
        this.entity("tau", 964);
        this.entity("upsilon", 965);
        this.entity("phi", 966);
        this.entity("chi", 967);
        this.entity("psi", 968);
        this.entity("omega", 969);
        this.entity("thetasym", 977);
        this.entity("upsih", 978);
        this.entity("piv", 982);
        this.entity("bull", 8226);
        this.entity("hellip", 8230);
        this.entity("prime", 8242);
        this.entity("Prime", 8243);
        this.entity("oline", 8254);
        this.entity("frasl", 8260);
        this.entity("weirp", 8472);
        this.entity("image", 8465);
        this.entity("real", 8476);
        this.entity("trade", 8482);
        this.entity("alefsym", 8501);
        this.entity("larr", 8592);
        this.entity("uarr", 8593);
        this.entity("rarr", 8594);
        this.entity("darr", 8595);
        this.entity("harr", 8596);
        this.entity("crarr", 8629);
        this.entity("lArr", 8656);
        this.entity("uArr", 8657);
        this.entity("rArr", 8658);
        this.entity("dArr", 8659);
        this.entity("hArr", 8660);
        this.entity("forall", 8704);
        this.entity("part", 8706);
        this.entity("exist", 8707);
        this.entity("empty", 8709);
        this.entity("nabla", 8711);
        this.entity("isin", 8712);
        this.entity("ni", 8715);
        this.entity("prod", 8719);
        this.entity("sum", 8721);
        this.entity("minus", 8722);
        this.entity("lowas", 8727);
        this.entity("radic", 8730);
        this.entity("prop", 8733);
        this.entity("infin", 8734);
        this.entity("ang", 8736);
        this.entity("and", 8743);
        this.entity("or", 8744);
        this.entity("cap", 8745);
        this.entity("cup", 8746);
        this.entity("int", 8747);
        this.entity("there4", 8756);
        this.entity("sim", 8764);
        this.entity("cong", 8773);
        this.entity("asymp", 8776);
        this.entity("ne", 8800);
        this.entity("equiv", 8801);
        this.entity("le", 8804);
        this.entity("ge", 8805);
        this.entity("sub", 8834);
        this.entity("sup", 8835);
        this.entity("nsub", 8836);
        this.entity("sube", 8838);
        this.entity("supe", 8839);
        this.entity("oplus", 8853);
        this.entity("otimes", 8855);
        this.entity("perp", 8869);
        this.entity("sdot", 8901);
        this.entity("lceil", 8968);
        this.entity("rceil", 8969);
        this.entity("lfloor", 8970);
        this.entity("rfloor", 8971);
        this.entity("lang", 9001);
        this.entity("rang", 9002);
        this.entity("loz", 9674);
        this.entity("spades", 9824);
        this.entity("clubs", 9827);
        this.entity("hearts", 9829);
        this.entity("diams", 9830);
    }

    private void initSpecial() {
        this.entity("quot", 34);
        this.entity("amp", 38);
        this.entity("lt", 60);
        this.entity("gt", 62);
        this.entity("apos", 39);
        this.entity("OElig", 338);
        this.entity("oelig", 339);
        this.entity("Scaron", 352);
        this.entity("scaron", 353);
        this.entity("Yuml", 376);
        this.entity("circ", 710);
        this.entity("tilde", 732);
        this.entity("ensp", 8194);
        this.entity("emsp", 8195);
        this.entity("thinsp", 8201);
        this.entity("zwnj", 8204);
        this.entity("zwj", 8205);
        this.entity("lrm", 8206);
        this.entity("rlm", 8207);
        this.entity("ndash", 8211);
        this.entity("mdash", 8212);
        this.entity("lsquo", 8216);
        this.entity("rsquo", 8217);
        this.entity("sbquo", 8218);
        this.entity("ldquo", 8220);
        this.entity("rdquo", 8221);
        this.entity("bdquo", 8222);
        this.entity("dagger", 8224);
        this.entity("Dagger", 8225);
        this.entity("permil", 8240);
        this.entity("lsaquo", 8249);
        this.entity("rsaquo", 8250);
        this.entity("euro", 8364);
    }

    protected char[] getSparseEntity(int ch) {
        int size = this._sparseChar.length;
        int i = ch * 65521 % size;
        if (i < 0) {
            i = -i;
        }
        while (this._sparseChar[i] != ch && this._sparseEntity[i] != null) {
            i = (i + 1) % size;
        }
        return this._sparseEntity[i];
    }

    private void entity(String name, int ch) {
        this._entityToChar.put((Object)name, ch);
        int size = this._sparseChar.length;
        int i = ch * 65521 % size;
        if (i < 0) {
            i = -i;
        }
        while (this._sparseChar[i] != ch && this._sparseEntity[i] != null) {
            i = (i + 1) % size;
        }
        this._sparseChar[i] = (char)ch;
        this._sparseEntity[i] = ("&" + name + ";").toCharArray();
    }
}

