/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.LruCache;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.Pattern;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathParseException;
import com.caucho.xpath.XPathParser;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromContext;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class XPath {
    private static final Logger log = Log.open(XPath.class);
    private static EnvironmentLocal<LruCache<String, Pattern>> _matchCache = new EnvironmentLocal();
    private static EnvironmentLocal<LruCache<String, Pattern>> _selectCache = new EnvironmentLocal();
    private static EnvironmentLocal<LruCache<String, Expr>> _exprCache = new EnvironmentLocal();

    private XPath() {
    }

    public static Node find(String query, Node node) throws XPathException {
        Pattern pattern = XPath.parseSelect(query);
        return pattern.find(node);
    }

    public static Iterator select(String query, Node node) throws XPathException {
        Pattern pattern = XPath.parseSelect(query);
        return pattern.select(node);
    }

    public static Pattern parseSelect(String query) throws XPathParseException {
        Pattern pattern;
        LruCache cache = _selectCache.get();
        if (cache == null) {
            cache = new LruCache(128);
        }
        if ((pattern = (Pattern)cache.get((Object)query)) == null) {
            pattern = XPath.parseSelect(query, null);
            cache.put((Object)query, (Object)pattern);
        }
        return pattern;
    }

    public static Pattern parseSelect(String query, NamespaceContext namespace) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        AbstractPattern pattern = parser.parseSelect();
        if (log.isLoggable(Level.FINER)) {
            log.finest("select: " + pattern);
        }
        return new Pattern(pattern);
    }

    public static Pattern parseMatch(String query) throws XPathParseException {
        Pattern pattern;
        LruCache cache = _matchCache.get();
        if (cache == null) {
            cache = new LruCache(128);
        }
        if ((pattern = (Pattern)cache.get((Object)query)) == null) {
            pattern = XPath.parseMatch(query, null);
            cache.put((Object)query, (Object)pattern);
        }
        return pattern;
    }

    public static Pattern parseMatch(String query, NamespaceContext namespace) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        AbstractPattern pattern = parser.parseMatch();
        if (log.isLoggable(Level.FINER)) {
            log.finest("match: " + pattern);
        }
        return new Pattern(pattern);
    }

    public static String evalString(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalString(node);
    }

    public static double evalNumber(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalNumber(node);
    }

    public static boolean evalBoolean(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalBoolean(node);
    }

    public static Object evalObject(String query, Node node) throws XPathException {
        Expr expr = XPath.parseExpr(query);
        return expr.evalObject(node);
    }

    public static Expr parseExpr(String query) throws XPathParseException {
        Expr expr;
        LruCache cache = _exprCache.get();
        if (cache == null) {
            cache = new LruCache(128);
        }
        if ((expr = (Expr)cache.get((Object)query)) == null) {
            expr = XPath.parseExpr(query, null);
            cache.put((Object)query, (Object)expr);
        }
        return expr;
    }

    public static Expr parseExpr(String query, NamespaceContext namespace) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        Expr expr = parser.parseExpr();
        if (log.isLoggable(Level.FINER)) {
            log.finest("expr: " + expr);
        }
        return expr;
    }

    public static Expr parseExpr(String query, NamespaceContext namespace, AbstractPattern nodeList) throws XPathParseException {
        XPathParser parser = new XPathParser(query, namespace);
        Expr expr = parser.parseExpr(new FromContext(), nodeList);
        if (expr != null) {
            expr.setListContext(nodeList);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finest("expr: " + expr);
        }
        return expr;
    }

    public static Env createEnv() {
        return Env.create();
    }

    public static Env createEnv(Env global) {
        Env env = Env.create();
        env.init(global);
        return env;
    }

    public static Env createCall(Env parent) {
        Env env = Env.create();
        env.initMacro(parent);
        return env;
    }

    public static void freeEnv(Env env) {
    }
}

