/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromAttributes;
import com.caucho.xpath.pattern.FromSelf;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xpath.pattern.SingleNodeIterator;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectExpr
extends Expr {
    private int _code;
    private String _name;
    private Expr _left;
    private Expr _right;
    private Expr _third;

    public ObjectExpr(int code, ArrayList args) {
        this._code = code;
        if (args != null && args.size() > 0) {
            this._left = (Expr)args.get(0);
        }
        if (args != null && args.size() > 1) {
            this._right = (Expr)args.get(1);
        }
        if (args != null && args.size() > 2) {
            this._third = (Expr)args.get(2);
        }
        if (this._right == null || this._third == null) {
            throw new NullPointerException();
        }
    }

    public ObjectExpr(int code, String name) {
        this._code = code;
        this._name = name;
    }

    public boolean isNodeSet() {
        return this._code == 59;
    }

    public boolean isString() {
        return this._code == 61;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 58: {
                if (this._left.evalBoolean(node, env)) {
                    return this._right.evalBoolean(node, env);
                }
                return this._third.evalBoolean(node, env);
            }
            case 61: {
                if (node instanceof Element) {
                    return !((Element)node).getAttribute(this._name).equals("");
                }
                return false;
            }
            case 59: {
                return true;
            }
        }
        return ObjectExpr.toBoolean(this.evalObject(node, env));
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 58: {
                if (this._left.evalBoolean(node, env)) {
                    return this._right.evalNumber(node, env);
                }
                return this._third.evalNumber(node, env);
            }
            case 61: {
                if (node instanceof Element) {
                    return ObjectExpr.toDouble(((Element)node).getAttribute(this._name));
                }
                return Double.NaN;
            }
            case 59: {
                return ObjectExpr.toDouble(XmlUtil.textValue(node));
            }
        }
        return ObjectExpr.toDouble(this.evalObject(node, env));
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 58: {
                if (this._left.evalBoolean(node, env)) {
                    return this._right.evalString(node, env);
                }
                return this._third.evalString(node, env);
            }
            case 61: {
                if (node instanceof Element) {
                    return ((Element)node).getAttribute(this._name);
                }
                return "";
            }
            case 59: {
                return XmlUtil.textValue(node);
            }
        }
        return ObjectExpr.toString(this.evalObject(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 58: {
                if (this._left.evalBoolean(node, env)) {
                    return this._right.evalObject(node, env);
                }
                return this._third.evalObject(node, env);
            }
            case 59: {
                return node;
            }
            case 61: {
                if (node instanceof Element) {
                    return ((Element)node).getAttributeNode(this._name);
                }
                return null;
            }
        }
        return null;
    }

    public NodeIterator evalNodeSet(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 58: {
                if (this._left.evalBoolean(node, env)) {
                    return this._right.evalNodeSet(node, env);
                }
                return this._third.evalNodeSet(node, env);
            }
            case 59: {
                return new SingleNodeIterator(env, node);
            }
            case 61: {
                if (node instanceof Element) {
                    return new SingleNodeIterator(env, ((Element)node).getAttributeNode(this._name));
                }
                return new SingleNodeIterator(env, null);
            }
        }
        return null;
    }

    protected AbstractPattern toNodeList() {
        switch (this._code) {
            case 59: {
                return NodeTypePattern.create(new FromSelf(null), -1);
            }
            case 61: {
                return new NodePattern(new FromAttributes(null), this._name, 2);
            }
        }
        return super.toNodeList();
    }

    public String toString() {
        switch (this._code) {
            case 58: {
                return "if(" + this._left + "," + this._right + "," + this._third + ")";
            }
            case 59: {
                return ".";
            }
            case 61: {
                return "@" + this._name;
            }
        }
        return super.toString();
    }
}

