/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.functions;

import com.caucho.util.L10N;
import com.caucho.xml.QAbstractNode;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathParseException;
import com.caucho.xpath.expr.AbstractStringExpr;
import org.w3c.dom.Node;

public class ResolveURI
extends AbstractStringExpr {
    private static final L10N L = new L10N(ResolveURI.class);
    private Expr _relExpr;
    private Expr _baseExpr;

    public ResolveURI(Expr relExpr, Expr baseExpr) throws XPathParseException {
        this._relExpr = relExpr;
        this._baseExpr = baseExpr;
        if (relExpr == null) {
            throw new XPathParseException(L.l("fn:resolve-uri(relative,[base])"));
        }
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        String rel = this._relExpr.evalString(node, env);
        if (rel.startsWith("/") || rel.indexOf(58) > 0 && rel.indexOf(58) < 47) {
            return rel;
        }
        String base = this._baseExpr != null ? this._baseExpr.evalString(node, env) : QAbstractNode.baseURI(node);
        int last = base.lastIndexOf(47);
        if (last < 0) {
            return rel;
        }
        return base.substring(0, last + 1) + rel;
    }

    public String toString() {
        if (this._baseExpr != null) {
            return "fn:resolve-uri(" + this._relExpr + "," + this._baseExpr + ")";
        }
        return "fn:resolve-uri(" + this._relExpr + ")";
    }
}

