/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.log.Log;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.MergeIterator;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.UniqueIterator;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public abstract class AbstractPattern {
    protected static final Logger log = Log.open(AbstractPattern.class);
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    protected AbstractPattern _parent;
    protected AbstractPattern _child;

    AbstractPattern(AbstractPattern parent) {
        this._parent = parent;
        if (parent != null && parent._child == null) {
            parent._child = this;
        }
    }

    public AbstractPattern getParent() {
        return this._parent;
    }

    public double getPriority() {
        return 0.5;
    }

    public String getNodeName() {
        return "*";
    }

    public NodeIterator select(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator base = this.createNodeIterator(node, env, this.copyPosition());
        if (this.isStrictlyAscending()) {
            return base;
        }
        return new MergeIterator(env, base);
    }

    public NodeIterator selectUnique(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator base = this.createNodeIterator(node, env, this.copyPosition());
        if (this.isUnique()) {
            return base;
        }
        return new UniqueIterator(env, base);
    }

    public Node findAny(Node node, ExprEnvironment env) throws XPathException {
        NodeIterator base = this.createNodeIterator(node, env, this.copyPosition());
        return base.nextNode();
    }

    public boolean isStrictlyAscending() {
        if (this._parent != null) {
            return this._parent.isStrictlyAscending();
        }
        return false;
    }

    public boolean isUnique() {
        if (this._parent != null) {
            return this._parent.isUnique();
        }
        return false;
    }

    boolean isSingleSelect() {
        if (this._parent != null) {
            return this._parent.isSingleSelect();
        }
        return false;
    }

    boolean isSingleLevel() {
        return this.isSingleSelect();
    }

    public NodeIterator createNodeIterator(Node node, ExprEnvironment env, AbstractPattern pattern) throws XPathException {
        if (this._parent == null) {
            throw new RuntimeException(String.valueOf(this) + " " + this.getClass());
        }
        return this._parent.createNodeIterator(node, env, pattern);
    }

    public Node firstNode(Node node, ExprEnvironment env) throws XPathException {
        throw new UnsupportedOperationException(String.valueOf(this) + " " + this.getClass());
    }

    public Node lastNode(Node node) {
        return null;
    }

    public Node nextNode(Node node, Node last) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public abstract boolean match(Node var1, ExprEnvironment var2) throws XPathException;

    public boolean isAscending() {
        return true;
    }

    public int position(Node node, Env env, AbstractPattern pattern) throws XPathException {
        return this._parent.position(node, env, pattern);
    }

    public int count(Node node, Env env, AbstractPattern pattern) throws XPathException {
        return this._parent.count(node, env, pattern);
    }

    public AbstractPattern copyAxis() {
        if (this._parent != null) {
            return this._parent.copyAxis();
        }
        return null;
    }

    public AbstractPattern copyPosition() {
        return this;
    }

    protected String getPrefix() {
        if (this._parent == null || this._parent instanceof FromAny) {
            return "";
        }
        if (this._parent instanceof FromContext) {
            FromContext context = (FromContext)this._parent;
            String name = "";
            for (int i = 0; i < context.getCount(); ++i) {
                name = name + "../";
            }
            return name;
        }
        if (this._parent instanceof FromRoot) {
            return "/";
        }
        return this._parent + "/";
    }

    public String toPatternString() {
        return this.toString();
    }
}

