/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromParent;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.FromSelf;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeTypePattern
extends AbstractPattern {
    public static final int NODE = -2;
    public static final int ANY = -1;
    private AbstractPattern _match;
    private int _nodeType;

    private NodeTypePattern(AbstractPattern parent, int nodeType) {
        super(parent);
        this._nodeType = nodeType;
    }

    public static AbstractPattern create(AbstractPattern parent, int nodeType) {
        if (nodeType == -2 && parent instanceof FromParent && parent._parent instanceof FromContext) {
            FromContext context = (FromContext)parent._parent;
            return new FromContext(context.getCount() + 1);
        }
        return new NodeTypePattern(parent, nodeType);
    }

    public double getPriority() {
        if (this._parent instanceof Axis && this._parent.getParent() != null && !(this._parent.getParent() instanceof FromRoot) && !(this._parent.getParent() instanceof FromAny)) {
            return 0.5;
        }
        return -0.5;
    }

    public String getNodeName() {
        switch (this._nodeType) {
            case 3: {
                return "#text";
            }
            case 9: {
                return "#document";
            }
            case 8: {
                return "#comment";
            }
        }
        return "*";
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public boolean isStrictlyAscending() {
        if (this._parent != null) {
            return this._parent.isStrictlyAscending();
        }
        return true;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (this._nodeType == 2) {
            if (node.getNodeType() != 2) {
                return false;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
                return false;
            }
        } else if (node.getNodeType() != this._nodeType && this._nodeType != -1 && (this._nodeType != -2 || node instanceof Document)) {
            return false;
        }
        return this._parent == null || this._parent.match(node, env);
    }

    public AbstractPattern copyPosition() {
        if (this._match == null) {
            AbstractPattern parent = null;
            if (this._parent != null) {
                parent = this._parent.copyPosition();
            }
            this._match = new NodeTypePattern(parent, this._nodeType);
        }
        return this._match;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NodeTypePattern)) {
            return false;
        }
        NodeTypePattern bPattern = (NodeTypePattern)b;
        return this._nodeType == bPattern._nodeType && (this._parent == bPattern._parent || this._parent != null && this._parent.equals(bPattern._parent));
    }

    public String toString() {
        String prefix = this._parent == null ? "" : (this._parent instanceof FromChildren ? this._parent.getPrefix() : this._parent.toString());
        switch (this._nodeType) {
            case -1: {
                if (!(this._parent instanceof FromSelf)) {
                    return prefix + "node()";
                }
                if (this._parent._parent == null) {
                    return ".";
                }
                return this._parent.getPrefix() + ".";
            }
            case -2: {
                return prefix + "node()";
            }
            case 7: {
                return prefix + "pi()";
            }
            case 2: {
                return prefix + "*";
            }
            case 1: {
                return prefix + "*";
            }
            case 8: {
                return prefix + "comment()";
            }
            case 3: {
                return prefix + "text()";
            }
            case 5: {
                return prefix + "er()";
            }
        }
        return super.toString();
    }
}

