/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.JavaCompiler;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.SimpleLoader;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Crc64Stream;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.QDocument;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlPrinter;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Expr;
import com.caucho.xpath.XPath;
import com.caucho.xsl.Generator;
import com.caucho.xsl.IdentityStylesheet;
import com.caucho.xsl.JavaGenerator;
import com.caucho.xsl.SAXFilterImpl;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TemplatesHandlerImpl;
import com.caucho.xsl.TransformerConfigurationExceptionWrapper;
import com.caucho.xsl.TransformerHandlerImpl;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XmlStylesheetReader;
import com.caucho.xsl.XslParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public abstract class AbstractStylesheetFactory
extends SAXTransformerFactory {
    static final Logger log = Log.open(AbstractStylesheetFactory.class);
    static final L10N L = new L10N(AbstractStylesheetFactory.class);
    private static EnvironmentLocal<LruCache<String, SoftReference<StylesheetImpl>>> _stylesheetCache = new EnvironmentLocal();
    private URIResolver _uriResolver;
    private ErrorListener _errorListener;
    private String _systemId;
    private Path _workPath;
    private Path _stylePath;
    private ClassLoader _loader;
    private String _className;
    private boolean _isAutoCompile = true;
    private boolean _loadPrecompiledStylesheet = true;

    protected AbstractStylesheetFactory() {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public void setAttribute(String name, Object value) {
    }

    public boolean getFeature(String name) {
        return name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature") || name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter") || name.equals("http://javax.xml.transform.dom.DOMResult/feature") || name.equals("http://javax.xml.transform.dom.DOMSource/feature") || name.equals("http://javax.xml.transform.sax.SAXResult/feature") || name.equals("http://javax.xml.transform.sax.SAXSource/feature") || name.equals("http://javax.xml.transform.stream.StreamResult/feature") || name.equals("http://javax.xml.transform.stream.StreamSource/feature");
    }

    public void setFeature(String name, boolean value) {
    }

    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this._uriResolver = uriResolver;
    }

    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this._errorListener = errorListener;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public void setStylePath(Path path) {
        this._stylePath = path;
    }

    public Path getStylePath() {
        if (this._stylePath != null) {
            return this._stylePath;
        }
        return this.getSearchPath();
    }

    public void setSearchPath(Path path) {
        this._stylePath = path;
    }

    public Path getSearchPath() {
        if (this._stylePath != null) {
            return this._stylePath;
        }
        return Vfs.getPwd();
    }

    public void setWorkPath(Path path) {
        this._workPath = path;
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return CauchoSystem.getWorkPath();
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public boolean getLoadPrecompiledStylesheet() {
        return this._loadPrecompiledStylesheet;
    }

    public void setLoadPrecompiledStylesheet(boolean preload) {
        this._loadPrecompiledStylesheet = preload;
    }

    public boolean isAutoCompile() {
        return this._isAutoCompile;
    }

    public void setAutoCompile(boolean autoCompile) {
        this._isAutoCompile = autoCompile;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        try {
            XmlStylesheetReader reader = new XmlStylesheetReader();
            this.parseSAX(source, reader);
            String href = reader.getAssociatedStylesheet(media, title, charset);
            if (href == null) {
                return null;
            }
            String base = source.getSystemId();
            return this.getSource(href, base);
        }
        catch (Exception e) {
            throw new TransformerConfigurationException(e);
        }
    }

    private Source getSource(String href, String base) throws Exception {
        Path subpath;
        if (href == null) {
            href = "";
        }
        if (base == null) {
            base = "/";
        }
        if (this._uriResolver != null) {
            subpath = href.startsWith("/") || base.equals("/") ? this.getSearchPath().lookup(href) : this.getSearchPath().lookup(base).getParent().lookup(href);
            Source source = this._uriResolver.resolve(href, base);
            if (source != null) {
                if (source.getSystemId() == null) {
                    source.setSystemId(subpath.getURL());
                }
                return source;
            }
        }
        if (href.startsWith("/") || base.equals("/")) {
            subpath = this.getSearchPath().lookup(href);
        } else {
            if (base.startsWith("file:")) {
                base = base.substring(5);
            }
            subpath = this.getSearchPath().lookup(base).getParent().lookup(href);
        }
        return new StreamSource(subpath.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSAX(Source source, ContentHandler handler) throws TransformerConfigurationException {
        block7: {
            try {
                if (source instanceof SAXSource) {
                    SAXSource saxSource = (SAXSource)source;
                    XMLReader reader = saxSource.getXMLReader();
                    InputSource inputSource = saxSource.getInputSource();
                    reader.setContentHandler(handler);
                    reader.parse(inputSource);
                    break block7;
                }
                if (source instanceof StreamSource) {
                    Xml parser = new Xml();
                    parser.setContentHandler(handler);
                    ReadStream rs = this.openPath(source);
                    try {
                        parser.parse((InputStream)rs);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    {
                        break block7;
                    }
                }
                if (source instanceof DOMSource) {
                    DOMSource domSource = (DOMSource)source;
                    Node node = domSource.getNode();
                    XmlUtil.toSAX(node, handler);
                }
            }
            catch (Exception e) {
                throw new TransformerConfigurationException(e);
            }
        }
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(new IdentityStylesheet());
    }

    public StylesheetImpl newStylesheet(Document xsl) throws Exception {
        return (StylesheetImpl)this.generate(xsl, null);
    }

    public StylesheetImpl newStylesheet(Reader reader) throws Exception {
        ReadStream rs = Vfs.openRead(reader);
        return (StylesheetImpl)this.generate(this.parseXSL(rs), rs.getPath());
    }

    public StylesheetImpl newStylesheet(InputStream is) throws Exception {
        ReadStream rs = Vfs.openRead(is);
        return (StylesheetImpl)this.generate(this.parseXSL(rs), rs.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StylesheetImpl newStylesheet(String systemId) throws Exception {
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(systemId, systemId);
        if (stylesheet != null) {
            return stylesheet;
        }
        Class<AbstractStylesheetFactory> clazz = AbstractStylesheetFactory.class;
        synchronized (AbstractStylesheetFactory.class) {
            StylesheetImpl stylesheetImpl;
            stylesheet = this.loadPrecompiledStylesheet(systemId, systemId);
            if (stylesheet != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return stylesheet;
            }
            ReadStream is = this._stylePath != null ? this._stylePath.lookup(systemId).openRead() : Vfs.lookup(systemId).openRead();
            try {
                stylesheetImpl = this.newStylesheet((InputStream)is);
                Object var7_6 = null;
                if (is == null) return stylesheetImpl;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return stylesheetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StylesheetImpl newStylesheet(Path path) throws Exception {
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(path.getFullPath(), path.getUserPath());
        if (stylesheet != null) {
            return stylesheet;
        }
        Class<AbstractStylesheetFactory> clazz = AbstractStylesheetFactory.class;
        synchronized (AbstractStylesheetFactory.class) {
            StylesheetImpl stylesheetImpl;
            stylesheet = this.loadPrecompiledStylesheet(path.getFullPath(), path.getUserPath());
            if (stylesheet != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return stylesheet;
            }
            Path oldStylePath = this._stylePath;
            if (this._stylePath == null) {
                this._stylePath = path.getParent();
            }
            ReadStream is = null;
            try {
                is = path.openRead();
                stylesheetImpl = this.newStylesheet((InputStream)is);
                Object var8_7 = null;
                this._stylePath = oldStylePath;
                if (is == null) return stylesheetImpl;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this._stylePath = oldStylePath;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return stylesheetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        String systemId = source.getSystemId();
        try {
            Templates templates;
            ReadStream rs;
            block11: {
                Templates templates2;
                block10: {
                    StylesheetImpl stylesheet;
                    if (systemId != null && (stylesheet = this.loadPrecompiledStylesheet(systemId, systemId)) != null) {
                        return stylesheet;
                    }
                    if (source instanceof DOMSource) {
                        Node node = ((DOMSource)source).getNode();
                        return this.generateFromNode(node, systemId);
                    }
                    if (source instanceof SAXSource) {
                        SAXSource saxSource = (SAXSource)source;
                        XMLReader reader = saxSource.getXMLReader();
                        InputSource inputSource = saxSource.getInputSource();
                        QDocument doc = new QDocument();
                        DOMBuilder builder = new DOMBuilder();
                        builder.init(doc);
                        reader.setContentHandler(builder);
                        reader.parse(inputSource);
                        return this.generateFromNode(doc, systemId);
                    }
                    rs = this.openPath(source);
                    try {
                        Path path = rs.getPath();
                        Document doc = this.parseXSL(rs);
                        if (systemId != null) {
                            String mangledName = this.getMangledName(systemId);
                            Path genPath = this.getWorkPath().lookup(mangledName);
                            genPath.setUserPath(systemId);
                            templates2 = this.generate(doc, genPath);
                            Object var10_16 = null;
                            if (rs == null) return templates2;
                            break block10;
                        }
                        templates = this.generateFromNode(doc, null);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                }
                rs.close();
                return templates2;
            }
            Object var10_17 = null;
            if (rs == null) return templates;
            rs.close();
            return templates;
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XslParseException(e);
        }
    }

    private Templates generateFromNode(Node node, String systemId) throws IOException, TransformerConfigurationException {
        Path tempPath = this.writeTempFile(node);
        String tempId = tempPath.getTail();
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(tempId, tempId, false);
        if (systemId != null) {
            tempPath.setUserPath(systemId);
        }
        if (stylesheet != null) {
            return stylesheet;
        }
        return this.generate(node, tempPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeTempFile(Node node) throws IOException {
        Path workDir = CauchoSystem.getWorkPath().lookup("_xsl");
        workDir.mkdirs();
        WriteStream os = Vfs.lookup("null:").openWrite();
        Crc64Stream crcStream = new Crc64Stream(os.getSource());
        os.init((StreamImpl)crcStream);
        try {
            XmlPrinter printer = new XmlPrinter((OutputStream)os);
            printer.printNode(node);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            os.close();
            throw throwable;
        }
        os.close();
        long crc = crcStream.getCRC();
        CharBuffer cb = new CharBuffer();
        Base64.encode((CharBuffer)cb, (long)crc);
        String crcValue = cb.toString().replace('/', '-');
        Path xslPath = workDir.lookup(crcValue + ".xsl");
        return xslPath;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return this.newTransformerHandler(new StylesheetImpl());
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        return this.newTransformerHandler(this.newTemplates(source));
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        return new TransformerHandlerImpl(templates.newTransformer());
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        return new SAXFilterImpl((TransformerImpl)templates.newTransformer());
    }

    protected Node parseStylesheet(Source source) throws TransformerConfigurationException {
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        if (source instanceof StreamSource) {
            Document document;
            block7: {
                InputStream is = ((StreamSource)source).getInputStream();
                ReadStream rs = null;
                try {
                    rs = Vfs.openRead(is);
                    document = this.parseXSL(rs);
                    Object var6_6 = null;
                    if (rs == null) break block7;
                }
                catch (Exception e) {
                    try {
                        throw new TransformerConfigurationException(e);
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                }
                rs.close();
            }
            return document;
        }
        return null;
    }

    public Templates newTemplates(Node node) throws TransformerConfigurationException {
        DocumentType dtd;
        Document doc = node.getOwnerDocument();
        if (node instanceof Document) {
            doc = (Document)node;
        }
        if ((dtd = doc.getDoctype()) != null && dtd.getSystemId() != null) {
            return this.generate(node, this.getSearchPath().lookup(dtd.getSystemId()));
        }
        if (doc instanceof CauchoDocument) {
            String systemId = ((CauchoDocument)doc).getFilename();
            return this.generate(node, this.getSearchPath().lookup(systemId));
        }
        return this.generate(node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates newTemplates(String systemId) throws TransformerConfigurationException {
        StylesheetImpl stylesheet = this.loadPrecompiledStylesheet(systemId, systemId);
        if (stylesheet != null) {
            return stylesheet;
        }
        if (systemId == null) {
            return this.generate(new QDocument(), null);
        }
        Path path = this.getSearchPath().lookup(systemId);
        try {
            Document doc;
            ReadStream is = path.openRead();
            try {
                doc = this.parseXSL(is);
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return this.generate(doc, path);
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (IOException e) {
            System.out.println("MP: " + ((MergePath)this.getSearchPath()).getMergePaths());
            throw new TransformerConfigurationExceptionWrapper(e);
        }
        catch (Exception e) {
            throw new TransformerConfigurationExceptionWrapper(e);
        }
    }

    ReadStream openPath(String href, String base) throws TransformerException, IOException {
        Source source;
        if (this._uriResolver != null && (source = this._uriResolver.resolve(href, base)) != null) {
            return this.openPath(source);
        }
        if (href.startsWith("/") || base.equals("/")) {
            return this.getSearchPath().lookup(href).openRead();
        }
        Path path = this.getSearchPath().lookup(base).getParent().lookup(href);
        if (path.exists()) {
            return path.openRead();
        }
        return this.getSearchPath().lookup(href).openRead();
    }

    ReadStream openPath(Source source) throws TransformerException, IOException {
        String systemId = source.getSystemId();
        Path path = systemId != null ? this.getSearchPath().lookup(systemId) : this.getSearchPath().lookup("anonymous.xsl");
        if (source instanceof StreamSource) {
            StreamSource stream = (StreamSource)source;
            InputStream is = stream.getInputStream();
            if (is instanceof ReadStream) {
                ReadStream rs = (ReadStream)is;
                rs.setPath(path);
                return rs;
            }
            if (is != null) {
                ReadStream rs = Vfs.openRead(is);
                rs.setPath(path);
                return rs;
            }
            Reader reader = stream.getReader();
            if (reader != null) {
                ReadStream rs = Vfs.openRead(reader);
                rs.setPath(path);
                return rs;
            }
        }
        if (systemId != null) {
            return this.getSearchPath().lookup(systemId).openRead();
        }
        throw new TransformerException("bad source " + source);
    }

    Path lookupPath(String base, String href) throws TransformerException {
        String systemId;
        Source source;
        if (this._uriResolver != null && (source = this._uriResolver.resolve(href, base)) != null && (systemId = source.getSystemId()) != null) {
            return this.getSearchPath().lookup(systemId);
        }
        return this.getSearchPath().lookup(base).lookup(href);
    }

    public Transformer newTransformer(Document xsl) throws TransformerConfigurationException {
        return this.newTemplates(xsl).newTransformer();
    }

    public void transform(Document xsl, Node xml, OutputStream out) throws Exception {
        TransformerImpl transformer = (TransformerImpl)this.newTransformer(xsl);
        transformer.transform(xml, out);
    }

    public void transform(String xsl, Node xml, OutputStream out) throws Exception {
        TransformerImpl transformer = (TransformerImpl)this.newTemplates(xsl).newTransformer();
        transformer.transform(xml, out);
    }

    protected abstract Document parseXSL(ReadStream var1) throws TransformerConfigurationException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Templates generate(Node xsl, Path path) throws TransformerConfigurationException {
        log.fine("Generating XSL from " + path);
        Class<AbstractStylesheetFactory> clazz = AbstractStylesheetFactory.class;
        synchronized (AbstractStylesheetFactory.class) {
            Generator gen = null;
            try {
                try {
                    String filename;
                    if (path == null && xsl != null) {
                        Document doc = xsl.getOwnerDocument();
                        if (doc == null && xsl instanceof Document) {
                            doc = (Document)xsl;
                        }
                        DocumentType dtd = doc.getDoctype();
                        String systemId = null;
                        if (dtd != null) {
                            systemId = dtd.getSystemId();
                        }
                        if (systemId != null) {
                            path = this.getStylePath().lookup(systemId);
                        }
                    }
                    if (path == null && xsl instanceof CauchoNode && (filename = ((CauchoNode)xsl).getFilename()) != null) {
                        path = this.getStylePath().lookup(filename);
                    }
                    if (path == null) {
                        path = this.getStylePath().lookup("anonymous.xsl");
                    }
                    Path stylePath = path.getParent();
                    Expr expr = XPath.parseExpr("//xtp:directive.page/@language");
                    String language = expr.evalString(xsl);
                    String userName = path.getUserPath();
                    String mangledName = this.getMangledName(userName);
                    String encoding = XPath.evalString("//xsl:output/@encoding", xsl);
                    if (encoding != null && encoding.equals("")) {
                        encoding = null;
                    }
                    if (language != null && !language.equals("")) {
                        if (!language.equals("java")) throw new XslParseException(L.l("unsupported language `{0}'", (Object)language));
                    }
                    language = "java";
                    gen = new JavaGenerator(this, mangledName, encoding);
                    gen.setPath(path);
                    Iterator iter = XPath.select("//xtp:directive.page/@*", xsl);
                    while (iter.hasNext()) {
                        Attr attr = (Attr)iter.next();
                        String name = attr.getNodeName();
                        String value = attr.getNodeValue();
                        if (name.equals("errorPage")) {
                            gen.setErrorPage(value);
                            continue;
                        }
                        if (name.equals("import")) {
                            gen.addImport(value);
                            continue;
                        }
                        if (name.equals("contentType")) {
                            gen.setContentType(value);
                            continue;
                        }
                        if (name.equals("language")) {
                            if (language.equalsIgnoreCase(value)) continue;
                            throw new XslParseException(L.l("mismatched language `{0}'", (Object)value));
                        }
                        if (!name.equals("xml:space")) throw new XslParseException(L.l("unknown directive `{0}'", (Object)name));
                    }
                    StylesheetImpl stylesheet = gen.generate(xsl);
                    gen = null;
                    stylesheet.init(path);
                    stylesheet.setURIResolver(this._uriResolver);
                    StylesheetImpl stylesheetImpl = stylesheet;
                    Object var16_17 = null;
                    try {
                        if (gen == null) return stylesheetImpl;
                        gen.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return stylesheetImpl;
                }
                catch (TransformerConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XslParseException(e);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {}
                catch (IOException e) {
                    throw throwable;
                }
                if (gen == null) throw throwable;
                gen.close();
                throw throwable;
            }
        }
    }

    private String getMangledName(String userName) {
        String name = null;
        if (userName == null || userName.equals("anonymous.xsl") || userName.equals("string") || userName.equals("stream")) {
            userName = "x" + (new Random().nextInt() & 0x3FF) + ".xsl";
        }
        name = this.getClassName() == null ? userName : this.getClassName();
        name = name.startsWith("/") ? "xsl" + name : "xsl/" + name;
        return JavaCompiler.mangleName(name);
    }

    StylesheetImpl loadPrecompiledStylesheet(String systemId, String userId) {
        return this.loadPrecompiledStylesheet(systemId, userId, this._isAutoCompile);
    }

    StylesheetImpl loadPrecompiledStylesheet(String systemId, String userId, boolean checkModified) {
        if (!this._loadPrecompiledStylesheet) {
            return null;
        }
        try {
            StylesheetImpl stylesheet = this.loadStylesheet(systemId, this.getMangledName(userId));
            if (stylesheet == null) {
                return null;
            }
            stylesheet.setURIResolver(this._uriResolver);
            if (!checkModified || !stylesheet.isModified()) {
                stylesheet.setURIResolver(this._uriResolver);
                return stylesheet;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return null;
    }

    protected StylesheetImpl loadStylesheet(String systemId, String className) throws Exception {
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        LruCache cache = _stylesheetCache.getLevel(parentLoader);
        if (cache == null) {
            cache = new LruCache(256);
            _stylesheetCache.set((LruCache<String, SoftReference<StylesheetImpl>>)cache, parentLoader);
        }
        SoftReference<StylesheetImpl> stylesheetRef = (SoftReference<StylesheetImpl>)cache.get((Object)className);
        StylesheetImpl stylesheet = null;
        if (stylesheetRef != null) {
            stylesheet = (StylesheetImpl)stylesheetRef.get();
        }
        try {
            if (stylesheet != null && !stylesheet.isModified()) {
                return stylesheet;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        Path classPath = this.getWorkPath().lookup(className.replace('.', '/') + ".class");
        if (!classPath.canRead()) {
            throw new ClassNotFoundException("can't find compiled XSL `" + className + "'");
        }
        DynamicClassLoader loader = SimpleLoader.create(parentLoader, this.getWorkPath(), className);
        Class cl = null;
        try {
            cl = CauchoSystem.loadClass(className, false, loader);
        }
        catch (Error e) {
            try {
                classPath.remove();
            }
            catch (IOException e1) {
                log.log(Level.FINE, e1.toString(), e1);
            }
            throw e;
        }
        stylesheet = (StylesheetImpl)cl.newInstance();
        Path path = this.getSearchPath().lookup("").lookup(systemId);
        stylesheet.init(this.getStylePath());
        stylesheet.setURIResolver(this._uriResolver);
        stylesheetRef = new SoftReference<StylesheetImpl>(stylesheet);
        cache.put((Object)className, stylesheetRef);
        return stylesheet;
    }
}

