/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.java.JavaWriter;
import com.caucho.java.LineMap;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.IntArray;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPath;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.UnionPattern;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.JavaGenerator;
import com.caucho.xsl.Sort;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Template;
import com.caucho.xsl.XslNumberFormat;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.XslParser;
import com.caucho.xsl.fun.FormatNumberFun;
import com.caucho.xsl.fun.KeyFun;
import com.caucho.xsl.java.XslAttributeSet;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslStylesheet;
import com.caucho.xsl.java.XslTemplate;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Generator {
    private static final Logger log = Log.open(Generator.class);
    protected static final L10N L = new L10N(Generator.class);
    public static final String XSLNS = "http://www.w3.org/1999/XSL/Transform";
    public static final String XTPNS = "http://www.caucho.com/XTP/1.0";
    private static final int STYLESHEET = 0;
    private static final int OUTPUT = 1;
    private static final int IMPORT = 2;
    private static final int INCLUDE = 3;
    private static final int TEMPLATE = 4;
    private static final int STRIP_SPACE = 5;
    private static final int PRESERVE_SPACE = 6;
    private static final int KEY = 7;
    private static final int LOCALE = 8;
    private static final int ATTRIBUTE_SET = 9;
    private static final int NAMESPACE_ALIAS = 10;
    private static final int APPLY_TEMPLATES = 11;
    private static final int APPLY_IMPORTS = 12;
    private static final int CALL_TEMPLATE = 13;
    private static final int PARAM = 14;
    private static final int VARIABLE = 15;
    private static final int VALUE_OF = 16;
    private static final int COPY_OF = 17;
    private static final int FOR_EACH = 18;
    private static final int IF = 19;
    private static final int CHOOSE = 20;
    private static final int TEXT = 21;
    private static final int XSL_TEXT = 22;
    private static final int NUMBER = 23;
    private static final int COPY = 24;
    private static final int COPY_ELEMENT = 25;
    private static final int ELEMENT = 26;
    private static final int ATTRIBUTE = 27;
    private static final int PI = 28;
    private static final int COMMENT = 29;
    private static final int MESSAGE = 30;
    private static final int EXPRESSION = 31;
    private static final int SCRIPTLET = 32;
    private static final int DECLARATION = 33;
    private static final int DIRECTIVE_CACHE = 34;
    private static final int DIRECTIVE_PAGE = 35;
    private static final int WHILE = 36;
    private static final int ASSIGN = 37;
    private static final int IGNORE = 38;
    private static final int RESULT_DOCUMENT = 39;
    private static IntMap _tags;
    private static IntMap _xtpTags;
    private String _version = "1.0";
    String _xslName;
    Path _topContext;
    Path _baseURL;
    Path _context;
    CharBuffer _text;
    HashMap<String, String> _names = new HashMap();
    int _loopDepth;
    Path _workPath;
    int _uniqueId;
    protected HashMap<String, String> _preserve = new HashMap();
    protected HashMap<String, String> _strip = new HashMap();
    HashMap<String, XslAttributeSet> _attributeSets = new HashMap();
    protected HashMap<String, String[]> _namespaceAliases = new HashMap();
    protected HashMap<String, String> _excludedNamespaces = new HashMap();
    protected KeyFun _keyFun;
    protected FormatNumberFun _formatNumberFun;
    protected NamespaceContext _namespace;
    protected ArrayList _globalActions = new ArrayList();
    protected ArrayList<String> _globalParameters = new ArrayList();
    protected Document _doc;
    protected CauchoDocument _qDoc;
    protected Path _path;
    boolean _lineContent;
    int _lineWs;
    String _systemId;
    String _filename;
    int _line;
    protected LineMap _lineMap;
    private ArrayList _frags;
    protected int _destLine = 1;
    boolean _defaultCacheable = true;
    boolean _isCacheable;
    protected String _encoding;
    HashMap<String, ArrayList<Template>> _templates = new HashMap();
    int _minImportance;
    int _importance;
    int _templateCount;
    private IntArray _vars = new IntArray();
    private ArrayList<XslNode> _inits = new ArrayList();
    protected ArrayList<Path> _depends = new ArrayList();
    protected ArrayList<String> _cacheDepends = new ArrayList();
    private boolean _isCauchoXsl;
    protected boolean _isRawText;
    protected String _errorPage;
    boolean _hasSession;
    protected AbstractPattern _nodeListContext;
    private boolean _isTop;
    private ClassLoader _loader;
    protected boolean _isSpecial;
    protected boolean _isStyleScript;
    HashMap<String, String> _outputAttributes = new HashMap();
    HashMap<String, String> _macros;
    HashMap<String, Document> _files;
    protected AbstractStylesheetFactory _xslGenerator;
    protected ArrayList<String> _imports = new ArrayList();
    private static CharScanner commaDelimScanner;

    Generator(AbstractStylesheetFactory xslGenerator) {
        Path path;
        this._xslGenerator = xslGenerator;
        this._workPath = xslGenerator.getWorkPath();
        this._topContext = this._context = (path = xslGenerator.getStylePath());
        this._loader = xslGenerator.getClassLoader();
        if (this._loader == null) {
            this._loader = Thread.currentThread().getContextClassLoader();
        }
        this._text = new CharBuffer();
        this._frags = new ArrayList();
        this._macros = new HashMap();
        this._keyFun = new KeyFun();
        this._formatNumberFun = new FormatNumberFun();
    }

    void init(String filename) {
        this._lineMap = new LineMap(filename);
    }

    public void setErrorPage(String errorPage) {
        this._errorPage = errorPage;
    }

    public void setStyleScript(boolean stylescript) {
        this._isStyleScript = stylescript;
    }

    public void addImport(String pkg) {
        if (!this._imports.contains(pkg)) {
            this._imports.add(pkg);
        }
    }

    public void setContentType(String type) {
    }

    void setPath(Path path) {
        this._path = path;
        this._context = path;
    }

    void setWorkPath(Path path) {
        this._workPath = path;
    }

    public int getMinImportance() {
        return this._minImportance;
    }

    public int getMaxImportance() {
        return this._importance;
    }

    public NamespaceContext getNamespace() {
        return this._namespace;
    }

    public AbstractPattern getNodeListContext() {
        return this._nodeListContext;
    }

    public void addLocale(String name, DecimalFormatSymbols format) {
        this._formatNumberFun.addLocale(name, format);
    }

    public int uniqueId() {
        return this._uniqueId++;
    }

    public StylesheetImpl generate(Node node) throws Exception {
        Element top;
        DocumentType dtd;
        Document xsl = node.getOwnerDocument();
        if (xsl == null) {
            xsl = (Document)node;
        }
        if ((dtd = xsl.getDoctype()) != null && dtd.getSystemId() != null) {
            this._topContext = this._context = this._path.lookup(dtd.getSystemId());
        }
        if ((top = xsl.getDocumentElement()) == null) {
            throw this.error((Node)xsl, L.l("xsl:stylesheet must be top element."));
        }
        this._doc = xsl;
        if (this._doc instanceof CauchoDocument) {
            this._qDoc = (CauchoDocument)this._doc;
        }
        QElement qTop = null;
        if (top instanceof QElement) {
            qTop = (QElement)top;
        }
        this._isTop = true;
        this._files = new HashMap();
        this.scanFiles(top);
        if (this._qDoc != null) {
            ArrayList depends = (ArrayList)this._qDoc.getProperty("caucho.depends");
            for (int i = 0; depends != null && i < depends.size(); ++i) {
                Path path = (Path)depends.get(i);
                this.addDepend(path);
            }
        } else {
            this.addDepend(this._path);
        }
        if ("stylesheet".equals(this.getXslLocal(top)) || "transform".equals(this.getXslLocal(top))) {
            this.generateStylesheet(top, true);
        } else {
            this.printHeader();
            boolean oldCacheable = this._isCacheable;
            boolean oldDefaultCacheable = this._defaultCacheable;
            this._isCacheable = true;
            XslNode literal = this.createChild(top);
            XslTemplate template = new XslTemplate();
            template.setGenerator((JavaGenerator)this);
            template.addAttribute(new QName("match"), "/");
            template.addChild(literal);
            template.generateDeclaration(this.getOut());
            template.generate(this.getOut());
            this._isCacheable = oldCacheable;
            this._defaultCacheable = oldDefaultCacheable;
        }
        this.addNamespace(top);
        StylesheetImpl stylesheet = this.completeGenerate(this._inits, this._globalActions);
        return stylesheet;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanFiles(Element top) throws XslParseException, IOException {
        block14: {
            this._isCauchoXsl = top.getAttribute("xsl-caucho").equals("") == false;
            try {
                iter = XPath.select("//xtp:directive.page/@*", top);
            }
            catch (Exception e) {
                throw new XslParseException(e);
            }
            block6: while (true) {
                if (iter.hasNext()) {
                    attr = (Attr)iter.next();
                    name = attr.getNodeName();
                    value = attr.getNodeValue();
                    if (!name.equals("import")) continue;
                } else {
                    try {
                        iter = XPath.select("//xsl:import|xsl:include", top);
                        break block14;
                    }
                    catch (Exception e) {
                        throw new XslParseException(e);
                    }
                }
                cursor = new StringCharCursor((CharSequence)value);
                cb = new CharBuffer();
                while (true) {
                    if (cursor.current() == '\uffff') ** break;
                    Generator.commaDelimScanner.skip((CharCursor)cursor);
                    cb.clear();
                    ch = Generator.commaDelimScanner.scan((CharCursor)cursor, cb);
                    if (cb.length() != 0) {
                        this.addImport(cb.toString());
                        continue;
                    }
                    if (ch != '\uffff') break block6;
                }
                break;
            }
            throw new IOException(Generator.L.l("illegal `import' directive"));
        }
        while (true) {
            if (!iter.hasNext()) {
                return;
            }
            elt = (Element)iter.next();
            href = elt.getAttribute("href");
            try {
                rs = this._xslGenerator.openPath(href, this._context.getURL());
            }
            catch (Exception e) {
                throw new XslParseException(e);
            }
            path = rs.getPath();
            xsl = this.readXsl(rs);
            subtop = xsl.getDocumentElement();
            if (subtop == null) {
                throw this.error((Node)elt, Generator.L.l("xsl:import file {0} is empty", (Object)path.getFullPath()));
            }
            oldContext = this._context;
            this._context = virtualPath = this._context.getParent().lookup(href);
            this._files.put(virtualPath.getPath(), xsl);
            this.scanFiles(subtop);
            this._context = oldContext;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addImportList(String value) throws XslParseException {
        StringCharCursor cursor = new StringCharCursor((CharSequence)value);
        CharBuffer cb = new CharBuffer();
        while (true) {
            if (cursor.current() == '\uffff') {
                return;
            }
            commaDelimScanner.skip((CharCursor)cursor);
            cb.clear();
            char ch = commaDelimScanner.scan((CharCursor)cursor, cb);
            if (cb.length() != 0) {
                this.addImport(cb.toString());
                continue;
            }
            if (ch != '\uffff') break;
        }
        throw this.error(L.l("illegal `import' directive"));
    }

    Document readXsl(Path path) throws IOException, XslParseException {
        return this.readXsl(path.openRead());
    }

    Document readXsl(ReadStream file) throws IOException, XslParseException {
        Document parser2;
        block5: {
            this.addDepend(file.getPath());
            if (!this._isStyleScript) break block5;
            XslParser parser2 = new XslParser();
            Document document = parser2.parse(file);
            Object var5_6 = null;
            file.close();
            return document;
        }
        try {
            parser2 = new Xml().parseDocument((InputStream)file);
            Object var5_7 = null;
        }
        catch (SAXException e) {
            try {
                throw new XslParseException(e);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                file.close();
                throw throwable;
            }
        }
        file.close();
        return parser2;
    }

    private void generateStylesheet(Element elt, boolean isTop) throws Exception {
        QElement element = (QElement)elt;
        this._isCauchoXsl = !element.getAttribute("xsl-caucho").equals("");
        String systemId = element.getBaseURI();
        Path oldContext = this._context;
        if (systemId != null) {
            this._context = this._context.lookup(systemId);
        }
        XslNode stylesheet = this.createChild(element);
        this.addNamespace(element);
        if (isTop) {
            this.printHeader();
        }
        stylesheet.generateDeclaration(this.getOut());
        stylesheet.generate(this.getOut());
        this._context = oldContext;
    }

    protected abstract JavaWriter getOut();

    protected abstract XslNode createChild(Node var1) throws Exception;

    protected abstract XslNode createChild(XslNode var1, Node var2) throws Exception;

    private void addGlobalAction(Element elt) {
        this._globalActions.add(elt);
    }

    private void excludeNamespaces(Element element) throws Exception {
        if (!(element instanceof QElement)) {
            return;
        }
        QElement elt = (QElement)element;
        String excludeNamespace = element.getAttribute("exclude-result-prefixes");
        if (!excludeNamespace.equals("")) {
            for (String prefix : excludeNamespace.split("[,\\s]+")) {
                String ns = elt.getNamespace(prefix);
                if (ns == null) {
                    throw this.error((Node)elt, L.l("`{0}' must be a namespace prefix", (Object)prefix));
                }
                this._excludedNamespaces.put(ns, "");
            }
        }
    }

    public void addExcludedNamespace(String ns) {
        this._excludedNamespaces.put(ns, "");
    }

    public void addInit(XslNode node) {
        this._inits.add(node);
    }

    public void addGlobalParameter(String param) {
        this._globalParameters.add(param);
    }

    private void addCacheDepends(String attr) {
        if (attr.equals("")) {
            return;
        }
        int i = 0;
        int ch = 0;
        int len = attr.length();
        while (true) {
            block12: {
                block11: {
                    if (i >= len) break block11;
                    char c = attr.charAt(i);
                    ch = c;
                    if (XmlChar.isWhitespace(c)) break block12;
                }
                if (ch != 44) break;
            }
            ++i;
        }
        CharBuffer cb = new CharBuffer();
        block1: while (i < len) {
            cb.clear();
            while (i < len) {
                char c = attr.charAt(i);
                ch = c;
                if (XmlChar.isWhitespace(c) || ch == 44) break;
                cb.append((char)ch);
                ++i;
            }
            this._cacheDepends.add(cb.toString());
            while (true) {
                block14: {
                    block13: {
                        if (i >= len) break block13;
                        char c = attr.charAt(i);
                        ch = c;
                        if (XmlChar.isWhitespace(c)) break block14;
                    }
                    if (ch != 44) continue block1;
                }
                ++i;
            }
        }
    }

    private void generateCacheDepends(String attr) throws Exception {
        if (attr.equals("")) {
            return;
        }
        int i = 0;
        int ch = 0;
        int len = attr.length();
        while (true) {
            block12: {
                block11: {
                    if (i >= len) break block11;
                    char c = attr.charAt(i);
                    ch = c;
                    if (XmlChar.isWhitespace(c)) break block12;
                }
                if (ch != 44) break;
            }
            ++i;
        }
        CharBuffer cb = new CharBuffer();
        block1: while (i < len) {
            cb.clear();
            while (i < len) {
                char c = attr.charAt(i);
                ch = c;
                if (XmlChar.isWhitespace(c) || ch == 44) break;
                cb.append((char)ch);
                ++i;
            }
            this.printCacheDepends(cb.toString());
            while (true) {
                block14: {
                    block13: {
                        if (i >= len) break block13;
                        char c = attr.charAt(i);
                        ch = c;
                        if (XmlChar.isWhitespace(c)) break block14;
                    }
                    if (ch != 44) continue block1;
                }
                ++i;
            }
        }
    }

    void generateTemplate(Element element) throws Exception {
        String name = element.getAttribute("name");
        String patternString = element.getAttribute("match");
        String mode = element.getAttribute("mode");
        String priority = element.getAttribute("priority");
        double dPriority = Double.NaN;
        if (!name.equals("")) {
            this._macros.put(name, name);
        }
        if (name.equals("") && patternString.equals("")) {
            throw this.error("xsl:template expects a `name' or a `match' attribute.");
        }
        if (!priority.equals("")) {
            try {
                dPriority = Double.valueOf(priority);
            }
            catch (Exception e) {
                throw this.error("xsl:template expects `priority' must be a double.");
            }
        }
        boolean oldCacheable = this._isCacheable;
        boolean oldDefaultCacheable = this._defaultCacheable;
        AbstractPattern oldNodeListContext = this._nodeListContext;
        if (!patternString.equals("")) {
            this._nodeListContext = this.parseMatch(patternString);
        }
        this._isCacheable = true;
        this.printTemplate(element, name, patternString, mode, dPriority);
        this._nodeListContext = oldNodeListContext;
        this._isCacheable = oldCacheable;
        this._defaultCacheable = oldDefaultCacheable;
    }

    public XslNode generateImport(String href) throws Exception {
        Path virtualPath;
        Path path = this.lookupPath(href);
        if (this._files.get(path.getPath()) != null) {
            return null;
        }
        Document xsl = this.readFile(href, path);
        if (xsl == null) {
            throw new FileNotFoundException(href);
        }
        QElement top = (QElement)xsl.getDocumentElement();
        if (top == null || !"stylesheet".equals(this.getXslLocal(top)) && !"transform".equals(this.getXslLocal(top))) {
            throw this.error("imported stylesheet `" + href + "' missing xsl:stylesheet.");
        }
        int oldMinImportance = this._minImportance;
        Path oldContext = this._context;
        this._context = virtualPath = this._context.getParent().lookup(href);
        this._minImportance = this._importance;
        boolean oldTop = this._isTop;
        boolean oldRaw = this._isRawText;
        this._isTop = false;
        this._isRawText = false;
        String systemId = top.getBaseURI();
        if (systemId != null) {
            this._context = this._context.lookup(systemId);
        }
        XslStylesheet stylesheet = (XslStylesheet)this.createChild(top);
        this._isRawText = oldRaw;
        this._isTop = oldTop;
        this._minImportance = oldMinImportance;
        this._context = oldContext;
        this.incrementImportance();
        return stylesheet;
    }

    void generateInclude(Element element) throws Exception {
        String href = element.getAttribute("href");
        if (href.equals("")) {
            throw this.error("xsl:include expects `href' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:include must be empty");
        }
    }

    public void generateInclude(XslNode parent, String href) throws Exception {
        Path path = this.lookupPath(href);
        if (this._files.get(path.getPath()) != null) {
            return;
        }
        Document xsl = this.readFile(href, path);
        Element top = xsl.getDocumentElement();
        if (top == null || !"stylesheet".equals(this.getXslLocal(top)) && !"transform".equals(this.getXslLocal(top))) {
            throw this.error("imported stylesheet `" + href + "' missing xsl:stylesheet.");
        }
        Path oldContext = this._context;
        this._context = path;
        for (Node node = top.getFirstChild(); node != null; node = node.getNextSibling()) {
            XslNode child = this.createChild(parent, node);
            if (child == null) continue;
            parent.addChild(child);
        }
        this._context = oldContext;
    }

    private Path lookupPath(String href) {
        return this._context.getParent().lookup(href);
    }

    private Document readFile(String href, Path virtualPath) throws Exception {
        ReadStream rs;
        Document xsl = this._files.get(virtualPath.getPath());
        if (xsl != null) {
            throw new IllegalStateException(L.l("'{0}' is a duplicated path", (Object)virtualPath.getPath()));
        }
        try {
            rs = this._xslGenerator.openPath(href, this._context.getURL());
        }
        catch (Exception e) {
            throw new XslParseException(e);
        }
        Path path = rs.getPath();
        xsl = this.readXsl(rs);
        Element subtop = xsl.getDocumentElement();
        if (subtop == null) {
            throw this.error(L.l("xsl:import file {0} is empty", (Object)path.getFullPath()));
        }
        Path oldContext = this._context;
        this._context = virtualPath;
        this._files.put(virtualPath.getPath(), xsl);
        this._context = oldContext;
        return xsl;
    }

    void generateKey(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error("xsl:key expects `name' attribute.");
        }
        String match = element.getAttribute("match");
        if (match.equals("")) {
            throw this.error("xsl:key expects `match' attribute.");
        }
        String use = element.getAttribute("use");
        if (use.equals("")) {
            throw this.error("xsl:key expects `use' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:key must be empty");
        }
        this._keyFun.add(name, this.parseMatch(match), this.parseExpr(use));
    }

    public void addKey(String name, AbstractPattern match, Expr use) {
        this._keyFun.add(name, match, use);
    }

    void generateLocale(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            name = "*";
        }
        DecimalFormatSymbols format = new DecimalFormatSymbols();
        String value = element.getAttribute("decimal-separator");
        if (value.length() > 0) {
            format.setDecimalSeparator(value.charAt(0));
        }
        if ((value = element.getAttribute("grouping-separator")).length() > 0) {
            format.setGroupingSeparator(value.charAt(0));
        }
        if (!(value = element.getAttribute("infinity")).equals("")) {
            format.setInfinity(value);
        }
        if ((value = element.getAttribute("minus-sign")).length() > 0) {
            format.setMinusSign(value.charAt(0));
        }
        if (!(value = element.getAttribute("NaN")).equals("")) {
            format.setNaN(value);
        }
        if ((value = element.getAttribute("percent")).length() > 0) {
            format.setPercent(value.charAt(0));
        }
        if ((value = element.getAttribute("per-mille")).length() > 0) {
            format.setPerMill(value.charAt(0));
        }
        if ((value = element.getAttribute("zero-digit")).length() > 0) {
            format.setZeroDigit(value.charAt(0));
        }
        if ((value = element.getAttribute("digit")).length() > 0) {
            format.setDigit(value.charAt(0));
        }
        if ((value = element.getAttribute("pattern-separator")).length() > 0) {
            format.setPatternSeparator(value.charAt(0));
        }
        this._formatNumberFun.addLocale(name, format);
    }

    void generateNamespaceAlias(Element element) throws Exception {
        if (!(element instanceof QElement)) {
            return;
        }
        QElement elt = (QElement)element;
        String stylesheetPrefix = element.getAttribute("stylesheet-prefix");
        String resultPrefix = element.getAttribute("result-prefix");
        if (stylesheetPrefix.equals("")) {
            throw this.error((Node)element, "xsl:namespace-alias needs `stylesheet-prefix'");
        }
        if (resultPrefix.equals("")) {
            throw this.error((Node)element, "xsl:namespace-alias needs `result-prefix'");
        }
    }

    public void addNamespaceAlias(String stylesheetPrefix, String resultPrefix) {
    }

    public void addNamespaceAlias(String namespace, String[] result) {
        this._namespaceAliases.put(namespace, result);
    }

    public String[] getNamespaceAlias(String namespace) {
        return this._namespaceAliases.get(namespace);
    }

    public void addAttributeSet(String name, XslAttributeSet attributeSet) {
        this._attributeSets.put(name, attributeSet);
    }

    public void setDisableOutputEscaping(boolean disable) {
        this._isRawText = disable;
    }

    public boolean getDisableOutputEscaping() {
        return this._isRawText;
    }

    private void generateOutput(Element element) throws Exception {
        Node attr = ((QElement)element).getFirstAttribute();
        if (element.getFirstChild() != null) {
            throw this.error("xsl:output must be empty");
        }
        String disableEscaping = element.getAttribute("resin:disable-output-escaping");
        if (disableEscaping.equals("")) {
            disableEscaping = element.getAttribute("disable-output-escaping");
        }
        if (disableEscaping.equals("no") || disableEscaping.equals("false")) {
            this._isRawText = false;
        } else if (!disableEscaping.equals("")) {
            this._isRawText = true;
        }
        if (!this._isTop) {
            return;
        }
        if (this._outputAttributes == null) {
            this._outputAttributes = new HashMap();
        }
        while (attr != null) {
            this._outputAttributes.put(attr.getNodeName(), attr.getNodeValue());
            attr = attr.getNextSibling();
        }
    }

    public void setOutputAttribute(String name, String value) {
        this._outputAttributes.put(name, value);
    }

    private void generatePreserveSpace(Element element) throws Exception {
        int i;
        String elements = element.getAttribute("elements");
        if (elements.equals("")) {
            throw this.error("xsl:preserve-space expects `elements' attribute.");
        }
        if (element.getFirstChild() != null) {
            throw this.error("xsl:preserve-space must be empty");
        }
        int len = elements.length();
        for (i = 0; i < len && XmlChar.isWhitespace(elements.charAt(i)); ++i) {
        }
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(elements.charAt(i))) {
                cb.append(elements.charAt(i));
                ++i;
            }
            this._preserve.put(cb.toString(), "true");
            while (i < len && XmlChar.isWhitespace(elements.charAt(i))) {
                ++i;
            }
        }
    }

    private void generateStripSpace(Element element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void addStripSpace(String elements) {
        int i;
        int len = elements.length();
        for (i = 0; i < len && XmlChar.isWhitespace(elements.charAt(i)); ++i) {
        }
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(elements.charAt(i))) {
                cb.append(elements.charAt(i));
                ++i;
            }
            this._strip.put(cb.toString(), "true");
            while (i < len && XmlChar.isWhitespace(elements.charAt(i))) {
                ++i;
            }
        }
    }

    public void addPreserveSpace(String elements) {
        int i;
        int len = elements.length();
        for (i = 0; i < len && XmlChar.isWhitespace(elements.charAt(i)); ++i) {
        }
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            cb.clear();
            while (i < len && !XmlChar.isWhitespace(elements.charAt(i))) {
                cb.append(elements.charAt(i));
                ++i;
            }
            this._preserve.put(cb.toString(), "true");
            while (i < len && XmlChar.isWhitespace(elements.charAt(i))) {
                ++i;
            }
        }
    }

    protected void generateChildren(Node node) throws Exception {
        this._vars.add(0);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.generateChild(child);
        }
        int count = this._vars.pop();
        if (count > 0 && this._vars.size() > 0) {
            this.printPopScope(count);
        }
    }

    protected void generateChild(Node child) throws Exception {
        this.generateChildImpl(child);
    }

    public void generateChildImpl(Node child) throws Exception {
        String nodeName = this.getXslLocal(child);
        int code = -1;
        if (nodeName != null) {
            code = _tags.get((Object)nodeName);
        } else {
            nodeName = this.getXtpLocal(child);
            if (nodeName != null) {
                code = _xtpTags.get((Object)nodeName);
            }
        }
        if (nodeName == null) {
            if (child.getNodeType() == 3) {
                this.generateText(child);
            } else if (child.getNodeType() == 1) {
                NamespaceContext oldNamespace = this.addNamespace((Element)child);
                this.printElement((Element)child);
                this._namespace = oldNamespace;
            }
            return;
        }
        if (child instanceof QElement) {
            NamespaceContext oldNamespace = this.addNamespace((QElement)child);
            this.generateChild(child, code);
            this._namespace = oldNamespace;
        } else {
            this.generateChild(child, code);
        }
    }

    public void generateChild(Node child, int code) throws Exception {
        if (child instanceof QAbstractNode) {
            QAbstractNode qChild = (QAbstractNode)child;
            this.setLocation(qChild.getBaseURI(), qChild.getFilename(), qChild.getLine());
        }
        switch (code) {
            case 21: {
                this.generateText(child);
                break;
            }
            case 22: {
                this.generateXslText((Element)child);
                break;
            }
            case 11: {
                this.generateApplyTemplates((Element)child);
                break;
            }
            case 12: {
                this.generateApplyImports((Element)child);
                break;
            }
            case 13: {
                this.generateCallTemplate((Element)child);
                break;
            }
            case 14: {
                this.generateParamVariable((Element)child);
                break;
            }
            case 15: {
                this.generateVariable((Element)child);
                break;
            }
            case 16: {
                this.generateValueOf((Element)child);
                break;
            }
            case 17: {
                this.generateCopyOf((Element)child);
                break;
            }
            case 18: {
                this.generateForEach((Element)child);
                break;
            }
            case 19: {
                this.generateIf((Element)child);
                break;
            }
            case 20: {
                this.generateChoose((Element)child);
                break;
            }
            case 23: {
                this.generateNumber((Element)child);
                break;
            }
            case 24: {
                this.printCopy((Element)child);
                break;
            }
            case 25: {
                this.printCopyElement((Element)child);
                break;
            }
            case 26: {
                this.generateElement((Element)child);
                break;
            }
            case 27: {
                this.generateAttribute((Element)child);
                break;
            }
            case 28: {
                this.printPi((Element)child);
                break;
            }
            case 29: {
                this.printComment((Element)child);
                break;
            }
            case 30: {
                this.printMessage((Element)child);
                break;
            }
            case 31: {
                if (!this._defaultCacheable) {
                    this._isCacheable = false;
                }
                this.printExpression((Element)child);
                break;
            }
            case 32: {
                if (!this._defaultCacheable) {
                    this._isCacheable = false;
                }
                this.printScriptlet((Element)child);
                break;
            }
            case 34: {
                this.generateCacheDepends(((Element)child).getAttribute("file"));
                if (!((Element)child).getAttribute("no-cache").equals("")) {
                    this._isCacheable = false;
                    this._defaultCacheable = false;
                    break;
                }
                this._defaultCacheable = true;
                break;
            }
            case 36: {
                this.generateWhile((Element)child);
                break;
            }
            case 37: {
                this.generateAssign((Element)child);
                break;
            }
            case 39: {
                this.generateResultDocument((Element)child);
                break;
            }
            case 38: {
                break;
            }
            default: {
                if (child instanceof QElement && XSLNS.equals(((QElement)child).getNamespaceURI()) && this._version != null && this._version.equals("1.0")) {
                    throw this.error(child, "unknown XSL element `" + child.getNodeName() + "'");
                }
                boolean hasFallback = false;
                for (Node subchild = child.getFirstChild(); subchild != null; subchild = subchild.getNextSibling()) {
                    String local = this.getXslLocal(subchild);
                    if (local == null || !local.equals("fallback")) continue;
                    hasFallback = true;
                    this.generateChildren(subchild);
                }
                if (hasFallback) break;
                this.printError(L.l("expected xsl tag at `{0}'", (Object)child.getNodeName()));
            }
        }
    }

    private void generateText(Node node) throws Exception {
        int i;
        String data = node.getNodeValue();
        int length = data.length();
        if (length == 0) {
            return;
        }
        for (i = 0; i < length && XmlChar.isWhitespace(data.charAt(i)); ++i) {
        }
        if (i == length && this.stripNode(node)) {
            return;
        }
        if (data != null && data.length() > 0 && node instanceof QAbstractNode) {
            this.setLocation(node);
            this.writeText(data);
        }
    }

    private boolean stripNode(Node node) {
        for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
            Element elt;
            String space;
            if (!(node instanceof Element) || (space = (elt = (Element)node).getAttribute("xml:space")).equals("")) continue;
            return !space.equals("preserve");
        }
        return true;
    }

    void generateXslText(Element element) throws Exception {
        this._text.clear();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            String data = child.getNodeValue();
            int length = data.length();
            this._text.append(data);
        }
        String disableEscaping = element.getAttribute("disable-output-escaping");
        if (disableEscaping.equals("")) {
            disableEscaping = "no";
        }
        if (this._text.length() > 0) {
            if (!disableEscaping.equals("yes") && !disableEscaping.equals("true")) {
                this.writeText(this._text.toString());
            } else {
                this.startDisableEscaping();
                this.writeText(this._text.toString());
                this.endDisableEscaping();
            }
        }
    }

    private void generateApplyTemplates(Node node) throws Exception {
        Sort[] sort;
        QElement element = (QElement)node;
        String select = element.getAttribute("select");
        String mode = element.getAttribute("mode");
        AbstractPattern selectPattern = null;
        if (!select.equals("")) {
            selectPattern = this.parseSelect(select, node);
        }
        if ((sort = this.generateSort(node)) != null && selectPattern == null) {
            selectPattern = this.parseSelect("*", node);
        }
        this.pushCall();
        this.generateArgs(element);
        this.printApplyTemplates(selectPattern, mode, sort);
        this.popCall();
    }

    private void generateApplyImports(Node node) throws Exception {
        QElement element = (QElement)node;
        String mode = element.getAttribute("mode");
        if (element.getFirstChild() != null) {
            throw this.error(L.l("xsl:apply-imports must be empty"));
        }
        this.pushCall();
        this.generateArgs(element);
        this.printApplyImports(mode, this._minImportance, this._importance);
        this.popCall();
    }

    private void generateCallTemplate(Element element) throws Exception {
        String name = element.getAttribute("name");
        String mode = element.getAttribute("mode");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:call-template", (Object)"name"));
        }
        if (this.findMacro(name) == null) {
            throw this.error((Node)element, L.l("`{0}' is an unknown macro for xsl:call-template.  All macros must be defined in an <xsl:template name='...'> element.", (Object)name));
        }
        this.pushCall();
        this.generateArgs(element);
        this.printCallTemplate(name, mode);
        this.popCall();
    }

    private Element findMacro(String name) throws Exception {
        Element template = this.findMacroInDocument(this._doc, name);
        if (template != null) {
            return template;
        }
        for (Document doc : this._files.values()) {
            template = this.findMacroInDocument(doc, name);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    private Element findMacroInDocument(Document doc, String name) {
        Element elt = doc.getDocumentElement();
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element template;
            if (!child.getNodeName().equals("xsl:template") || !(template = (Element)child).getAttribute("name").equals(name)) continue;
            return template;
        }
        return null;
    }

    private void generateMacro(Element element) throws Exception {
        QElement elt = (QElement)element;
        String name = element.getNodeName();
        String mode = element.getAttribute("mode");
        this.pushCall();
        for (Node node = elt.getFirstAttribute(); node != null; node = node.getNextSibling()) {
            String argName = node.getNodeName();
            String argValue = node.getNodeValue();
            this.printParam(argName, argValue, elt);
        }
        this.printParam("contents", elt);
        this.printCallTemplate(name, mode);
        this.popCall();
    }

    private void generateArgs(Element element) throws Exception {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String localName = this.getXslLocal(node);
            if (!"with-param".equals(localName)) continue;
            String key = ((Element)node).getAttribute("name");
            String expr = ((Element)node).getAttribute("select");
            if (key.equals("")) {
                throw this.error(L.l("{0} requires `{1}' attribute", (Object)"xsl:with-param", (Object)"name"));
            }
            if (!expr.equals("")) {
                this.printParam(key, this.parseExpr(expr));
                continue;
            }
            this.printParam(key, node);
        }
    }

    private void generateParamVariable(Element element) throws Exception {
        int i = this._vars.size() - 1;
        this._vars.set(i, this._vars.get(i) + 1);
        String name = element.getAttribute("name");
        String expr = element.getAttribute("select");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:param", (Object)"name"));
        }
        if (!expr.equals("")) {
            this.printParamVariable(name, this.parseExpr(expr));
        } else {
            this.printParamVariable(name, element);
        }
    }

    private void generateVariable(Element element) throws Exception {
        int i = this._vars.size() - 1;
        this._vars.set(i, this._vars.get(i) + 1);
        String name = element.getAttribute("name");
        String expr = element.getAttribute("select");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xsl:variable", (Object)"name"));
        }
        if (!expr.equals("")) {
            this.printVariable(name, this.parseExpr(expr));
        } else {
            this.printVariable(name, element);
        }
    }

    private void generateAssign(Element element) throws Exception {
        String name = element.getAttribute("name");
        String expr = element.getAttribute("select");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xtp:assign", (Object)"name"));
        }
        if (!expr.equals("")) {
            this.printAssign(name, this.parseExpr(expr));
        } else {
            this.printAssign(name, element);
        }
    }

    private void generateResultDocument(Element element) throws Exception {
        String href = element.getAttribute("href");
        String format = element.getAttribute("format");
        if (href.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xtp:result-document", (Object)"href"));
        }
        this.printResultDocument(element, href, format);
    }

    private void generateValueOf(Element element) throws Exception {
        String select = element.getAttribute("select");
        if (select.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xsl:value-of", (Object)"select"));
        }
        if (element.getFirstChild() != null) {
            throw this.error(L.l("{0} must be empty", (Object)"xsl:value-of"));
        }
        String disable = element.getAttribute("disable-output-escaping");
        boolean isDisabled = disable.equals("yes");
        if (isDisabled) {
            this.startDisableEscaping();
        }
        this.printSelectValue(select, element);
        if (isDisabled) {
            this.endDisableEscaping();
        }
    }

    private void generateCopyOf(Element element) throws Exception {
        String select = element.getAttribute("select");
        if (select.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:copy-of", (Object)"select"));
        }
        if (element.getFirstChild() != null) {
            throw this.error(L.l("{0} must be empty", (Object)"xsl:copy-of"));
        }
        this.printCopyOf(select, element);
    }

    void generateForEach(Element element) throws Exception {
        String select = element.getAttribute("select");
        if (select.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:for-each", (Object)"select"));
        }
        Sort[] sort = this.generateSort(element);
        if (sort != null) {
            this.printForEach(element, select, sort);
        } else {
            this.printForEach(element, select);
        }
    }

    private Sort[] generateSort(Node node) throws XslParseException, IOException {
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        block0: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String lang;
            if (child.getNodeType() == 3) {
                String data = child.getNodeValue();
                for (int i = 0; i < data.length(); ++i) {
                    if (!XmlChar.isWhitespace(data.charAt(i))) break block0;
                }
                continue;
            }
            if (child.getNodeType() == 8) continue;
            if (child.getNodeType() == 7) continue;
            String name = this.getXslLocal(child);
            if (!"sort".equals(name)) break;
            Element elt = (Element)child;
            String select = elt.getAttribute("select");
            if (select.equals("")) {
                throw this.error(L.l("{0} expects attribute `{1}'", (Object)"xsl:sort", (Object)"select"));
            }
            Expr expr = this.parseExpr(select);
            String order = elt.getAttribute("order");
            Expr isAscending = null;
            if (order.equals("")) {
                isAscending = this.parseExpr("true()");
            } else if (order.startsWith("{") && order.endsWith("}")) {
                order = order.substring(1, order.length() - 1);
                isAscending = this.parseExpr(order + " = 'ascending'");
            } else {
                isAscending = order.equals("ascending") ? this.parseExpr("true()") : this.parseExpr("false()");
            }
            String dataType = elt.getAttribute("data-type");
            boolean isText = true;
            if (dataType.equals("number")) {
                isText = false;
            }
            if ((lang = elt.getAttribute("lang")).equals("")) {
                sorts.add(Sort.create(expr, isAscending, isText));
                continue;
            }
            lang = lang.startsWith("{") && lang.endsWith("}") ? lang.substring(1, lang.length() - 1) : "'" + lang + "'";
            sorts.add(Sort.create(expr, isAscending, this.parseExpr(lang)));
        }
        if (sorts.size() > 0) {
            return sorts.toArray(new Sort[sorts.size()]);
        }
        return null;
    }

    void generateIf(Element element) throws Exception {
        String test = element.getAttribute("test");
        if (test.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:if", (Object)"test"));
        }
        this.printIf(element, this.parseExpr(test));
    }

    void generateWhile(Element element) throws Exception {
        String test = element.getAttribute("test");
        if (test.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:while", (Object)"test"));
        }
        this.printWhile(element, this.parseExpr(test));
    }

    void generateChoose(Element element) throws Exception {
        boolean first = true;
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            String name = this.getXslLocal(child);
            if ("when".equals(name)) {
                Element elt = (Element)child;
                String test = elt.getAttribute("test");
                if (test.equals("")) {
                    throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:when", (Object)"test"));
                }
                this.printChoose(elt, this.parseExpr(test), first);
                first = false;
                continue;
            }
            if ("otherwise".equals(name)) {
                this.printOtherwise((Element)child, first);
                continue;
            }
            throw this.error(L.l("xsl:choose expects `xsl:when' or `xsl:otherwise' at `{0}'", (Object)child.getNodeName()));
        }
    }

    void generateElement(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute.", (Object)"xsl:element", (Object)"name"));
        }
        Attr nsAttr = element.getAttributeNode("namespace");
        if (nsAttr == null) {
            this.printElement(element, name);
        } else {
            this.printElement(element, name, nsAttr.getNodeValue());
        }
    }

    void generateAttribute(Element element) throws Exception {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects `{1}' attribute", (Object)"xsl:attribute", (Object)"name"));
        }
        Attr nsAttr = element.getAttributeNode("namespace");
        boolean oldSpecial = this._isSpecial;
        this._isSpecial = true;
        if (nsAttr == null) {
            this.printAttribute(element, name);
        } else {
            this.printAttribute(element, name, nsAttr.getNodeValue());
        }
        this._isSpecial = oldSpecial;
    }

    void generateNumber(Element element) throws Exception {
        String value = element.getAttribute("value");
        String count = element.getAttribute("count");
        String from = element.getAttribute("from");
        String level = element.getAttribute("level");
        String format = element.getAttribute("format");
        String letter = element.getAttribute("letter-value");
        String separator = element.getAttribute("grouping-separator");
        String lang = element.getAttribute("lang");
        String size_name = element.getAttribute("grouping-size");
        int size = 0;
        for (int i = 0; i < size_name.length(); ++i) {
            char ch = size_name.charAt(i);
            if (ch < '0' || ch > '9') continue;
            size = 10 * size + ch - 48;
        }
        boolean isAlphabetic = true;
        if (!letter.equals("alphabetic")) {
            isAlphabetic = false;
        }
        AbstractPattern countPattern = null;
        if (!count.equals("")) {
            countPattern = this.parseMatch(count);
        }
        AbstractPattern fromPattern = null;
        if (!from.equals("")) {
            fromPattern = this.parseMatch(from);
        }
        if (level.equals("") || level.equals("single")) {
            level = "single";
        } else if (!level.equals("multiple") && !level.equals("any")) {
            throw this.error(L.l("xsl:number can't understand level=`{0}'", (Object)level));
        }
        XslNumberFormat xslFormat = new XslNumberFormat(format, lang, isAlphabetic, separator, size);
        if (!value.equals("")) {
            this.printNumber(this.parseExpr(value), xslFormat);
        } else {
            this.printNumber(level, countPattern, fromPattern, xslFormat);
        }
    }

    void printNumber(Expr expr, XslNumberFormat format) throws Exception {
    }

    void printNumber(String level, AbstractPattern countPattern, AbstractPattern fromPattern, XslNumberFormat format) throws Exception {
    }

    void setLocation(Node node) throws Exception {
        if (node instanceof QAbstractNode) {
            this.setLocation(((QAbstractNode)node).getBaseURI(), ((QAbstractNode)node).getFilename(), ((QAbstractNode)node).getLine());
        }
    }

    public void setLocation(String systemId, String filename, int line) throws XslParseException, IOException {
        if (filename != null) {
            this._systemId = systemId;
            this._filename = filename;
            this._line = line;
        }
    }

    int getTextLength() {
        return this._text.length();
    }

    protected void printHeader() throws XslParseException, IOException {
    }

    protected abstract void startDisableEscaping() throws Exception;

    protected abstract void endDisableEscaping() throws Exception;

    protected abstract void writeText(String var1) throws Exception;

    protected abstract void printTemplate(Element var1, String var2, String var3, String var4, double var5) throws Exception;

    void printLocation(Node node) throws Exception {
        if (node instanceof QAbstractNode) {
            this.printLocation(((QAbstractNode)node).getBaseURI(), ((QAbstractNode)node).getFilename(), ((QAbstractNode)node).getLine());
        }
    }

    protected abstract void printLocation(String var1, String var2, int var3) throws Exception;

    protected abstract void printElement(Node var1) throws Exception;

    protected abstract void printApplyTemplates(AbstractPattern var1, String var2, Sort[] var3) throws Exception;

    protected abstract void printApplyImports(String var1, int var2, int var3) throws Exception;

    protected abstract void printCallTemplate(String var1, String var2) throws Exception;

    protected abstract void pushCall() throws Exception;

    protected abstract void popCall() throws Exception;

    protected abstract void printParam(String var1, Object var2) throws Exception;

    protected abstract void printParam(String var1, String var2, Element var3) throws Exception;

    protected abstract void printParamVariable(String var1, Expr var2) throws Exception;

    protected abstract void printParamVariable(String var1, Element var2) throws Exception;

    protected abstract void printVariable(String var1, Object var2) throws Exception;

    protected void printAssign(String name, Object value) throws Exception {
        this.printVariable(name, value);
    }

    protected abstract void printPopScope(int var1) throws Exception;

    protected abstract void printCopyOf(String var1, Element var2) throws Exception;

    protected abstract void printSelectValue(String var1, Element var2) throws Exception;

    protected abstract void printForEach(Element var1, String var2) throws Exception;

    protected abstract void printForEach(Element var1, String var2, Sort[] var3) throws Exception;

    protected void printIf(Element element, Expr expr) throws Exception {
    }

    protected void printChoose(Element element, Expr expr, boolean first) throws Exception {
    }

    protected void printOtherwise(Element element, boolean first) throws Exception {
    }

    protected void printCopy(Element element) throws Exception {
    }

    protected void printCopyElement(Element element) throws Exception {
    }

    protected void printElement(Element element, String name) throws Exception {
    }

    protected void printElement(Element element, String name, String namespace) throws Exception {
    }

    protected void printAttribute(Element node, String name) throws Exception {
    }

    protected void printAttribute(Element node, String name, String namespace) throws Exception {
    }

    protected void printPi(Element node) throws Exception {
    }

    protected void printComment(Element node) throws Exception {
    }

    protected void printError(String msg) throws Exception {
    }

    protected void printMessage(Element node) throws Exception {
    }

    protected void printExpression(Element node) throws Exception {
    }

    protected void printScriptlet(Element node) throws Exception {
    }

    protected void printDeclaration(Element node) throws Exception {
    }

    protected void printCacheDepends(String path) throws Exception {
    }

    protected void printWhile(Element element, Expr expr) throws Exception {
    }

    protected void printResultDocument(Element element, String href, String format) throws Exception {
    }

    public int getImportance() {
        return this._importance;
    }

    public void setMinImportance(int importance) {
        this._minImportance = importance;
    }

    public void incrementImportance() {
        ++this._importance;
    }

    Template addPattern(AbstractPattern pattern, String mode, double priority, String function, int funId) {
        if (pattern instanceof UnionPattern) {
            UnionPattern union = (UnionPattern)pattern;
            this.addPattern(union.getLeft(), mode, priority, function, funId);
            return this.addPattern(union.getRight(), mode, priority, function, funId);
        }
        if (Double.isNaN(priority)) {
            priority = pattern.getPriority();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("add " + pattern.getNodeName() + " " + pattern + " fun:" + function + " mode:" + mode + " priority:" + priority);
        }
        Template template = new Template(pattern, mode, this._minImportance, this._importance, priority, this._templateCount++, function, funId);
        this.addTemplate(pattern.getNodeName(), template);
        return template;
    }

    private void addTemplate(String nodeName, Template template) {
        ArrayList<Template> templateList = this._templates.get(nodeName);
        if (templateList == null) {
            templateList = new ArrayList();
            this._templates.put(nodeName, templateList);
        }
        for (int i = templateList.size() - 1; i >= 0; --i) {
            Template item = templateList.get(i);
            if (template.compareTo(item) > 0) continue;
            templateList.add(i + 1, template);
            return;
        }
        templateList.add(0, template);
    }

    public AbstractPattern parseMatch(String pattern) throws XslParseException, IOException {
        throw new RuntimeException();
    }

    public AbstractPattern parseSelect(String pattern) throws IOException, XslParseException {
        throw new RuntimeException();
    }

    protected AbstractPattern parseSelect(String pattern, Node node) throws IOException, XslParseException {
        throw new UnsupportedOperationException();
    }

    public Expr parseExpr(String pattern) throws XslParseException {
        throw new UnsupportedOperationException();
    }

    XslParseException error(Exception e) {
        if (e.getMessage() != null) {
            return this.error(e.getMessage());
        }
        log.log(Level.WARNING, e.toString(), e);
        return this.error(e.toString());
    }

    XslParseException error(Node node, Exception e) {
        if (e.getMessage() != null) {
            return this.error(node, e.getMessage());
        }
        log.log(Level.WARNING, e.toString(), e);
        return this.error(e.toString());
    }

    XslParseException error(String message) {
        return new XslParseException(this._filename + ":" + this._line + ": " + message);
    }

    XslParseException error(Node node, String message) {
        if (!(node instanceof QAbstractNode)) {
            return this.error(message);
        }
        QAbstractNode qnode = (QAbstractNode)node;
        String filename = qnode.getFilename();
        int line = qnode.getLine();
        if (filename != null) {
            return new XslParseException(filename + ":" + line + ": " + message);
        }
        return this.error(message);
    }

    protected String getXslLocal(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        QElement elt = (QElement)node;
        String ns = elt.getNamespaceURI();
        String prefix = elt.getPrefix();
        if (ns == null || ns.equals("")) {
            return elt.getNodeName().startsWith("xsl:") ? elt.getNodeName().substring(4) : null;
        }
        if (ns.startsWith(XSLNS) && (ns.length() == XSLNS.length() || ns.charAt(XSLNS.length()) == '/')) {
            return elt.getLocalName();
        }
        return null;
    }

    protected String getXtpLocal(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        QElement elt = (QElement)node;
        String ns = elt.getNamespaceURI();
        String prefix = elt.getPrefix();
        if (ns == null || ns.equals("")) {
            return elt.getNodeName().startsWith("xtp:") ? elt.getNodeName().substring(4) : null;
        }
        if (ns.startsWith(XTPNS)) {
            return elt.getLocalName();
        }
        return null;
    }

    private Expr parseExpr(Node node, String expr) throws Exception {
        try {
            return XPath.parseExpr(expr, this._namespace, this._nodeListContext);
        }
        catch (Exception e) {
            throw this.error(node, e.getMessage());
        }
    }

    protected NamespaceContext addNamespace(Element elt) {
        NamespaceContext oldNamespace = this._namespace;
        for (Node attr = ((QElement)elt).getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            String name = attr.getNodeName();
            if (name.startsWith("xmlns:")) {
                name = name.substring(6);
            } else {
                if (!name.equals("xmlns")) continue;
                name = "";
            }
            String url = attr.getNodeValue();
            if (url.equals(XSLNS) || url.equals(XTPNS)) continue;
            if (url.startsWith("quote:")) {
                url = url.substring(6);
            }
            this._namespace = new NamespaceContext(this._namespace, name, url);
        }
        return oldNamespace;
    }

    void addDepend(Path depend) {
        if (depend != null) {
            this._depends.add(depend);
        }
    }

    protected abstract StylesheetImpl completeGenerate(ArrayList<XslNode> var1, ArrayList var2) throws Exception;

    public void close() throws IOException, XslParseException {
    }

    static {
        commaDelimScanner = new CharScanner(" \t\n\r,");
        _tags = new IntMap();
        _tags.put((Object)"stylesheet", 0);
        _tags.put((Object)"transform", 0);
        _tags.put((Object)"output", 1);
        _tags.put((Object)"template", 4);
        _tags.put((Object)"preserve-space", 6);
        _tags.put((Object)"strip-space", 5);
        _tags.put((Object)"import", 2);
        _tags.put((Object)"include", 3);
        _tags.put((Object)"key", 7);
        _tags.put((Object)"decimal-format", 8);
        _tags.put((Object)"attribute-set", 9);
        _tags.put((Object)"namespace-alias", 10);
        _tags.put((Object)"apply-templates", 11);
        _tags.put((Object)"apply-imports", 12);
        _tags.put((Object)"call-template", 13);
        _tags.put((Object)"param", 14);
        _tags.put((Object)"variable", 15);
        _tags.put((Object)"for-each", 18);
        _tags.put((Object)"if", 19);
        _tags.put((Object)"choose", 20);
        _tags.put((Object)"value-of", 16);
        _tags.put((Object)"copy-of", 17);
        _tags.put((Object)"text", 22);
        _tags.put((Object)"#text", 21);
        _tags.put((Object)"number", 23);
        _tags.put((Object)"copy", 24);
        _tags.put((Object)"element", 26);
        _tags.put((Object)"attribute", 27);
        _tags.put((Object)"pi", 28);
        _tags.put((Object)"processing-instruction", 28);
        _tags.put((Object)"comment", 29);
        _tags.put((Object)"message", 30);
        _tags.put((Object)"sort", 38);
        _tags.put((Object)"fallback", 38);
        _tags.put((Object)"result-document", 39);
        _xtpTags = new IntMap();
        _xtpTags.put((Object)"expression", 31);
        _xtpTags.put((Object)"expr", 31);
        _xtpTags.put((Object)"eval", 31);
        _xtpTags.put((Object)"scriptlet", 32);
        _xtpTags.put((Object)"script", 32);
        _xtpTags.put((Object)"decl", 33);
        _xtpTags.put((Object)"declaration", 33);
        _xtpTags.put((Object)"directive.cache", 34);
        _xtpTags.put((Object)"while", 36);
        _xtpTags.put((Object)"assign", 37);
    }
}

