/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.ExceptionWrapper;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Html;
import com.caucho.xml.Xml;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.StyleScript;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XslParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Xsl
extends AbstractStylesheetFactory {
    static final Logger log = Log.open(Xsl.class);

    protected Document parseXSL(ReadStream rs) throws TransformerConfigurationException {
        try {
            Xml parser = new Xml();
            return parser.parseDocument((InputStream)rs);
        }
        catch (Exception e) {
            throw new XslParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String xslName = "default.xsl";
        String dest = null;
        String suffix = null;
        String toc = "";
        int i = 0;
        String conf = CauchoSystem.getResinConfig();
        boolean isStrict = true;
        ArrayList<String> argList = new ArrayList<String>();
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        while (i < args.length) {
            if (args[i].equals("-xsl")) {
                xslName = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-lite") || args[i].equals("-stylescript")) {
                isStrict = false;
                ++i;
                continue;
            }
            if (args[i].equals("-o")) {
                dest = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-suffix")) {
                suffix = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].startsWith("-A")) {
                argList.add(args[i].substring(2));
                ++i;
                continue;
            }
            if (args[i].startsWith("-P")) {
                String value;
                String key;
                String v = args[i].substring(2);
                int p = v.indexOf(61);
                if (p >= 0) {
                    key = v.substring(0, p);
                    value = v.substring(p + 1);
                } else {
                    key = v;
                    value = "";
                }
                keyList.add(key);
                valueList.add(value);
                ++i;
                continue;
            }
            if (args[i].equals("-conf")) {
                conf = args[i + 1];
                i += 2;
                continue;
            }
            if (!args[i].equals("-h") && !args[i].equals("-help")) break;
            Xsl.usage();
            return;
        }
        Path destDir = null;
        if (dest != null) {
            destDir = Vfs.lookup(dest);
        } else if (suffix == null) {
            destDir = Vfs.lookup("stdout:");
        }
        if (args.length - i > 1 && (dest == null || destDir.isFile()) && suffix == null) {
            System.err.println("multiple sources require a destination directory");
            System.exit(1);
        }
        try {
            try {
                MergePath stylePath = new MergePath();
                stylePath.addMergePath(Vfs.lookup(xslName).getParent());
                stylePath.addMergePath(Vfs.lookup());
                stylePath.addMergePath(CauchoSystem.getResinHome().lookup("xsl"));
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader instanceof DynamicClassLoader) {
                    DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
                    String resourcePath = dynLoader.getResourcePathSpecificFirst();
                    stylePath.addClassPath(resourcePath);
                }
                Path[] scriptPath = new Path[]{Vfs.lookup(), Vfs.lookup(xslName).getParent(), CauchoSystem.getResinHome().lookup("scripts")};
                Path xslPath = stylePath.lookup(xslName);
                if (xslPath == null) {
                    System.out.println("can't find `" + xslName + "'");
                    System.exit(1);
                }
                AbstractStylesheetFactory xsl = isStrict ? new Xsl() : new StyleScript();
                xsl.setStylePath((Path)stylePath);
                Templates stylesheet = xsl.newTemplates(xslName);
                while (i < args.length) {
                    Object var36_42;
                    Object var26_30;
                    String name = args[i];
                    Path xmlPath = Vfs.lookup(name);
                    HashMap<String, Object> argMap = new HashMap<String, Object>();
                    String[] childArgs = new String[argList.size() + 1];
                    argList.toArray(childArgs);
                    childArgs[childArgs.length - 1] = name;
                    argMap.put("arguments", childArgs);
                    argMap.put("File", Vfs.lookup());
                    ReadStream is = xmlPath.openRead();
                    Document doc = null;
                    try {
                        if (isStrict) {
                            doc = new Xml().parseDocument((InputStream)is);
                        } else {
                            Html parser = new Html();
                            parser.setEntitiesAsText(true);
                            doc = parser.parseDocument((InputStream)is);
                        }
                        var26_30 = null;
                    }
                    catch (Throwable throwable) {
                        var26_30 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    Object result = null;
                    Path destPath = null;
                    destPath = dest != null ? Vfs.lookup(dest) : (suffix != null ? xmlPath.getParent() : Vfs.lookup("stdout:"));
                    if (suffix != null) {
                        int p = name.lastIndexOf(46);
                        if (p == -1) {
                            System.err.println("suffix missing for `" + name + "'");
                            System.exit(1);
                        }
                        String destName = name.substring(0, p);
                        if (dest == null && (p = destName.lastIndexOf(47)) >= 0) {
                            destName = destName.substring(p + 1);
                        }
                        if (!destPath.isFile()) {
                            destPath = destPath.lookup(destName + '.' + suffix);
                        } else {
                            System.err.println("illegal output combination");
                            System.exit(1);
                        }
                    } else if (destPath.isDirectory()) {
                        destPath = destPath.lookup(name);
                    }
                    try {
                        destPath.getParent().mkdirs();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    WriteStream os = destPath.openWrite();
                    try {
                        Properties output = stylesheet.getOutputProperties();
                        String encoding = (String)output.get("encoding");
                        String mimeType = (String)output.get("mime-type");
                        String method = (String)output.get("method");
                        if (!(encoding != null || method != null && method.equals("html"))) {
                            encoding = "UTF-8";
                        }
                        TransformerImpl transformer = (TransformerImpl)stylesheet.newTransformer();
                        if (encoding != null) {
                            os.setEncoding(encoding);
                        }
                        transformer.setProperty("caucho.pwd", Vfs.lookup());
                        for (int j = 0; j < keyList.size(); ++j) {
                            String key = (String)keyList.get(j);
                            String value = (String)valueList.get(j);
                            transformer.setParameter(key, value);
                        }
                        transformer.transform((Node)doc, (OutputStream)os);
                        var36_42 = null;
                    }
                    catch (Throwable throwable) {
                        var36_42 = null;
                        os.close();
                        throw throwable;
                    }
                    os.close();
                    ++i;
                }
                Object var38_44 = null;
            }
            catch (Throwable e) {
                while (e instanceof ExceptionWrapper && ((ExceptionWrapper)e).getRootCause() != null) {
                    e = ((ExceptionWrapper)e).getRootCause();
                }
                e.printStackTrace();
                Object var38_45 = null;
                System.exit(0);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var38_46 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    private static void usage() {
        System.err.println("xsl [-xsl stylesheet] file1 file2 ...");
        System.err.println(" -xsl stylesheet : select a stylesheet");
        System.err.println(" -o filename     : output filename/directory");
        System.err.println(" -suffix suffix  : replacement suffix");
        System.err.println(" -stylescript    : StyleScript");
        System.err.println(" -Pkey=value     : template parameter");
        System.err.println(" -h              : this help message");
    }
}

