/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.xml.DOMBuilder;
import com.caucho.xml.ExtendedLocator;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QElement;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlPrinter;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.PageContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XslWriter
extends Writer
implements ExtendedLocator {
    static final Logger log = Log.open(XslWriter.class);
    static final L10N L = new L10N(XslWriter.class);
    private static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final XMLWriter ATTR_WRITER = new DOMBuilder();
    private XMLWriter _xmlWriter;
    String _systemId;
    String _filename;
    int _line;
    int _tailLine;
    private IntArray flags = new IntArray();
    private CharBuffer _text = new CharBuffer();
    private String elementName;
    private String _attributeURL;
    private String _attributePrefix;
    private String _attributeLocalName;
    private String _attributeName;
    private ArrayList depends = new ArrayList();
    private boolean _isCacheable = true;
    private boolean _disableEscaping;
    private boolean generateLocation;
    private Document _document;
    private StylesheetImpl _stylesheet;
    private TransformerImpl _transformer;
    private HashMap<String, String> _cdataElements;
    private boolean isCdata;
    private HashMap<String, String> _namespaces;
    private ArrayList<String> _topNamespaces;
    private ArrayList<StackItem> _elementStack;
    private int _depth;
    private ExtendedLocator _locator = null;

    XslWriter(HashMap env, StylesheetImpl stylesheet, TransformerImpl transformer) {
        this._stylesheet = stylesheet;
        this._transformer = transformer;
        ArrayList cdata = stylesheet.getOutputFormat().getCdataSectionElements();
        if (cdata != null) {
            this._cdataElements = new HashMap();
            for (int i = 0; i < cdata.size(); ++i) {
                String element = (String)cdata.get(i);
                this._cdataElements.put(element, element);
            }
        }
    }

    void init(XMLWriter xmlWriter) {
        this._xmlWriter = xmlWriter;
        this._namespaces = new HashMap();
        this._topNamespaces = new ArrayList();
        this._elementStack = new ArrayList();
        this._document = null;
        this._locator = this;
        xmlWriter.setDocumentLocator(this._locator);
    }

    public TransformerImpl getTransformer() {
        return this._transformer;
    }

    boolean isCacheable() {
        return this._isCacheable;
    }

    ArrayList getDepends() {
        return this.depends;
    }

    public void setNotCacheable() {
        this._isCacheable = false;
    }

    public void addCacheDepend(Path path) {
        this._transformer.addCacheDepend(path);
    }

    public boolean isFlagFirst(int id) {
        while (this.flags.size() <= id) {
            this.flags.add(0);
        }
        int value = this.flags.get(id);
        this.flags.set(id, 1);
        return value == 0;
    }

    public void write(int ch) {
        this._text.append((char)ch);
    }

    public void write(byte[] buf, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write(buf[offset + i]);
        }
    }

    public void write(char[] buf, int offset, int length) {
        this._text.append(buf, offset, length);
    }

    public void print(String string) {
        if (string == null) {
            this._text.append("null");
            return;
        }
        this._text.append(string);
    }

    public void print(boolean b) {
        this._text.append(b);
    }

    public void print(char ch) {
        this._text.append(ch);
    }

    public void print(int i) {
        this._text.append(i);
    }

    public void print(long l) {
        this._text.append(l);
    }

    public void print(float f) {
        this._text.append(f);
    }

    public void print(double d) {
        this._text.append(d);
    }

    public void print(Object o) {
        this._text.append(o);
    }

    public void println() {
        this._text.append('\n');
        ++this._tailLine;
    }

    public void println(boolean b) {
        this._text.append(b);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(char ch) {
        this.print(ch);
        this.println();
    }

    public void println(int i) {
        this._text.append(i);
        this.println();
    }

    public void println(long l) {
        this._text.append(l);
        this.println();
    }

    public void println(double d) {
        this._text.append(d);
        this.println();
    }

    public void println(float f) {
        this._text.append(f);
        this.println();
    }

    public void println(Object o) {
        this._text.append(o);
        this.println();
    }

    public void flush() {
    }

    public void close() throws IOException {
        try {
            for (int i = 0; i < this._topNamespaces.size(); ++i) {
                String topPrefix = this._topNamespaces.get(i);
                String topUrl = this._namespaces.get(topPrefix);
                if (topPrefix.equals("")) {
                    this._xmlWriter.endPrefixMapping(null);
                    continue;
                }
                this._xmlWriter.endPrefixMapping(topPrefix);
            }
            this.popText();
            this._xmlWriter.endDocument();
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public boolean getDisableEscaping() {
        return this._disableEscaping;
    }

    public boolean disableEscaping(boolean disable) throws IOException, SAXException {
        if (disable != this._disableEscaping) {
            this.popText();
            this._xmlWriter.setEscapeText(!disable);
        }
        boolean old = this._disableEscaping;
        this._disableEscaping = disable;
        return old;
    }

    public void setLocation(String systemId, String filename, int line) throws IOException, SAXException {
        if (filename == null || !filename.equals(this._filename) || line != this._tailLine) {
            this.popText();
        }
        this._systemId = systemId;
        this._filename = filename;
        this._line = line;
        this._tailLine = line;
    }

    public void pushElement(String name) throws IOException, SAXException {
        this.popText();
        int p = name.lastIndexOf(58);
        String local = p > 0 ? name.substring(p + 1) : name;
        this.startElement(null, null, local, name);
    }

    public void pushElement(String name, NamespaceContext namespace) throws IOException, SAXException {
        this.popText();
        int p = name.indexOf(58);
        if (p <= 0) {
            this.startElement(null, null, name, name);
            return;
        }
        String prefix = name.substring(0, p);
        String url = NamespaceContext.find(namespace, prefix);
        if (url != null) {
            this.startElement(url, prefix, name.substring(p + 1), name);
        } else {
            this.startElement(null, null, name, name);
        }
    }

    public void pushElementNs(String name, String url) throws IOException, SAXException {
        this.popText();
        int p = name.indexOf(58);
        if (p <= 0) {
            this.startElement(url, "", name, name);
            return;
        }
        String prefix = name.substring(0, p);
        String local = name.substring(p + 1);
        this.startElement(url, prefix, local, name);
    }

    public void pushElement(String url, String prefix, String local, String name) throws IOException, SAXException {
        this.popText();
        this.startElement(url, prefix, local, name);
    }

    public XMLWriter pushAttribute(String name) throws IOException, SAXException {
        this.popText();
        XMLWriter oldWriter = this._xmlWriter;
        this._xmlWriter = ATTR_WRITER;
        this._attributeURL = null;
        this._attributePrefix = null;
        this._attributeLocalName = null;
        this._attributeName = name;
        return oldWriter;
    }

    public XMLWriter pushAttribute(String name, NamespaceContext namespace) throws IOException, SAXException {
        String url;
        this.popText();
        XMLWriter oldWriter = this._xmlWriter;
        this._xmlWriter = ATTR_WRITER;
        int p = name.indexOf(58);
        String prefix = null;
        if (p > 0) {
            prefix = name.substring(0, p);
        }
        if ((url = NamespaceContext.find(namespace, prefix)) != null) {
            this._attributeURL = url;
            this._attributePrefix = prefix;
            this._attributeLocalName = name.substring(p + 1);
            this._attributeName = name;
        } else {
            this._attributeURL = null;
            this._attributePrefix = null;
            this._attributeLocalName = null;
            this._attributeName = name;
        }
        return oldWriter;
    }

    public XMLWriter pushAttributeNs(String name, String url) throws IOException, SAXException {
        this.popText();
        XMLWriter oldWriter = this._xmlWriter;
        this._xmlWriter = ATTR_WRITER;
        int p = name.indexOf(58);
        String prefix = null;
        String local = name;
        if (p > 0) {
            prefix = name.substring(0, p);
            local = name.substring(p + 1);
        }
        this._attributeURL = url;
        this._attributePrefix = prefix;
        this._attributeLocalName = local;
        this._attributeName = name;
        return oldWriter;
    }

    public XMLWriter pushAttribute(String prefix, String local, String url) throws IOException, SAXException {
        this.popText();
        XMLWriter oldWriter = this._xmlWriter;
        this._xmlWriter = ATTR_WRITER;
        this._attributeURL = url;
        this._attributePrefix = prefix;
        this._attributeLocalName = local;
        this._attributeName = prefix != null && !prefix.equals("") ? prefix + ":" + local : local;
        return oldWriter;
    }

    public void setAttribute(String prefix, String local, String url, String value) throws IOException, SAXException {
        this.popText();
        String attributeName = prefix != null && !prefix.equals("") ? prefix + ":" + local : local;
        this.attribute(url, prefix, local, attributeName, value);
    }

    public void setAttribute(String name, NamespaceContext namespace, String value) throws IOException, SAXException {
        String url;
        this.popText();
        int p = name.indexOf(58);
        String prefix = null;
        if (p > 0) {
            prefix = name.substring(0, p);
        }
        if ((url = NamespaceContext.find(namespace, prefix)) != null) {
            this.attribute(url, prefix, name.substring(p + 1), name, value);
        } else {
            this.attribute(null, null, null, name, value);
        }
    }

    public void popAttribute(XMLWriter writer) throws IOException, SAXException {
        this._xmlWriter = writer;
        this.attribute(this._attributeURL, this._attributePrefix, this._attributeLocalName, this._attributeName, this._text.toString());
        this._text.clear();
        this._attributeName = null;
    }

    public void setAttribute(String name, String value) throws IOException, SAXException {
        this.attribute(null, null, name, name, value);
    }

    public void pushCopy(Node copyNode) throws IOException, SAXException {
        this.popText();
        switch (copyNode.getNodeType()) {
            case 2: {
                Node oldNode = copyNode;
                this.attribute(oldNode.getNamespaceURI(), oldNode.getPrefix(), oldNode.getLocalName(), oldNode.getNodeName(), oldNode.getNodeValue());
                break;
            }
            case 9: {
                return;
            }
            case 1: {
                Element oldElt = (Element)copyNode;
                this.startElement(oldElt.getNamespaceURI(), oldElt.getPrefix(), oldElt.getLocalName(), oldElt.getNodeName());
                break;
            }
            case 8: {
                this._xmlWriter.comment(((Comment)copyNode).getData());
                break;
            }
            case 3: {
                this._text.append(((Text)copyNode).getData());
                break;
            }
            case 7: {
                ProcessingInstruction oldPi = (ProcessingInstruction)copyNode;
                this._xmlWriter.processingInstruction(oldPi.getNodeName(), oldPi.getNodeValue());
            }
        }
    }

    public void popCopy(Node copyNode) throws IOException, SAXException {
        if (copyNode.getNodeType() == 1) {
            this.popText();
            this.popElement();
        }
    }

    public void pushPi() throws IOException, SAXException {
        this.popText();
    }

    public void popPi(String name) throws IOException, SAXException {
        this._xmlWriter.processingInstruction(name, this._text.toString());
        this._text.clear();
    }

    public void pushComment() throws IOException, SAXException {
        this.popText();
    }

    public void popComment() throws IOException, SAXException {
        this._xmlWriter.comment(this._text.toString());
        this._text.clear();
    }

    public XMLWriter pushFragment() throws IOException, SAXException {
        this.popText();
        DOMBuilder domBuilder = new DOMBuilder();
        if (this._document == null) {
            this._document = Xml.createDocument();
        }
        domBuilder.init(this._document.createDocumentFragment());
        domBuilder.setDocumentLocator(this._locator);
        XMLWriter oldWriter = this._xmlWriter;
        this._xmlWriter = domBuilder;
        return oldWriter;
    }

    public Node popFragment(XMLWriter oldWriter) throws IOException, SAXException {
        this.popText();
        DOMBuilder domBuilder = (DOMBuilder)this._xmlWriter;
        this._xmlWriter = oldWriter;
        domBuilder.endDocument();
        Node node = domBuilder.getNode();
        return node;
    }

    public void valueOf(Object node) throws IOException, SAXException {
        if (node == null) {
            return;
        }
        if (node instanceof Element || node instanceof DocumentFragment) {
            Node elt = (Node)node;
            for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.elementValueOf(child);
            }
        } else if (node instanceof Text) {
            String data = ((Text)node).getNodeValue();
            for (int i = 0; i < data.length(); ++i) {
                if (XmlChar.isWhitespace(data.charAt(i))) continue;
                this.print(data);
                return;
            }
            this.print(data);
        } else if (node instanceof Node) {
            this.print(((QAbstractNode)node).getNodeValue());
        } else if (node instanceof NodeList) {
            NodeList list = (NodeList)node;
            Node value = list.item(0);
            if (value != null) {
                this.valueOf(value);
            }
        } else if (node instanceof ArrayList) {
            ArrayList list = (ArrayList)node;
            if (list.size() > 0) {
                this.valueOf(list.get(0));
            }
        } else if (node instanceof Iterator) {
            Iterator list = (Iterator)node;
            this.valueOf(list.next());
        } else if (node instanceof Double) {
            Double d = (Double)node;
            double dValue = d;
            if ((double)((int)dValue) == dValue) {
                this.print((int)dValue);
            } else {
                this.print(dValue);
            }
        } else {
            this.print(node);
        }
    }

    private void elementValueOf(Node node) throws IOException, SAXException {
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            Element elt = (Element)node;
            for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.elementValueOf(child);
            }
        } else if (node instanceof Text) {
            String data = ((Text)node).getNodeValue();
            for (int i = 0; i < data.length(); ++i) {
                if (XmlChar.isWhitespace(data.charAt(i))) continue;
                this.print(data);
                return;
            }
            this.print(data);
        }
    }

    public void copyOf(Object value) throws IOException, SAXException, XPathException {
        this.popText();
        if (value instanceof NodeList) {
            NodeList list = (NodeList)value;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = list.item(i);
                this.copyOf(child);
            }
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            for (int i = 0; i < list.size(); ++i) {
                Node child = (Node)list.get(i);
                this.copyOf(child);
            }
        } else if (value instanceof Iterator) {
            Iterator iter = (Iterator)value;
            while (iter.hasNext()) {
                Node child = (Node)iter.next();
                this.copyOf(child);
            }
        } else if (value instanceof Attr) {
            Attr child = (Attr)value;
            this.attribute(child.getNamespaceURI(), child.getPrefix(), child.getLocalName(), child.getNodeName(), child.getNodeValue());
        } else if (value instanceof QElement) {
            Node subNode;
            QElement child = (QElement)value;
            String oldSystemId = this._systemId;
            String oldFilename = this._filename;
            int oldLine = this._line;
            this._systemId = child.getBaseURI();
            this._filename = child.getFilename();
            this._line = child.getLine();
            this.startElement(child.getNamespaceURI(), child.getPrefix(), child.getLocalName(), child.getNodeName());
            for (subNode = child.getFirstAttribute(); subNode != null; subNode = subNode.getNextSibling()) {
                QAttr attr = (QAttr)subNode;
                this.attribute(attr.getNamespaceURI(), attr.getPrefix(), attr.getLocalName(), attr.getNodeName(), attr.getNodeValue());
            }
            for (subNode = child.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                this.copyOf(subNode);
            }
            this.popElement();
            this._systemId = oldSystemId;
            this._filename = oldFilename;
            this._line = oldLine;
        } else if (value instanceof DocumentFragment) {
            for (Node subNode = ((Node)value).getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                this.copyOf(subNode);
            }
        } else if (value instanceof Text) {
            Text child = (Text)value;
            this._text.append(child.getNodeValue());
        } else if (value instanceof Comment) {
            Comment child = (Comment)value;
            this._xmlWriter.comment(child.getNodeValue());
        } else if (value instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)value;
            this._xmlWriter.processingInstruction(pi.getNodeName(), pi.getNodeValue());
        } else if (value instanceof EntityReference) {
            EntityReference child = (EntityReference)value;
            this._text.append("&" + child.getNodeName() + ";");
        } else if (value instanceof Node) {
            Node child = (Node)value;
            this._text.append(child.getNodeValue());
        } else {
            this.print(Expr.toString(value));
        }
    }

    public void addNamespace(String prefix, String url) {
        if (!url.equals("")) {
            this._namespaces.put(prefix, url);
            this._topNamespaces.add(prefix);
        }
    }

    void startElement(String url, String prefix, String local, String qName) throws IOException, SAXException {
        if (this._attributeName != null) {
            throw this.error(L.l("element `{0}' is not allowed inside attribute `{1}'.  xsl:attribute must contain text only.", (Object)qName, (Object)this._attributeName));
        }
        this.popText();
        StackItem item = null;
        if (this._elementStack.size() <= this._depth) {
            item = new StackItem();
            this._elementStack.add(item);
        } else {
            item = this._elementStack.get(this._depth);
        }
        item.init(url, prefix, local, qName, this.isCdata);
        if (this._cdataElements != null && this._cdataElements.get(qName) != null) {
            this.isCdata = true;
        }
        ++this._depth;
        this._xmlWriter.startElement(url, local, qName);
        if (this._depth == 1) {
            for (int i = 0; i < this._topNamespaces.size(); ++i) {
                String topPrefix = this._topNamespaces.get(i);
                String topUrl = this._namespaces.get(topPrefix);
                if (topPrefix.equals("")) {
                    this._xmlWriter.startPrefixMapping(null, topUrl);
                    this._xmlWriter.attribute(XMLNS, null, "xmlns", topUrl);
                    continue;
                }
                this._xmlWriter.startPrefixMapping(topPrefix, topUrl);
                this._xmlWriter.attribute(XMLNS, topPrefix, "xmlns:" + topPrefix, topUrl);
            }
        }
        if (url == null) {
            return;
        }
        this.bindNamespace(prefix, url);
    }

    public void popElement() throws IOException, SAXException {
        this.popText();
        --this._depth;
        StackItem item = this._elementStack.get(this._depth);
        try {
            this._xmlWriter.endElement(item.getNamespace(), item.getLocalName(), item.getName());
            for (int i = 0; i < item.nsSize(); ++i) {
                String oldPrefix = item.getNSPrefix(i);
                String oldUrl = item.getNSUrl(i);
                if (oldUrl == null) {
                    this._namespaces.remove(oldPrefix);
                } else {
                    this._namespaces.put(oldPrefix, oldUrl);
                }
                this._xmlWriter.endPrefixMapping(oldPrefix);
            }
            this.isCdata = item.getCdata();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void attribute(String url, String prefix, String local, String qName, String value) throws IOException, SAXException {
        if (qName.startsWith("xmlns:")) {
            this.bindNamespace(qName.substring("xmlns:".length()), value);
        } else if (qName.equals("xmlns")) {
            this.bindNamespace(null, value);
        } else {
            this._xmlWriter.attribute(url, local, qName, value);
            if (url != null && !url.equals("") && !prefix.equals("")) {
                this.bindNamespace(prefix, url);
            }
        }
    }

    public void attribute(String qName, String value) throws IOException, SAXException {
        this._xmlWriter.attribute(null, null, qName, value);
    }

    public void bindNamespace(String prefix, String url) throws IOException, SAXException {
        String oldUrl = this._namespaces.get(prefix);
        if (oldUrl == null && url.equals("") || oldUrl != null && url.equals(oldUrl)) {
            return;
        }
        if (prefix != null) {
            this._xmlWriter.startPrefixMapping(prefix, url);
            this._xmlWriter.attribute(XMLNS, prefix, "xmlns:" + prefix, url);
            this._namespaces.put(prefix, url);
        } else {
            this._xmlWriter.startPrefixMapping(null, url);
            this._xmlWriter.attribute(XMLNS, null, "xmlns", url);
            this._namespaces.put(null, url);
        }
        StackItem item = this._elementStack.get(this._depth - 1);
        item.addNamespace(prefix, oldUrl);
    }

    public void popText() throws IOException, SAXException {
        if (this._xmlWriter == ATTR_WRITER) {
            return;
        }
        Object textNode = null;
        if (this._text.length() == 0) {
            return;
        }
        if (this._filename != null) {
            this._line = this._tailLine;
        }
        if (this.isCdata) {
            this._xmlWriter.cdata(this._text.getBuffer(), 0, this._text.getLength());
        } else {
            this._xmlWriter.text(this._text.getBuffer(), 0, this._text.getLength());
        }
        this._text.clear();
    }

    public Object getProperty(String name) {
        return this._transformer.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this._transformer.setProperty(name, value);
    }

    public void removeProperty(String name) {
    }

    public Iterator getPropertyNames() {
        return null;
    }

    public Object getParameter(String name) {
        return this._transformer.getParameter(name);
    }

    public Path getPwd() {
        return (Path)this.getProperty("caucho.pwd");
    }

    public OutputStream openWrite(ExprEnvironment env, String href) throws IOException {
        XmlPrinter printer;
        Path path;
        if (this._xmlWriter instanceof XmlPrinter && (path = (printer = (XmlPrinter)this._xmlWriter).getPath()) != null) {
            Path dst = path.getParent().lookup(href);
            dst.getParent().mkdirs();
            return dst.openWrite();
        }
        Path stylesheetPath = env.getStylesheetEnv().getPath();
        return stylesheetPath.getParent().lookup(href).openWrite();
    }

    public XslWriter openResultDocument(OutputStream os) throws IOException, SAXException {
        XmlPrinter writer = new XmlPrinter(os);
        XslWriter out = new XslWriter(null, this._stylesheet, this._transformer);
        out.init(writer);
        writer.startDocument();
        return out;
    }

    public PageContext getPage() {
        return (PageContext)this.getProperty("caucho.page.context");
    }

    private IOException error(String message) {
        if (this._filename != null) {
            return new IOException(this._filename + ":" + this._line + ": " + message);
        }
        return new IOException(message);
    }

    public String getSystemId() {
        if (this._systemId != null) {
            return this._systemId;
        }
        return this._filename;
    }

    public String getFilename() {
        if (this._filename != null) {
            return this._filename;
        }
        return this._systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this._line;
    }

    public int getColumnNumber() {
        return 0;
    }

    static class StackItem {
        String _url;
        String _prefix;
        String _local;
        String _qName;
        boolean _isCdata;
        ArrayList<String> _nsPrefixes;
        ArrayList<String> _nsUrls;

        StackItem() {
        }

        void clear() {
        }

        void init(String url, String prefix, String local, String qName, boolean isCdata) {
            if (this._nsPrefixes != null) {
                this._nsPrefixes.clear();
                this._nsUrls.clear();
            }
            this._url = url;
            this._prefix = prefix;
            this._local = local;
            this._qName = qName;
            this._isCdata = isCdata;
        }

        String getNamespace() {
            return this._url;
        }

        String getPrefix() {
            return this._prefix;
        }

        String getLocalName() {
            return this._local;
        }

        String getName() {
            return this._qName;
        }

        boolean getCdata() {
            return this._isCdata;
        }

        int nsSize() {
            return this._nsPrefixes == null ? 0 : this._nsPrefixes.size();
        }

        String getNSPrefix(int i) {
            return this._nsPrefixes.get(i);
        }

        String getNSUrl(int i) {
            return this._nsUrls.get(i);
        }

        void addNamespace(String prefix, String oldUrl) {
            if (this._nsPrefixes == null) {
                this._nsPrefixes = new ArrayList();
                this._nsUrls = new ArrayList();
            }
            this._nsPrefixes.add(prefix);
            this._nsUrls.add(oldUrl);
        }
    }
}

