/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xpath.Expr;
import com.caucho.xsl.Sort;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;

public class XslSort
extends XslNode {
    private String _select;
    private String _lang;
    private String _order;
    private String _caseOrder;
    private String _dataType;

    public String getTagName() {
        return "xsl:sort";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("select")) {
            this._select = value;
            return;
        } else if (name.getName().equals("case-order")) {
            if (!value.equals("upper-first") && !value.equals("lower-first")) throw this.error(L.l("'{0}' is not a valid case-order for xsl:sort.", (Object)value));
            this._caseOrder = value;
            return;
        } else if (name.getName().equals("order")) {
            this._order = value;
            return;
        } else if (name.getName().equals("data-type")) {
            this._dataType = value;
            return;
        } else if (name.getName().equals("xsl:lang") || name.getName().equals("lang")) {
            this._lang = value;
            return;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
        if (this._select == null) {
            throw this.error(L.l("<xsl:sort> requires a 'select' attribute."));
        }
    }

    public Sort generateSort() throws Exception {
        Sort sort;
        boolean isText;
        Expr expr = this.parseExpr(this._select);
        Expr isAscending = this.constructBoolean(this._order, "ascending");
        Expr caseOrder = this.constructBoolean(this._caseOrder, "upper-first");
        if (this._caseOrder == null) {
            caseOrder = null;
        }
        boolean bl = isText = !"number".equals(this._dataType);
        if (this._lang == null) {
            sort = Sort.create(expr, isAscending, isText);
        } else {
            String lang = this._lang;
            lang = lang.startsWith("{") && lang.endsWith("}") ? lang.substring(1, lang.length() - 1) : "'" + lang + "'";
            sort = Sort.create(expr, isAscending, this.parseExpr(lang));
        }
        sort.setCaseOrder(caseOrder);
        return sort;
    }

    private Expr constructBoolean(String test, String match) throws XslParseException {
        if (test == null) {
            return this.parseExpr("true()");
        }
        if (test.startsWith("{") && test.endsWith("}")) {
            test = test.substring(1, test.length() - 1);
            return this.parseExpr(test + " = '" + match + "'");
        }
        if (test.equals(match)) {
            return this.parseExpr("true()");
        }
        return this.parseExpr("false()");
    }

    public void generate(JavaWriter out) throws Exception {
        throw this.error(L.l("<xsl:sort> must be a child of <xsl:for-each> or <xsl:apply-templates>"));
    }
}

