/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.profile.Profile;
import com.caucho.profile.ProfileEntry;
import com.caucho.profile.StackEntry;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfileAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(ProfileAction.class.getName());
    private static final L10N L = new L10N(ProfileAction.class);
    private AtomicLong _cancelledTime = new AtomicLong(-1L);
    private boolean _isProfileDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this._cancelledTime.compareAndSet(-1L, CurrentTime.getCurrentTime());
        ProfileAction profileAction = this;
        synchronized (profileAction) {
            this.notify();
        }
        Profile profile = Profile.createProfile();
        if (profile != null) {
            profile.stop();
        }
    }

    public void start(long samplingRate, int depth) {
        Profile profile = Profile.createProfile();
        profile.stop();
        profile.setPeriod(samplingRate);
        profile.setDepth(depth);
        profile.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(long activeTime, long samplingRate, int depth) throws ConfigException {
        if (activeTime <= 0L) {
            throw new IllegalArgumentException(L.l("Profile activeTime '{0}': must be > 0.", activeTime));
        }
        Profile profile = null;
        try {
            if (!this._isProfileDisabled) {
                profile = Profile.createProfile();
            }
        }
        catch (Throwable e) {
            this._isProfileDisabled = true;
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
        }
        if (profile == null) {
            return null;
        }
        if (profile.isActive()) {
            throw new ConfigException(L.l("Profile is still active"));
        }
        long startedAt = CurrentTime.getCurrentTime();
        this.start(samplingRate, depth);
        try {
            ProfileAction profileAction = this;
            synchronized (profileAction) {
                this.wait(activeTime);
            }
        }
        catch (InterruptedException e) {
            this._cancelledTime.compareAndSet(-1L, CurrentTime.getCurrentTime());
        }
        profile.stop();
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        ProfileEntry[] entries = profile.getResults();
        if (entries == null || entries.length == 0) {
            out.println("Profile returned no entries.");
        } else {
            ProfileEntry entry;
            int i;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            long cancelledTime = this._cancelledTime.get();
            if (cancelledTime < 0L) {
                out.print(L.l("Profile started at {0}. Active for a total of {1}ms.", (Object)dateFormat.format(new Date(startedAt)), (Object)activeTime));
            } else {
                long et = cancelledTime - startedAt;
                out.print(L.l("Profile started at {0}, cancelled at {1}. Active for a total of {2}ms.", (Object)dateFormat.format(new Date(startedAt)), (Object)dateFormat.format(new Date(cancelledTime)), (Object)et));
            }
            out.println(L.l(" Sampling rate {0}ms. Depth {1}.", (Object)samplingRate, (Object)String.valueOf(depth)));
            double totalTicks = 0.0;
            for (ProfileEntry entry2 : entries) {
                totalTicks += (double)entry2.getCount();
            }
            double sampleTicks = profile.getTicks();
            double totalPercent = 0.0;
            out.println(" ref# |   % time   |time self(s)|   % sum    | Method Call");
            for (i = 0; i < entries.length; ++i) {
                entry = entries[i];
                double timePercent = 100.0 * (double)entry.getCount() / sampleTicks;
                double d = 100.0 * (double)entry.getCount() / totalTicks;
                out.println(String.format(" %4d | %10.3f | %10.3f | %10.3f | %s", i, timePercent, (double)((float)entry.getCount() * (float)samplingRate) * 0.001, totalPercent += d, entry.getDescription()));
            }
            for (i = 0; i < entries.length; ++i) {
                entry = entries[i];
                out.print(String.format(" %4d ", i));
                out.println(" " + entry.getDescription());
                ArrayList<? extends StackEntry> stackEntries = entry.getStackTrace();
                for (StackEntry stackEntry : stackEntries) {
                    out.println("         " + stackEntry.getDescription());
                }
            }
        }
        out.flush();
        return buffer.toString();
    }

    public String jsonProfile() {
        Profile profile = Profile.createProfile();
        if (profile == null) {
            return null;
        }
        ProfileEntry[] entries = profile.getResults();
        if (entries == null || entries.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long timestamp = CurrentTime.getCurrentTime();
        sb.append("{\n");
        sb.append("  \"create_time\": \"" + new Date(timestamp) + "\"");
        sb.append(",\n  \"timestamp\": " + timestamp);
        sb.append(",\n  \"ticks\" : " + profile.getTicks());
        sb.append(",\n  \"depth\" : " + profile.getDepth());
        sb.append(",\n  \"period\" : " + profile.getPeriod());
        sb.append(",\n  \"end_time\" : " + profile.getEndTime());
        sb.append(",\n  \"gc_time\" : " + profile.getGcTime());
        sb.append(",\n  \"profile\" :  [\n");
        for (int i = 0; i < entries.length; ++i) {
            if (i != 0) {
                sb.append(",\n");
            }
            this.jsonEntry(sb, entries[i]);
        }
        sb.append("\n  ]");
        sb.append("\n}");
        return sb.toString();
    }

    private void jsonEntry(StringBuilder sb, ProfileEntry entry) {
        sb.append("{");
        sb.append("\n  \"name\" : \"");
        this.escapeString(sb, entry.getDescription());
        sb.append("\"");
        sb.append(",\n  \"ticks\" : " + entry.getCount());
        sb.append(",\n  \"state\" : \"" + entry.getState() + "\"");
        if (entry.getStackTrace() != null && entry.getStackTrace().size() > 0) {
            this.jsonStackTrace(sb, entry.getStackTrace());
        }
        sb.append("\n}");
    }

    private void jsonGc(StringBuilder sb, long ticks) {
        sb.append("{");
        sb.append("\n  \"name\" : \"HeapMemory.gc\"");
        sb.append(",\n  \"ticks\" : " + ticks);
        sb.append(",\n  \"state\" : \"RUNNABLE\"");
        sb.append("\n}");
    }

    private void jsonStackTrace(StringBuilder sb, ArrayList<? extends StackEntry> stack) {
        sb.append(",\n  \"stack\" : ");
        sb.append("[\n");
        int size = stack.size();
        for (int i = 0; i < size; ++i) {
            StackEntry entry = stack.get(i);
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append("  {");
            sb.append("\n    \"class\" : \"" + entry.getClassName() + "\"");
            sb.append(",\n    \"method\" : \"" + entry.getMethodName() + "\"");
            if (entry.getArg() != null && !"".equals(entry.getArg())) {
                sb.append(",\n    \"arg\" : \"");
                this.escapeString(sb, entry.getArg());
                sb.append("\"");
            }
            sb.append("\n  }");
        }
        sb.append("\n  ]");
    }

    private void escapeString(StringBuilder sb, String value) {
        if (value == null) {
            return;
        }
        int len = value.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }
}

