/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractConfig;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.ColumnConfig;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.EnumType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.util.HashSet;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;

class BasicConfig
extends AbstractConfig {
    private static final L10N L = new L10N(BasicConfig.class);
    private static HashSet<String> _basicTypes = new HashSet();
    private BaseConfigIntrospector _introspector;
    private AmberBeanType _sourceType;
    private AccessibleObject _field;
    private String _fieldName;
    private Class _fieldType;
    private String _name;
    private FetchType _fetch = FetchType.EAGER;
    private boolean _isOptional = true;
    private ColumnConfig _column;
    private String _lob;
    private TemporalType _temporal;
    private javax.persistence.EnumType _enumerated;

    BasicConfig(BaseConfigIntrospector introspector, AmberBeanType sourceType, AccessibleObject field, String fieldName, Class fieldType) {
        this._introspector = introspector;
        this._sourceType = sourceType;
        this._field = field;
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        this.introspect();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public FetchType getFetch() {
        return this._fetch;
    }

    public void setFetch(String fetch) {
        this._fetch = FetchType.valueOf((String)fetch);
    }

    public boolean isFetchLazy() {
        return this._fetch == FetchType.LAZY;
    }

    public boolean getOptional() {
        return this._isOptional;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public ColumnConfig getColumn() {
        return this._column;
    }

    public void setColumn(ColumnConfig column) {
        this._column = column;
    }

    public String getLob() {
        return this._lob;
    }

    public void setLob(String lob) {
        this._lob = lob;
    }

    public TemporalType getTemporal() {
        return this._temporal;
    }

    public void setTemporal(String temporal) {
        this._temporal = TemporalType.valueOf((String)temporal);
    }

    public javax.persistence.EnumType getEnumerated() {
        return this._enumerated;
    }

    public void setEnumerated(String enumerated) {
        this._enumerated = javax.persistence.EnumType.valueOf((String)enumerated);
    }

    private void introspect() throws ConfigException {
        Enumerated enumeratedAnn;
        Column columnAnn;
        if (!_basicTypes.contains(this._fieldType.getName()) && !Serializable.class.isAssignableFrom(this._fieldType)) {
            throw BasicConfig.error(this._field, L.l("{0} is an invalid @Basic type for {1}.", (Object)this._fieldType, (Object)this._fieldName));
        }
        Basic basicAnn = this._field.getAnnotation(Basic.class);
        if (basicAnn != null) {
            this._fetch = basicAnn.fetch();
            this._isOptional = basicAnn.optional();
        }
        this._column = (columnAnn = this._field.getAnnotation(Column.class)) != null ? new ColumnConfig(columnAnn) : new ColumnConfig();
        if (this._column.getName().equals("")) {
            this._column.setName(BasicConfig.toSqlName(this._fieldName));
        }
        if ((enumeratedAnn = this._field.getAnnotation(Enumerated.class)) != null) {
            this._enumerated = enumeratedAnn.value();
        }
    }

    @Override
    public void complete() {
        AmberType amberType;
        PropertyField property = new PropertyField(this._sourceType, this._fieldName);
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        if (this._enumerated == null) {
            amberType = persistenceUnit.createType(this._fieldType);
        } else {
            EnumType enumType = persistenceUnit.createEnum(this._fieldType.getName(), this._fieldType);
            enumType.setOrdinal(this._enumerated == javax.persistence.EnumType.ORDINAL);
            amberType = enumType;
        }
        property.setType(amberType);
        property.setLazy(this.isFetchLazy());
        AmberColumn fieldColumn = this.createColumn(amberType);
        property.setColumn(fieldColumn);
        this._sourceType.addField(property);
    }

    private AmberColumn createColumn(AmberType amberType) throws ConfigException {
        String name = this._column.getName();
        AmberColumn column = null;
        if (this._sourceType instanceof EntityType) {
            AmberTable table;
            EntityType entityType = (EntityType)this._sourceType;
            String tableName = this._column.getTable();
            if (tableName.equals("")) {
                table = entityType.getTable();
                if (table == null) {
                    throw BasicConfig.error(this._field, L.l("{0} @Column(name='{1}') is an unknown table.", (Object)this._fieldName, (Object)name));
                }
            } else {
                table = entityType.getSecondaryTable(tableName);
                if (table == null) {
                    throw BasicConfig.error(this._field, L.l("{0} @Column(table='{1}') is an unknown secondary table.", (Object)this._fieldName, (Object)tableName));
                }
            }
            column = table.createColumn(name, amberType);
        } else {
            column = new AmberColumn(null, name, amberType);
        }
        column.setUnique(this._column.isUnique());
        column.setNotNull(!this._column.isNullable());
        if (!"".equals(this._column.getColumnDefinition())) {
            column.setSQLType(this._column.getColumnDefinition());
        }
        column.setLength(this._column.getLength());
        int precision = this._column.getPrecision();
        if (precision < 0) {
            throw BasicConfig.error(this._field, L.l("{0} @Column precision cannot be less than 0.", (Object)this._fieldName));
        }
        int scale = this._column.getScale();
        if (scale < 0) {
            throw BasicConfig.error(this._field, L.l("{0} @Column scale cannot be less than 0.", (Object)this._fieldName));
        }
        if (precision < scale) {
            throw BasicConfig.error(this._field, L.l("{0} @Column scale cannot be greater than precision. Must set precision to a non-zero value before setting scale.", (Object)this._fieldName));
        }
        if (precision > 0) {
            column.setPrecision(precision);
            column.setScale(scale);
        }
        return column;
    }

    static {
        _basicTypes.add("boolean");
        _basicTypes.add("byte");
        _basicTypes.add("char");
        _basicTypes.add("short");
        _basicTypes.add("int");
        _basicTypes.add("long");
        _basicTypes.add("float");
        _basicTypes.add("double");
        _basicTypes.add("[byte");
        _basicTypes.add("[char");
        _basicTypes.add("[java.lang.Byte");
        _basicTypes.add("[java.lang.Character");
    }
}

