/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.AmberTableCache;
import com.caucho.amber.cfg.AbstractEnhancedConfig;
import com.caucho.amber.cfg.AmberConfigManager;
import com.caucho.amber.cfg.AttributeOverrideCompletion;
import com.caucho.amber.cfg.AttributeOverrideConfig;
import com.caucho.amber.cfg.AttributesConfig;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.ColumnConfig;
import com.caucho.amber.cfg.DiscriminatorColumnConfig;
import com.caucho.amber.cfg.EmbeddableConfig;
import com.caucho.amber.cfg.EntityConfig;
import com.caucho.amber.cfg.IdClassConfig;
import com.caucho.amber.cfg.IdConfig;
import com.caucho.amber.cfg.InheritanceConfig;
import com.caucho.amber.cfg.MappedSuperclassConfig;
import com.caucho.amber.cfg.PrimaryKeyJoinColumnConfig;
import com.caucho.amber.cfg.SecondaryTableConfig;
import com.caucho.amber.cfg.TableConfig;
import com.caucho.amber.field.SubId;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.amber.type.PrimitiveCharType;
import com.caucho.amber.type.PrimitiveIntType;
import com.caucho.amber.type.StringType;
import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Table;

public class EntityIntrospector
extends BaseConfigIntrospector {
    private static final L10N L = new L10N(EntityIntrospector.class);
    private static final Logger log = Logger.getLogger(EntityIntrospector.class.getName());

    EntityIntrospector(AmberConfigManager manager) {
        super(manager);
    }

    public boolean isEntity(Class type) {
        this.getInternalEntityConfig(type, this._annotationCfg);
        return !this._annotationCfg.isNull();
    }

    public AmberBeanType introspect(Class type) throws ConfigException, SQLException {
        AbstractEnhancedType beanType = null;
        try {
            EntityType entityType = null;
            EntityType parentType = this.introspectParent(type.getSuperclass());
            entityType = this.introspectEntityType(type, parentType);
            if (entityType == null) {
                entityType = this.introspectMappedType(type, parentType);
            }
            if (entityType == null) {
                return this.introspectEmbeddableType(type);
            }
            beanType = entityType;
            entityType.setInstanceClassName(type.getName() + "__ResinExt");
            entityType.setEnhanced(true);
            MappedSuperclassConfig mappedSuperOrEntityConfig = this.introspectEntityConfig(type);
            entityType.setParentType(parentType);
            this.introspectTable(type, entityType, parentType);
            this.introspectInheritance(type, entityType, parentType);
            this.introspectTableCache(entityType, type);
            this.getInternalIdClassConfig(type, this._annotationCfg);
            IdClass idClassAnn = (IdClass)this._annotationCfg.getAnnotation();
            IdClassConfig idClassConfig = this._annotationCfg.getIdClassConfig();
            Class idClass = null;
            if (!this._annotationCfg.isNull()) {
                if (idClassAnn != null) {
                    idClass = idClassAnn.value();
                } else {
                    String s = idClassConfig.getClassName();
                    idClass = this._persistenceUnit.loadTempClass(s);
                }
                this._persistenceUnit.addEntityClass(idClass.getName(), idClass);
            }
            if (entityType.getId() == null) {
                if (entityType.isFieldAccess()) {
                    this.introspectIdField(this._persistenceUnit, entityType, parentType, type, idClass, mappedSuperOrEntityConfig);
                } else {
                    this.introspectIdMethod(this._persistenceUnit, entityType, parentType, type, idClass, mappedSuperOrEntityConfig);
                }
            }
            HashMap<String, IdConfig> idMap = null;
            AttributesConfig attributes = null;
            if (mappedSuperOrEntityConfig != null && (attributes = mappedSuperOrEntityConfig.getAttributes()) != null) {
                idMap = attributes.getIdMap();
            }
            if (entityType.isEntity() && entityType.getId() == null && (idMap == null || idMap.size() == 0)) {
                throw new ConfigException(L.l("{0} does not have any primary keys.  Entities must have at least one @Id or exactly one @EmbeddedId field.", (Object)entityType.getName()));
            }
            this.introspectAttributeOverrides(entityType, type);
            this.introspectSecondaryTable(entityType, type);
            if (entityType.isFieldAccess()) {
                this.introspectFields(this._persistenceUnit, entityType, parentType, type, mappedSuperOrEntityConfig, false);
            } else {
                this.introspectMethods(this._persistenceUnit, entityType, parentType, type, mappedSuperOrEntityConfig);
            }
            this.introspectCallbacks(type, entityType);
            this.introspectEntityListeners(type, entityType, this._persistenceUnit);
            this.introspectSqlResultSetMappings(type, entityType, entityType.getName());
            this.introspectNamedQueries(type, entityType.getName());
            this.introspectNamedNativeQueries(type, entityType.getName());
        }
        catch (ConfigException e) {
            if (beanType != null) {
                beanType.setConfigException(e);
            }
            throw e;
        }
        catch (SQLException e) {
            if (beanType != null) {
                beanType.setConfigException(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (beanType != null) {
                beanType.setConfigException(e);
            }
            throw e;
        }
        return beanType;
    }

    private EntityType introspectEntityType(Class type, EntityType parentType) throws SQLException {
        String entityName;
        boolean isEntity;
        this.getInternalEntityConfig(type, this._annotationCfg);
        Entity entityAnn = (Entity)this._annotationCfg.getAnnotation();
        EntityConfig entityConfig = this._annotationCfg.getEntityConfig();
        boolean bl = isEntity = !this._annotationCfg.isNull();
        if (!isEntity) {
            return null;
        }
        if (entityConfig != null) {
            String typeName = entityConfig.getClassName();
        } else {
            String typeName = entityAnn.name();
        }
        Object inheritanceAnn = null;
        Object inheritanceConfig = null;
        Class rootClass = type;
        Object rootEntityAnn = null;
        Object rootEntityConfig = null;
        this.validateType(type, true);
        if (entityConfig == null) {
            entityName = entityAnn.name();
        } else {
            entityName = entityConfig.getClassName();
            int p = entityName.lastIndexOf(46);
            if (p > 0) {
                entityName = entityName.substring(p + 1);
            }
        }
        if (entityName == null || "".equals(entityName)) {
            entityName = type.getSimpleName();
        }
        EntityType entityType = this._persistenceUnit.createEntity(entityName, type);
        this._configManager.addType(type, new EntityConfig(type.getName(), this, entityType));
        boolean isField = this.isField(type, entityConfig, false);
        if (isField) {
            entityType.setFieldAccess(true);
        }
        return entityType;
    }

    private EntityType introspectMappedType(Class type, EntityType parentType) throws SQLException {
        boolean isMappedSuperclass = false;
        MappedSuperclass mappedSuperAnn = null;
        MappedSuperclassConfig mappedSuperConfig = null;
        MappedSuperclassConfig mappedSuperOrEntityConfig = null;
        this.getInternalMappedSuperclassConfig(type, this._annotationCfg);
        mappedSuperAnn = (MappedSuperclass)this._annotationCfg.getAnnotation();
        mappedSuperConfig = this._annotationCfg.getMappedSuperclassConfig();
        boolean bl = isMappedSuperclass = !this._annotationCfg.isNull();
        if (!isMappedSuperclass) {
            return null;
        }
        mappedSuperOrEntityConfig = mappedSuperConfig;
        if (mappedSuperConfig != null) {
            String string = mappedSuperConfig.getClassName();
        }
        Object inheritanceAnn = null;
        Object inheritanceConfig = null;
        Class rootClass = type;
        Object rootEntityAnn = null;
        Object rootEntityConfig = null;
        this.validateType(type, false);
        String entityName = mappedSuperConfig == null ? null : mappedSuperConfig.getSimpleClassName();
        if (entityName == null || "".equals(entityName)) {
            entityName = type.getSimpleName();
        }
        MappedSuperclassType entityType = this._persistenceUnit.createMappedSuperclass(entityName, type);
        this._configManager.addType(type, new EntityConfig(type.getName(), this, entityType));
        boolean isField = this.isField(type, mappedSuperOrEntityConfig, false);
        if (isField) {
            entityType.setFieldAccess(true);
        }
        entityType.setInstanceClassName(type.getName() + "__ResinExt");
        entityType.setEnhanced(true);
        return entityType;
    }

    private EmbeddableType introspectEmbeddableType(Class type) throws ConfigException, SQLException {
        this.getInternalEmbeddableConfig(type, this._annotationCfg);
        Embeddable embeddableAnn = (Embeddable)this._annotationCfg.getAnnotation();
        EmbeddableConfig embeddableConfig = this._annotationCfg.getEmbeddableConfig();
        String typeName = type.getName();
        EmbeddableType embeddableType = this._persistenceUnit.createEmbeddable(typeName, type);
        this._configManager.addType(type, new EmbeddableConfig(type.getName(), this, embeddableType));
        try {
            Embeddable ann;
            boolean isField = this.isField(type, embeddableConfig);
            if (isField) {
                embeddableType.setFieldAccess(true);
            }
            if ((ann = type.getAnnotation(Embeddable.class)) == null) {
                isField = true;
                embeddableType.setIdClass(true);
                this._persistenceUnit.getAmberContainer().addEmbeddable(typeName, embeddableType);
            }
            embeddableType.setInstanceClassName(type.getName() + "__ResinExt");
            embeddableType.setEnhanced(true);
            if (isField) {
                this.introspectFields(this._persistenceUnit, embeddableType, null, type, embeddableConfig, true);
            } else {
                this.introspectMethods(this._persistenceUnit, embeddableType, null, type, embeddableConfig);
            }
        }
        catch (ConfigException e) {
            if (embeddableType != null) {
                embeddableType.setConfigException(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (embeddableType != null) {
                embeddableType.setConfigException(e);
            }
            throw e;
        }
        return embeddableType;
    }

    private MappedSuperclassConfig introspectEntityConfig(Class type) throws SQLException {
        this.getInternalEntityConfig(type, this._annotationCfg);
        if (!this._annotationCfg.isNull()) {
            return this._annotationCfg.getEntityConfig();
        }
        this.getInternalMappedSuperclassConfig(type, this._annotationCfg);
        return this._annotationCfg.getMappedSuperclassConfig();
    }

    private EntityType introspectParent(Class parentClass) throws SQLException {
        if (parentClass == null) {
            return null;
        }
        this.getInternalEntityConfig(parentClass, this._annotationCfg);
        if (!this._annotationCfg.isNull()) {
            return (EntityType)this._configManager.introspect(parentClass);
        }
        if (parentClass.isAnnotationPresent(Entity.class)) {
            return (EntityType)this._configManager.introspect(parentClass);
        }
        if (parentClass.isAnnotationPresent(MappedSuperclass.class)) {
            return (EntityType)this._configManager.introspect(parentClass);
        }
        return null;
    }

    private void introspectInheritance(Class type, EntityType entityType, EntityType parentType) throws SQLException {
        boolean hasInheritance;
        this.getInternalInheritanceConfig(type, this._annotationCfg);
        Inheritance inheritanceAnn = (Inheritance)this._annotationCfg.getAnnotation();
        InheritanceConfig inheritanceConfig = this._annotationCfg.getInheritanceConfig();
        boolean bl = hasInheritance = !this._annotationCfg.isNull();
        if (!(hasInheritance || parentType != null && parentType.isEntity())) {
            return;
        }
        this.introspectDiscriminatorValue(type, entityType);
        if (parentType != null) {
            if (hasInheritance) {
                throw new ConfigException(L.l("'{0}' cannot have @Inheritance. It must be specified on the entity class that is the root of the entity class hierarchy.", (Object)type));
            }
            EntityType rootType = entityType.getRootType();
            rootType.addSubClass(entityType);
            this.getInternalPrimaryKeyJoinColumnConfig(type, this._annotationCfg);
            PrimaryKeyJoinColumn joinAnn = (PrimaryKeyJoinColumn)this._annotationCfg.getAnnotation();
            PrimaryKeyJoinColumnConfig primaryKeyJoinColumnConfig = this._annotationCfg.getPrimaryKeyJoinColumnConfig();
            if (rootType.isJoinedSubClass()) {
                this.linkInheritanceTable(rootType.getTable(), entityType.getTable(), joinAnn, primaryKeyJoinColumnConfig);
                entityType.setId(new SubId(entityType, rootType));
            }
            return;
        }
        if (!hasInheritance) {
            return;
        }
        if (inheritanceAnn != null || inheritanceConfig != null) {
            this.introspectInheritance(this._persistenceUnit, entityType, type, inheritanceAnn, inheritanceConfig);
        }
    }

    private void introspectDiscriminatorValue(Class type, EntityType entityType) {
        DiscriminatorValue discValueAnn = type.getAnnotation(DiscriminatorValue.class);
        String discriminatorValue = null;
        if (discValueAnn != null) {
            discriminatorValue = discValueAnn.value();
        }
        if (discriminatorValue == null || discriminatorValue.equals("")) {
            String name;
            discriminatorValue = name = entityType.getBeanClass().getSimpleName();
        }
        entityType.setDiscriminatorValue(discriminatorValue);
    }

    void introspectInheritance(AmberPersistenceUnit persistenceUnit, EntityType entityType, Class type, Inheritance inheritanceAnn, InheritanceConfig inheritanceConfig) throws ConfigException, SQLException {
        InheritanceType strategy = inheritanceAnn != null ? inheritanceAnn.strategy() : inheritanceConfig.getStrategy();
        switch (strategy) {
            case JOINED: {
                entityType.setJoinedSubClass(true);
            }
        }
        this.getInternalDiscriminatorColumnConfig(type, this._annotationCfg);
        DiscriminatorColumn discriminatorAnn = (DiscriminatorColumn)this._annotationCfg.getAnnotation();
        DiscriminatorColumnConfig discriminatorConfig = this._annotationCfg.getDiscriminatorColumnConfig();
        String columnName = null;
        if (discriminatorAnn != null) {
            columnName = discriminatorAnn.name();
        }
        if (columnName == null || columnName.equals("")) {
            columnName = "DTYPE";
        }
        AmberType columnType = null;
        DiscriminatorType discType = DiscriminatorType.STRING;
        if (discriminatorAnn != null) {
            discType = discriminatorAnn.discriminatorType();
        }
        switch (discType) {
            case STRING: {
                columnType = StringType.create();
                break;
            }
            case CHAR: {
                columnType = PrimitiveCharType.create();
                break;
            }
            case INTEGER: {
                columnType = PrimitiveIntType.create();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        AmberTable table = entityType.getTable();
        if (table == null) {
            return;
        }
        AmberColumn column = table.createColumn(columnName, columnType);
        if (discriminatorAnn != null) {
            column.setLength(discriminatorAnn.length());
            if (!"".equals(discriminatorAnn.columnDefinition())) {
                column.setSQLType(discriminatorAnn.columnDefinition());
            }
        } else {
            column.setNotNull(true);
            column.setLength(10);
        }
        entityType.setDiscriminator(column);
    }

    private void introspectTable(Class type, EntityType entityType, EntityType parentType) {
        boolean isEntity = !(entityType instanceof MappedSuperclassType);
        Object table = null;
        this.getInternalTableConfig(type, this._annotationCfg);
        Table tableAnn = (Table)this._annotationCfg.getAnnotation();
        TableConfig tableConfig = this._annotationCfg.getTableConfig();
        String tableName = null;
        if (tableAnn != null) {
            tableName = tableAnn.name();
        } else if (tableConfig != null) {
            tableName = tableConfig.getName();
        }
        if (isEntity) {
            boolean hasTableConfig = true;
            if (tableName == null || tableName.equals("")) {
                hasTableConfig = false;
                tableName = EntityIntrospector.toSqlName(entityType.getName());
            }
            if (!entityType.isEntity()) {
                return;
            }
            if (parentType == null || parentType.getTable() == null) {
                entityType.setTable(this._persistenceUnit.createTable(tableName));
            } else if (parentType.isJoinedSubClass()) {
                entityType.setTable(this._persistenceUnit.createTable(tableName));
                EntityType rootType = parentType.getRootType();
                Class rootClass = rootType.getBeanClass();
                this.getInternalTableConfig(rootClass, this._annotationCfg);
                Table rootTableAnn = (Table)this._annotationCfg.getAnnotation();
                TableConfig rootTableConfig = this._annotationCfg.getTableConfig();
                String rootTableName = null;
                if (rootTableAnn != null) {
                    rootTableName = rootTableAnn.name();
                } else if (rootTableConfig != null) {
                    rootTableName = rootTableConfig.getName();
                }
                if (rootTableName == null || rootTableName.equals("")) {
                    String rootEntityName = rootType.getName();
                    rootTableName = EntityIntrospector.toSqlName(rootEntityName);
                }
                entityType.setRootTableName(rootTableName);
            } else {
                entityType.setTable(parentType.getTable());
            }
        }
    }

    private void introspectSecondaryTable(EntityType entityType, Class type) {
        this.getInternalSecondaryTableConfig(type, this._annotationCfg);
        SecondaryTable secondaryTableAnn = (SecondaryTable)this._annotationCfg.getAnnotation();
        SecondaryTableConfig secondaryTableConfig = this._annotationCfg.getSecondaryTableConfig();
        AmberTable secondaryTable = null;
        if (secondaryTableAnn != null || secondaryTableConfig != null) {
            String secondaryName = secondaryTableAnn != null ? secondaryTableAnn.name() : secondaryTableConfig.getName();
            secondaryTable = this._persistenceUnit.createTable(secondaryName);
            entityType.addSecondaryTable(secondaryTable);
        }
        if (secondaryTableAnn != null) {
            PrimaryKeyJoinColumn[] joinAnn = secondaryTableAnn.pkJoinColumns();
            this.linkSecondaryTable(entityType.getTable(), secondaryTable, joinAnn);
        }
    }

    private void introspectTableCache(EntityType entityType, Class type) {
        AmberTableCache tableCache = type.getAnnotation(AmberTableCache.class);
        if (tableCache != null) {
            entityType.getTable().setReadOnly(tableCache.readOnly());
            long cacheTimeout = Period.toPeriod(tableCache.timeout());
            entityType.getTable().setCacheTimeout(cacheTimeout);
        }
    }

    private void introspectAttributeOverrides(EntityType entityType, Class type) {
        EntityType parent = entityType.getParentType();
        if (parent == null) {
            return;
        }
        boolean isAbstract = Modifier.isAbstract(parent.getBeanClass().getModifiers());
        if (parent.isEntity() && !isAbstract) {
            return;
        }
        HashMap<String, ColumnConfig> overrideMap = new HashMap<String, ColumnConfig>();
        this.getInternalAttributeOverrideConfig(type, this._annotationCfg);
        AttributeOverride attributeOverrideAnn = (AttributeOverride)this._annotationCfg.getAnnotation();
        boolean hasAttributeOverride = attributeOverrideAnn != null;
        AttributeOverrides attributeOverridesAnn = type.getAnnotation(AttributeOverrides.class);
        ArrayList<AttributeOverrideConfig> attributeOverrideList = null;
        EntityConfig entityConfig = this.getEntityConfig(type.getName());
        if (entityConfig != null) {
            attributeOverrideList = entityConfig.getAttributeOverrideList();
        }
        boolean hasAttributeOverrides = false;
        if (attributeOverrideList != null && attributeOverrideList.size() > 0) {
            hasAttributeOverrides = true;
        } else if (attributeOverridesAnn != null) {
            hasAttributeOverrides = true;
        }
        if (hasAttributeOverride && hasAttributeOverrides) {
            throw new ConfigException(L.l("{0} may not have both @AttributeOverride and @AttributeOverrides", (Object)type));
        }
        if (attributeOverrideList == null) {
            attributeOverrideList = new ArrayList();
        }
        if (hasAttributeOverride) {
            AttributeOverrideConfig attOverrideConfig = EntityIntrospector.convertAttributeOverrideAnnotationToConfig((Annotation)attributeOverrideAnn);
            attributeOverrideList.add(attOverrideConfig);
        } else if (hasAttributeOverrides && attributeOverrideList.size() <= 0) {
            AttributeOverride[] attributeOverrideArray = attributeOverridesAnn.value();
        }
        for (AttributeOverrideConfig override : attributeOverrideList) {
            overrideMap.put(override.getName(), override.getColumn());
        }
        this._depCompletions.add(new AttributeOverrideCompletion(this, entityType, type, overrideMap));
    }

    boolean isField(Class type, AbstractEnhancedConfig typeConfig) throws ConfigException {
        for (Method method : type.getDeclaredMethods()) {
            Annotation[] ann = method.getDeclaredAnnotations();
            for (int i = 0; ann != null && i < ann.length; ++i) {
                if (!(ann[i] instanceof Basic) && !(ann[i] instanceof Column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPropertyAnnotation(Class cl) {
        return Basic.class.equals((Object)cl) || Column.class.equals((Object)cl);
    }
}

