/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractRelationConfig;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.cfg.PrimaryKeyJoinColumnConfig;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;

class OneToOneConfig
extends AbstractRelationConfig {
    private static final L10N L = new L10N(OneToOneConfig.class);
    private BaseConfigIntrospector _introspector;
    private EntityType _sourceType;
    private EntityType _targetType;
    private AccessibleObject _field;
    private String _fieldName;
    private Class _fieldType;
    private boolean _isOptional;
    private String _mappedBy;
    private HashMap<String, PrimaryKeyJoinColumnConfig> _primaryKeyJoinColumnMap = new HashMap();
    private HashMap<String, JoinColumnConfig> _joinColumnMap = new HashMap();

    OneToOneConfig(BaseConfigIntrospector introspector, EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) {
        this._introspector = introspector;
        this._sourceType = sourceType;
        this._field = field;
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        this.introspect();
    }

    public boolean getOptional() {
        return this._isOptional;
    }

    public void setOptional(boolean isOptional) {
        this._isOptional = isOptional;
    }

    public String getMappedBy() {
        return this._mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this._mappedBy = mappedBy;
    }

    public boolean isOwningSide() {
        return "".equals(this._mappedBy);
    }

    public PrimaryKeyJoinColumnConfig getPrimaryKeyJoinColumn(String columnName) {
        return this._primaryKeyJoinColumnMap.get(columnName);
    }

    public void addPrimaryKeyJoinColumn(PrimaryKeyJoinColumnConfig primaryKeyJoinColumn) {
        this._primaryKeyJoinColumnMap.put(primaryKeyJoinColumn.getName(), primaryKeyJoinColumn);
    }

    public HashMap<String, PrimaryKeyJoinColumnConfig> getPrimaryKeyJoinColumnMap() {
        return this._primaryKeyJoinColumnMap;
    }

    public JoinColumnConfig getJoinColumn(String name) {
        return this._joinColumnMap.get(name);
    }

    public void addJoinColumn(JoinColumnConfig joinColumn) {
        this._joinColumnMap.put(joinColumn.getName(), joinColumn);
    }

    public HashMap<String, JoinColumnConfig> getJoinColumnMap() {
        return this._joinColumnMap;
    }

    private void introspect() {
        OneToOne oneToOne = this._field.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            this.introspectOneToOne(oneToOne);
        }
        JoinColumn joinColumnAnn = this._field.getAnnotation(JoinColumn.class);
        JoinColumns joinColumnsAnn = this._field.getAnnotation(JoinColumns.class);
        if (joinColumnsAnn != null && joinColumnAnn != null) {
            throw OneToOneConfig.error(this._field, L.l("{0} may not have both @JoinColumn and @JoinColumns", (Object)this._fieldName));
        }
        if (joinColumnsAnn != null) {
            this.introspectJoinColumns(joinColumnsAnn.value());
        } else if (joinColumnAnn != null) {
            this.introspectJoinColumns(new JoinColumn[]{joinColumnAnn});
        }
    }

    private void introspectOneToOne(OneToOne oneToOne) {
        Class targetClass = oneToOne.targetEntity();
        if (Void.TYPE.equals(targetClass)) {
            targetClass = this._fieldType;
        }
        this.setTargetEntity(targetClass);
        this.setCascadeTypes(oneToOne.cascade());
        this.setFetch(oneToOne.fetch());
        this._isOptional = oneToOne.optional();
        this._mappedBy = oneToOne.mappedBy();
    }

    private void introspectJoinColumns(JoinColumn[] joinColumns) {
        for (JoinColumn joinColumn : joinColumns) {
            this.addJoinColumn(new JoinColumnConfig(joinColumn));
        }
    }

    @Override
    public EntityType getRelatedType() {
        return this._sourceType;
    }

    @Override
    public void complete() {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        String targetName = this._fieldType.getName();
        EntityType targetType = persistenceUnit.createEntity(this.getTargetEntity());
        if (this.isOwningSide()) {
            this.addManyToOne();
        } else {
            this.addDependentOneToOne();
        }
    }

    private void addManyToOne() throws ConfigException {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        EntityType targetType = persistenceUnit.createEntity(this.getTargetEntity());
        ManyToOneField manyToOneField = new ManyToOneField(this._sourceType, this._fieldName, this.getCascade(), false);
        manyToOneField.setType(targetType);
        manyToOneField.setLazy(this.isFetchLazy());
        manyToOneField.setJoinColumnMap(this._joinColumnMap);
        this._sourceType.addField(manyToOneField);
        if (this._sourceType instanceof MappedSuperclassType) {
            return;
        }
        this.validateJoinColumns(this._field, this._fieldName, this._joinColumnMap, targetType);
        manyToOneField.init();
    }

    private void addDependentOneToOne() {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        EntityType targetType = persistenceUnit.createEntity(this.getTargetEntity());
        ManyToOneField sourceField = this.getSourceField(targetType, this._mappedBy, this._sourceType);
        if (sourceField == null) {
            throw OneToOneConfig.error(this._field, L.l("OneToOne target '{0}' does not have a matching ManyToOne relation.", (Object)targetType.getName()));
        }
        DependentEntityOneToOneField oneToOne = new DependentEntityOneToOneField(this._sourceType, this._fieldName, this.getCascade());
        oneToOne.setTargetField(sourceField);
        sourceField.setTargetField(oneToOne);
        oneToOne.setLazy(this.isFetchLazy());
        this._sourceType.addField(oneToOne);
    }

    private ManyToOneField getSourceField(EntityType targetType, String mappedBy, EntityType sourceType) {
        do {
            ArrayList<AmberField> fields = targetType.getFields();
            for (AmberField field : fields) {
                if (!("".equals(mappedBy) || mappedBy == null ? field.getJavaType().isAssignableFrom(sourceType.getBeanClass()) : field.getName().equals(mappedBy))) continue;
                return (ManyToOneField)field;
            }
        } while ((targetType = targetType.getParentType()) != null);
        return null;
    }
}

