/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.PrimitiveIntType;
import com.caucho.util.CharBuffer;

public class EnumExpr
extends AbstractAmberExpr {
    private Class _javaType;
    private String _name;
    private int _ordinal;
    private boolean _isOrdinal = true;

    public EnumExpr(Class javaType, String name, int ordinal) {
        this._javaType = javaType;
        this._name = name;
        this._ordinal = ordinal;
    }

    @Override
    public AmberType getType() {
        return PrimitiveIntType.create();
    }

    public Class getJavaType() {
        return this._javaType;
    }

    public int getOrdinal() {
        return this._ordinal;
    }

    public boolean isOrdinal() {
        return this._isOrdinal;
    }

    public void setOrdinal(boolean isOrdinal) {
        this._isOrdinal = isOrdinal;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        if (this._isOrdinal) {
            cb.append(this._ordinal);
        } else {
            cb.append('\'');
            cb.append(this._name);
            cb.append('\'');
        }
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateWhere(cb);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    public String toString() {
        return "EnumExpr[" + this._javaType.getName() + "." + this._name + "(" + this._ordinal + ")]";
    }
}

