/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.field.StubMethod;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class AbstractEnhancedType
extends AmberType {
    private static final Logger log = Logger.getLogger(AbstractEnhancedType.class.getName());
    private static final L10N L = new L10N(AbstractEnhancedType.class);
    AmberPersistenceUnit _amberPersistenceUnit;
    Class _tBeanClass;
    private String _className;
    private Class _javaBeanClass;
    private String _name;
    private String _instanceClassName;
    private ClassLoader _instanceLoader;
    private Class _instanceClass;
    private boolean _isIdClass;
    private boolean _isEnhanced;
    private volatile boolean _isGenerated;
    private Object _instance;
    private Throwable _exception;
    private ArrayList<StubMethod> _methods = new ArrayList();
    private ArrayList<Method> _postLoadCallbacks = new ArrayList();
    private ArrayList<Method> _prePersistCallbacks = new ArrayList();
    private ArrayList<Method> _postPersistCallbacks = new ArrayList();
    private ArrayList<Method> _preUpdateCallbacks = new ArrayList();
    private ArrayList<Method> _postUpdateCallbacks = new ArrayList();
    private ArrayList<Method> _preRemoveCallbacks = new ArrayList();
    private ArrayList<Method> _postRemoveCallbacks = new ArrayList();

    public AbstractEnhancedType(AmberPersistenceUnit amberPersistenceUnit) {
        this._amberPersistenceUnit = amberPersistenceUnit;
    }

    public AmberPersistenceUnit getPersistenceUnit() {
        return this._amberPersistenceUnit;
    }

    public Throwable getConfigException() {
        return this._exception;
    }

    public void setConfigException(Throwable e) {
        if (this._exception == null) {
            this._exception = e;
        }
    }

    public void setBeanClass(Class beanClass) {
        this._tBeanClass = beanClass;
        this._className = beanClass.getName();
        if (this.getName() == null) {
            this.setName(beanClass.getSimpleName());
        }
    }

    public Class getBeanClass() {
        return this._tBeanClass;
    }

    public String getClassName() {
        return this._className;
    }

    public Class getJavaBeanClass() {
        if (this._javaBeanClass == null) {
            try {
                Thread thread = Thread.currentThread();
                ClassLoader loader = thread.getContextClassLoader();
                this._javaBeanClass = Class.forName(this.getClassName(), false, loader);
            }
            catch (ClassNotFoundException e) {
                throw new AmberRuntimeException(e);
            }
        }
        return this._javaBeanClass;
    }

    public String getComponentInterfaceName() {
        return null;
    }

    public ClassComponent getComponentGenerator() {
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setInstance(Object instance) {
        this._instance = instance;
    }

    public Object getInstance() {
        if (this._instance == null) {
            try {
                this._instance = this.getInstanceClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._instance;
    }

    public void setInstanceClassLoader(ClassLoader loader) {
        this._instanceLoader = loader;
    }

    public boolean isInit() {
        return this._instanceClass != null;
    }

    public Class getInstanceClass() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected Class getInstanceClass(Class validationInterface) {
        if (this._instanceClass == null) {
            if (this.getInstanceClassName() == null) {
                throw new RuntimeException("No instance class:" + this);
            }
            try {
                if (this.isEnhanced()) {
                    ClassLoader loader = this.getPersistenceUnit().getEnhancedLoader();
                    this._instanceClass = Class.forName(this.getBeanClass().getName(), false, loader);
                } else {
                    ClassLoader loader = this._instanceLoader;
                    if (loader == null) {
                        loader = this.getPersistenceUnit().getEnhancedLoader();
                    }
                    this._instanceClass = Class.forName(this.getInstanceClassName(), false, loader);
                }
            }
            catch (ClassNotFoundException e) {
                throw new AmberRuntimeException(e);
            }
            if (!validationInterface.isAssignableFrom(this._instanceClass)) {
                if (this.getConfigException() != null) {
                    throw new AmberRuntimeException(this.getConfigException());
                }
                if (this._amberPersistenceUnit.getConfigException() != null) {
                    throw new AmberRuntimeException(this._amberPersistenceUnit.getConfigException());
                }
                throw new AmberRuntimeException(L.l("'{0}' with classloader {1} is an illegal instance class.  The class has not been enhanced as implementing {2}.", (Object)this._instanceClass.getName(), (Object)this._instanceClass.getClassLoader(), (Object)validationInterface));
            }
        }
        return this._instanceClass;
    }

    public void setInstanceClassName(String className) {
        this._instanceClassName = className;
    }

    public String getInstanceClassName() {
        return this._instanceClassName;
    }

    public void setEnhanced(boolean isEnhanced) {
        this._isEnhanced = isEnhanced;
    }

    public boolean isEnhanced() {
        return this._isEnhanced;
    }

    public void setIdClass(boolean isIdClass) {
        this._isIdClass = isIdClass;
    }

    public boolean isIdClass() {
        return this._isIdClass;
    }

    public boolean isGenerated() {
        return this._isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        if (this.isEnhanced()) {
            this._isGenerated = isGenerated;
        }
    }

    public void addStubMethod(StubMethod method) {
        this._methods.add(method);
    }

    public ArrayList<StubMethod> getMethods() {
        return this._methods;
    }

    public void addPostLoadCallback(Method callback) {
        this._postLoadCallbacks.add(callback);
    }

    public ArrayList<Method> getPostLoadCallbacks() {
        return this._postLoadCallbacks;
    }

    public void addPrePersistCallback(Method callback) {
        this._prePersistCallbacks.add(callback);
    }

    public ArrayList<Method> getPrePersistCallbacks() {
        return this._prePersistCallbacks;
    }

    public void addPostPersistCallback(Method callback) {
        this._postPersistCallbacks.add(callback);
    }

    public ArrayList<Method> getPostPersistCallbacks() {
        return this._postPersistCallbacks;
    }

    public void addPreUpdateCallback(Method callback) {
        this._preUpdateCallbacks.add(callback);
    }

    public ArrayList<Method> getPreUpdateCallbacks() {
        return this._preUpdateCallbacks;
    }

    public void addPostUpdateCallback(Method callback) {
        this._postUpdateCallbacks.add(callback);
    }

    public ArrayList<Method> getPostUpdateCallbacks() {
        return this._postUpdateCallbacks;
    }

    public void addPreRemoveCallback(Method callback) {
        this._preRemoveCallbacks.add(callback);
    }

    public ArrayList<Method> getPreRemoveCallbacks() {
        return this._preRemoveCallbacks;
    }

    public void addPostRemoveCallback(Method callback) {
        this._postRemoveCallbacks.add(callback);
    }

    public ArrayList<Method> getPostRemoveCallbacks() {
        return this._postRemoveCallbacks;
    }

    public ArrayList<Method> getCallbacks(int callbackIndex) {
        switch (callbackIndex) {
            case 1: {
                return this._prePersistCallbacks;
            }
            case 2: {
                return this._postPersistCallbacks;
            }
            case 3: {
                return this._preRemoveCallbacks;
            }
            case 4: {
                return this._postRemoveCallbacks;
            }
            case 5: {
                return this._preUpdateCallbacks;
            }
            case 6: {
                return this._postUpdateCallbacks;
            }
            case 7: {
                return this._postLoadCallbacks;
            }
        }
        return null;
    }

    public void addCallback(int callbackIndex, Method callback) {
        switch (callbackIndex) {
            case 1: {
                this._prePersistCallbacks.add(callback);
                break;
            }
            case 2: {
                this._postPersistCallbacks.add(callback);
                break;
            }
            case 3: {
                this._preRemoveCallbacks.add(callback);
                break;
            }
            case 4: {
                this._postRemoveCallbacks.add(callback);
                break;
            }
            case 5: {
                this._preUpdateCallbacks.add(callback);
                break;
            }
            case 6: {
                this._postUpdateCallbacks.add(callback);
                break;
            }
            case 7: {
                this._postLoadCallbacks.add(callback);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

