/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.client;

import com.caucho.amqp.AmqpException;
import com.caucho.amqp.AmqpSender;
import com.caucho.amqp.client.AmqpClientConnectionImpl;
import com.caucho.amqp.client.AmqpClientSenderFactory;
import com.caucho.amqp.client.AmqpClientSenderLink;
import com.caucho.amqp.common.AmqpSession;
import com.caucho.amqp.io.AmqpStreamWriter;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.MessageHeader;
import com.caucho.amqp.marshal.AmqpMessageEncoder;
import com.caucho.message.MessagePropertiesFactory;
import com.caucho.message.MessageSettleListener;
import com.caucho.message.common.AbstractMessageSender;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

class AmqpClientSender<T>
extends AbstractMessageSender<T>
implements AmqpSender<T> {
    private static final Logger log = Logger.getLogger(AmqpClientSender.class.getName());
    private AmqpClientConnectionImpl _client;
    private AmqpSession _session;
    private final String _address;
    private final AmqpMessageEncoder<T> _encoder;
    private final Map<String, Object> _attachProperties;
    private final Map<String, Object> _sourceProperties;
    private final Map<String, Object> _targetProperties;
    private AmqpClientSenderLink _link;
    private long _lastMessageId;

    AmqpClientSender(AmqpClientConnectionImpl client, AmqpSession session, AmqpClientSenderFactory builder) {
        super(builder);
        this._client = client;
        this._session = session;
        this._address = builder.getAddress();
        this._encoder = this.getMessageEncoder(builder);
        this._attachProperties = builder.getAttachProperties() != null ? new HashMap<String, Object>(builder.getAttachProperties()) : null;
        this._sourceProperties = builder.getSourceProperties() != null ? new HashMap<String, Object>(builder.getSourceProperties()) : null;
        this._targetProperties = builder.getTargetProperties() != null ? new HashMap<String, Object>(builder.getTargetProperties()) : null;
        int linkId = this._client.nextLinkId();
        this._link = new AmqpClientSenderLink("client-" + this._address + "-" + linkId, this._address, this);
        this._session.addSenderLink(this._link, builder.getSettleMode());
    }

    Map<String, Object> getAttachProperties() {
        return this._attachProperties;
    }

    Map<String, Object> getSourceProperties() {
        return this._sourceProperties;
    }

    Map<String, Object> getTargetProperties() {
        return this._targetProperties;
    }

    private AmqpMessageEncoder<T> getMessageEncoder(AmqpClientSenderFactory factory) {
        return factory.getEncoder();
    }

    @Override
    protected boolean offerMicros(MessagePropertiesFactory<T> factory, T value, long timeoutMicros) {
        try {
            if (!this.waitForAvailable(timeoutMicros)) {
                return false;
            }
            TempOutputStream tOut = new TempOutputStream();
            WriteStream os = Vfs.openWrite(tOut);
            AmqpStreamWriter sout = new AmqpStreamWriter(os);
            AmqpWriter aout = new AmqpWriter();
            aout.initBase(sout);
            MessageHeader header = new MessageHeader();
            header.setDurable(this._encoder.isDurable(factory, value));
            header.setPriority(this._encoder.getPriority(factory, value));
            header.setTimeToLive(this._encoder.getTimeToLive(factory, value));
            header.setFirstAcquirer(this._encoder.isFirstAcquirer(factory, value));
            header.setDeliveryCount(0);
            header.write(aout);
            this._encoder.encode(aout, factory, value);
            sout.flush();
            os.flush();
            tOut.flush();
            tOut.close();
            this._lastMessageId = this._link.transfer(this.getSettleMode(), tOut.getInputStream());
            return true;
        }
        catch (IOException e) {
            throw new AmqpException(e);
        }
    }

    private boolean waitForAvailable(long micros) {
        return this.remainingCapacity() > 0;
    }

    @Override
    public int remainingCapacity() {
        return this._link.getLinkCredit();
    }

    @Override
    public long getLastMessageId() {
        return this._lastMessageId;
    }

    public void accepted(long messageId) {
    }

    void onAccepted(long messageId) {
        MessageSettleListener listener = this.getSettleListener();
        if (listener != null) {
            listener.onAccept(messageId);
        }
    }

    @Override
    public void close() {
        this._link.detach();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + "," + this._link.getName() + "]";
    }
}

